/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.authorizationdetails.domain.InvalidAuthorizationDetailException;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientLogoutMode;
import org.sourceid.oauth20.domain.ClientUtil;
import org.sourceid.oauth20.domain.InvalidRequestedScopeException;
import org.sourceid.oauth20.domain.ParServerPolicy;
import org.sourceid.oauth20.domain.PersistentGrantHelper;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.handlers.AttributesHolder;
import org.sourceid.oauth20.handlers.AuthenticationClaimHolder;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.openid.connect.IdTokenClaims;
import org.sourceid.openid.connect.IdTokenSupport;
import org.sourceid.openid.connect.LeftHalfHash;
import org.sourceid.openid.connect.OfflineAccessSupport;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.openid.connect.model.Prompt;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.OidcSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.UriValidationUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.idp.SsoRespSupport;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class AuthorizationRequestSupport {
    private static final String REQUIRE_OIDC_REDIRECT_URI = "require-oidc-redirect-uri";
    private static final String OIDC_SPECIFICATION_COMPLIANCE = "oidc-specification-compliance";
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConfigStore oidcConfig = ConfigStoreFarm.getConfig("oidc-specification-compliance");
    private final boolean requireRedirectUri = this.oidcConfig.getBooleanValue("require-oidc-redirect-uri", false);
    private final SsoRespSupport ssoRespSupport = new SsoRespSupport();
    private final ConnectProviderRuntimePolicySupport policySupport = new ConnectProviderRuntimePolicySupport();
    private final AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
    private final BearerAccessTokenMgmtPluginManager tokenPluginManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();
    private final IdTokenSupport idTokenSupport = new IdTokenSupport();
    private final OfflineAccessSupport offlineAccessSupport = new OfflineAccessSupport();

    public IdTokenClaims checkCreateIdTokenClaims(InMessageContext inMsgCtx, Client client, Scope scope, AttributesHolder attrHolder, String ctxQual, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> otherState, ResponseType responseType, AccessGrant accessGrant, String grantType, Set<String> resources) throws AuthorizationRequestException, AttrLookupException, AuthorizationException {
        if (scope.hasScope("openid") && GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class).getPolicy().isEnabled()) {
            String virtualHostName;
            UserKeyAttributes userKeyAttributes = attrHolder.getUserKeyAttributes();
            OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.policySupport.getPolicyGroup(client);
            String sri = StateMgmtFactory.getExtendedSriV2(req, resp, otherState);
            AccessGrantAttributesHolder grantAttrsHolder = new AccessGrantAttributesHolder(userKeyAttributes.getExtendedAttributes(), attrHolder.getAuthnResult().getAuthnAttrs());
            AttributeMap accessTokenAttrs = HandlerUtil.mapToAccessTokenAttrs(userKeyAttributes.getUserKeyValue(), grantAttrsHolder, ctxQual, scope, client, req, policyGroup.getAccessTokenManagerId(), this.authzServerManager, this.tokenPluginManager, accessGrant, grantType, null, resources, sri);
            IdpAuthenticationResult authnResult = attrHolder.getAuthnResult();
            AttributeValue authnCtxValue = this.ssoRespSupport.getAuthnCtxFromAuthnAttrs(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans(), null);
            String acr = null;
            if (authnCtxValue != null) {
                acr = authnCtxValue.getValue();
            }
            Calendar authnCal = this.ssoRespSupport.getAuthnInstantValue(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans(), false);
            Long authnTime = null;
            if (authnCal != null) {
                NumericDate time = NumericDate.fromMilliseconds((long)authnCal.getTimeInMillis());
                authnTime = time.getValue();
            }
            AuthenticationClaimHolder authenticationClaimHolder = null;
            if (authnTime != null || StringUtils.isNotEmpty((String)acr)) {
                authenticationClaimHolder = new AuthenticationClaimHolder(authnTime, null, null, null, acr);
            }
            String issuer = (virtualHostName = (String)otherState.remove("currentServerBaseUrl")) != null ? virtualHostName : this.oAuthIssuerUtils.getIssuerValue(req);
            boolean allClaimsInToken = responseType.isReturnClaimsInIdToken();
            PersistentGrantHelper.addExpiresAtToAttributeMap(accessGrant, client, this.authzServerManager, userKeyAttributes);
            IdTokenClaims idTokenClaims = this.idTokenSupport.baselineClaims(accessTokenAttrs, client, scope, req, issuer, authenticationClaimHolder, allClaimsInToken, userKeyAttributes, sri, policyGroup);
            String subjectValue = (String)idTokenClaims.claims.get("sub");
            String idTokenHintSubject = inMsgCtx.getParam("id_token_hint");
            if (StringUtils.isNotBlank((String)idTokenHintSubject) && !StringUtils.equals((String)idTokenHintSubject, (String)subjectValue)) {
                String msg = "Unable to satisfy the requested subject from the id_token_hint (requested sub value does not match that of the current end-user).";
                Prompt prompt = new Prompt(inMsgCtx.getParam("prompt"));
                AuthorizationRequestException.Error error = prompt.isNone() ? AuthorizationRequestException.Error.login_required : AuthorizationRequestException.Error.access_denied;
                throw new AuthorizationRequestException(error, msg);
            }
            String nonce = inMsgCtx.getParam("nonce");
            if (nonce != null || idTokenClaims.standardClaims.get("nonce") != null) {
                Object value = this.idTokenSupport.selectOverrideValue("nonce", (Object)nonce, idTokenClaims.standardClaims);
                idTokenClaims.claims.put("nonce", value);
            }
            return idTokenClaims;
        }
        return null;
    }

    private void populateAuthenticationClaims(OutMessageContext outMessageContext, Map<String, Object> claims) {
        if (claims.get("auth_time") != null) {
            AuthenticationClaimHolder authenticationClaimHolder = new AuthenticationClaimHolder((Long)claims.get("auth_time"), (String)claims.get("nonce"), (String)claims.get("c_hash"), (String)claims.get("s_hash"), (String)claims.get("acr"));
            outMessageContext.setSupplementalContext("AUTHENTICATION_CLAIMS", authenticationClaimHolder);
        }
    }

    public String checkCreateIdToken(HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMessageContext, IdTokenClaims idTokenClaims, Client client, String accessToken, String code, String redirectUri, Map<String, Object> otherState, AttributesHolder attrHolder, String relayState) throws AuthorizationRequestException {
        String serialization = null;
        if (idTokenClaims != null) {
            Map<String, Object> claims = idTokenClaims.claims;
            Map<String, Object> openIdStandardClaims = idTokenClaims.standardClaims;
            String jwsAlgo = client.getIdTokenSigningAlgorithm(true);
            if (openIdStandardClaims.get("c_hash") != null) {
                claims.put("c_hash", openIdStandardClaims.get("c_hash"));
            } else if (code != null) {
                String cHash = LeftHalfHash.leftHalfHashToBase64UrlString(code, jwsAlgo);
                claims.put("c_hash", cHash);
            }
            if (openIdStandardClaims.get("at_hash") != null) {
                claims.put("at_hash", openIdStandardClaims.get("at_hash"));
            } else if (accessToken != null) {
                String atHash = LeftHalfHash.leftHalfHashToBase64UrlString(accessToken, jwsAlgo);
                claims.put("at_hash", atHash);
            }
            OpenIdConnectProviderPolicy.PolicyGroup providerPolicy = this.policySupport.getPolicyGroup(client);
            if (openIdStandardClaims.get("s_hash") != null) {
                claims.put("s_hash", openIdStandardClaims.get("s_hash"));
            } else if (StringUtils.isNotBlank((String)relayState) && providerPolicy.isIncludeSHashInIdToken() && !"none".equals(client.getIdTokenSigningAlgorithm())) {
                String sHash = LeftHalfHash.leftHalfHashToBase64UrlString(relayState, jwsAlgo);
                claims.put("s_hash", sHash);
            }
            try {
                serialization = this.idTokenSupport.toToken(claims, client, req);
                this.populateAuthenticationClaims(outMessageContext, claims);
            }
            catch (JoseException e) {
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.server_error, "Unable to create id_token: " + e, e);
            }
            this.checkRegisterOidcSession(req, resp, client, redirectUri, otherState, attrHolder, claims);
        }
        return serialization;
    }

    private void checkRegisterOidcSession(HttpServletRequest req, HttpServletResponse resp, Client client, String redirectUri, Map<String, Object> otherState, AttributesHolder userAttrs, Map<String, Object> claims) {
        IdpHashableAuthnBean[] authnBeans;
        OpenIdConnectProviderPolicy providerPolicy = this.policySupport.getConnectProviderPolicyManager().getPolicy();
        if (providerPolicy.isTrackUserSessionsForLogout() && (authnBeans = (IdpHashableAuthnBean[])otherState.get("authn-bean")) != null && client.getLogoutMode() != ClientLogoutMode.NONE) {
            String baseUrl = null;
            if (client.isPingAccessLogoutCapable() && !StringUtils.isEmpty((String)redirectUri)) {
                try {
                    URL url = new URL(redirectUri);
                    baseUrl = url.getProtocol() + "://" + url.getAuthority();
                }
                catch (MalformedURLException e) {
                    this.log.warn((Object)("Invalid redirect URI: " + redirectUri), (Throwable)e);
                }
            }
            OidcSession oidcSession = new OidcSession(client.getClientId(), baseUrl, userAttrs.getUserKeyAttributes().getUserKeyValue(), this.isMaskUserKey(userAttrs));
            OAuthIssuer oAuthIssuer = OAuthIssuerUtils.getInstance().getOAuthIssuerFromRequest(req);
            if (oAuthIssuer != null) {
                oidcSession.setOAuthIssuerId(oAuthIssuer.getId());
            }
            oidcSession.setIssuer((String)claims.get("iss"));
            oidcSession.setSubject((String)claims.get("sub"));
            oidcSession.setExtendedSri(StateMgmtFactory.getExtendedSriV2(req, resp, otherState));
            IdpSessionRegistrySupport.registerSessionForSlo(req, resp, otherState, authnBeans, oidcSession);
        }
    }

    private boolean isMaskUserKey(AttributesHolder userAttrs) {
        AttributeValue userKey = (AttributeValue)userAttrs.getUserKeyAttributes().get("USER_KEY");
        return userKey == null || userKey.isMasked();
    }

    public void checkNonce(InMessageContext inMsgCtx, ResponseType responseType, Scope scope) throws AuthorizationRequestException {
        String nonce;
        if (scope.hasScope("openid") && responseType.has("id_token") && StringUtils.isEmpty((String)(nonce = inMsgCtx.getParam("nonce")))) {
            String msg = "nonce is required in the context of this request.";
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, msg);
        }
    }

    public void checkRedirect(Client client, InMessageContext inMsgContext, Scope scope) throws AuthorizationRequestException {
        String redirectUri;
        if (this.isRedirectlessAuthnAPIInit(client, inMsgContext)) {
            return;
        }
        if (scope.hasScope("openid") && this.requireRedirectUri && StringUtils.isEmpty((String)(redirectUri = inMsgContext.getParam("redirect_uri")))) {
            String msg = "redirect_uri is required in the context of this request.";
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, msg);
        }
    }

    public void checkRespType(ResponseType responseType, Client client) throws AuthorizationRequestException {
        if ("none".equals(client.getIdTokenSigningAlgorithm()) && responseType.sendsIdTokenFrontChannel()) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.unauthorized_client, "will not return an unsigned ID Token via the front channel");
        }
    }

    public void checkRequest(HttpServletRequest req) throws AuthorizationRequestException {
        this.checkNotSupported(req, "registration", AuthorizationRequestException.Error.registration_not_supported);
    }

    private void checkNotSupported(HttpServletRequest req, String paramName, AuthorizationRequestException.Error err) throws AuthorizationRequestException {
        if (req.getParameter(paramName) != null) {
            String msg = "processing of the " + paramName + " parameter is unsupported";
            throw new AuthorizationRequestException(err, msg);
        }
    }

    public void checkRedirectUri(Client client, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) throws AuthorizationRequestException {
        if (this.isRedirectlessAuthnAPIInit(client, inMsgCtx)) {
            return;
        }
        String requestedRedirectUriString = inMsgCtx.getParam("redirect_uri");
        if (StringUtils.isEmpty((String)requestedRedirectUriString) && client.getRedirectUris().size() > 1 || StringUtils.isEmpty((String)requestedRedirectUriString) && client.getRedirectUris().size() == 1 && client.getRedirectUris().get(0).contains("*")) {
            throw new AuthorizationRequestException(null, "Invalid redirect_uri");
        }
        if (client.getRedirectUris().size() == 0) {
            throw new AuthorizationRequestException(null, "The requesting client does not have redirect URIs configured.");
        }
        if (StringUtils.isEmpty((String)requestedRedirectUriString) && client.getRedirectUris().size() == 1) {
            outMsgCtx.setEndpoint(client.getRedirectUris().get(0));
        } else {
            outMsgCtx.setEndpoint(requestedRedirectUriString);
        }
        if (!StringUtils.isEmpty((String)requestedRedirectUriString)) {
            if (!UriValidationUtil.compareAsUris(requestedRedirectUriString, client.getRedirectUris(), false, false)) {
                AsAuditLogger.setDescription("Invalid redirect_uri");
                AsAuditLogger.setInMsgCtx(client, inMsgCtx);
                throw new AuthorizationRequestException(null, "Invalid redirect_uri");
            }
            outMsgCtx.setSupplementalContext("redirect_uri", requestedRedirectUriString);
        }
    }

    private boolean isRedirectlessAuthnAPIInit(Client client, InMessageContext inMsgCtx) {
        return client.getAllowAuthenticationApiInit() && StringUtils.equals((String)inMsgCtx.getParam("response_mode"), (String)ResponseType.ResponseMode.pi_flow.getIdentifier());
    }

    public ResponseType getResponseType(InMessageContext inMsgCtx, boolean validate, Client client) throws AuthorizationRequestException {
        boolean isValidModeTypeCombination;
        String rspTypeStr = inMsgCtx.getParam("response_type");
        if (StringUtils.isBlank((String)rspTypeStr)) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "response_type is required.");
        }
        String responseModeString = inMsgCtx.getParam("response_mode");
        ResponseType respType = new ResponseType(rspTypeStr, responseModeString);
        if (!validate) {
            return respType;
        }
        if (!respType.isValidResponseType()) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.unsupported_response_type);
        }
        if (!respType.isResponseModeValid()) {
            throw new AuthorizationRequestException(null, "The requested response_mode is not valid.");
        }
        boolean bl = isValidModeTypeCombination = respType.isValidModeTypeCombination() && respType.isValidJarmModeTypeCombination(client);
        if (!isValidModeTypeCombination) {
            String msg = String.format("%s %s and %s %s cannot be used together.", responseModeString, "response_mode", rspTypeStr, "response_type");
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, msg);
        }
        return respType;
    }

    public void checkClientAuthorizedForType(ResponseType responseType, Client client) throws AuthorizationRequestException {
        for (String grantType : responseType.getImpliedGrantTypes()) {
            if (client.isGrantTypeAllowed(grantType)) continue;
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.unauthorized_client, grantType + " grant not allowed for this client");
        }
        if (responseType.getResponseMode() == ResponseType.ResponseMode.pi_flow && !client.getAllowAuthenticationApiInit()) {
            String msg = String.format("OAuth client is not allowed to initiate authentication API flow via the %s response mode", new Object[]{ResponseType.ResponseMode.pi_flow});
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.unauthorized_client, msg);
        }
    }

    public Scope checkScope(InMessageContext inMsgCtx, Client client) throws AuthorizationRequestException {
        try {
            String scopeStr = inMsgCtx.getParam(Parameters.SCOPE);
            Scope requestedScope = Scope.getScope((String)scopeStr);
            ScopeUtil.validateRequestedScope(requestedScope, client);
            return requestedScope;
        }
        catch (InvalidRequestedScopeException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_scope, e.getMessage());
        }
    }

    private void checkAuthorizationDetails(InMessageContext inMsgCtx, Client client, HttpServletRequest request, Scope scope) throws AuthorizationRequestException {
        try {
            String authorizationDetailsStr = inMsgCtx.getParam("authorization_details");
            if (authorizationDetailsStr != null) {
                AuthorizationDetails authorizationDetails = new AuthorizationDetails(authorizationDetailsStr);
                AuthorizationDetailsUtil.validate(authorizationDetails, client, request, scope);
            }
        }
        catch (IOException | InvalidAuthorizationDetailException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_authorization_details, e.getMessage());
        }
    }

    public void checkCodeChallengeIsRequired(InMessageContext inMsgCtx, Client client, ResponseType responseType) throws AuthorizationRequestException {
        String codeChallenge = inMsgCtx.getParam("code_challenge");
        if (responseType.has("code") && client.isRequireProofKeyForCodeExchange() && StringUtils.isBlank((String)codeChallenge)) {
            String msg = "code_challenge is required.";
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, msg);
        }
    }

    public void checkCodeChallenge(InMessageContext inMsgCtx) throws AuthorizationRequestException {
        String codeChallenge = inMsgCtx.getParam("code_challenge");
        String codeChallengeMethod = inMsgCtx.getParam("code_challenge_method");
        if ((StringUtils.isEmpty((String)codeChallengeMethod) || codeChallengeMethod.equals("plain")) && !StringUtils.isEmpty((String)codeChallenge)) {
            if (this.authzServerManager.isRestrictPlainPKCE()) {
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "The PKCE plain code challenge method is not allowed per server policy");
            }
            if (StringUtils.length((String)codeChallenge) < 43 || StringUtils.length((String)codeChallenge) > 128) {
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "code_challenge must be between 43 and 128 characters in length for type 'plain'.");
            }
            Pattern r = Pattern.compile("^[a-zA-Z_0-9\\-\\.\\_\\~]+$");
            Matcher m = r.matcher(codeChallenge);
            if (!m.find()) {
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "code_challenge must contain only: alphanumeric, '-', '.', '_', '~'");
            }
        } else if (StringUtils.equals((String)codeChallengeMethod, (String)"S256") && StringUtils.length((String)codeChallenge) != 43) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "code_challenge must be 43 characters in length for type 'S256'.");
        }
        if (!(StringUtils.isEmpty((String)codeChallengeMethod) || StringUtils.equals((String)codeChallengeMethod, (String)"plain") || StringUtils.equals((String)codeChallengeMethod, (String)"S256"))) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "code_challenge_method invalid");
        }
        if (!StringUtils.isEmpty((String)codeChallengeMethod) && StringUtils.isEmpty((String)codeChallenge)) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "code_challenge must be specified if a code_challenge_method is present.");
        }
    }

    public void checkResponseTypeConstraints(Client client, ResponseType responseType) throws AuthorizationRequestException {
        if (client.isRestrictResponseTypes()) {
            String clientId = client.getClientId();
            HashSet<String> requestedResponseTypeSet = new HashSet<String>(Arrays.asList(responseType.getParts()));
            boolean allowedResponseType = client.getRestrictedResponseTypes().stream().map(ClientUtil::getResponseTypes).anyMatch(requestedResponseTypeSet::equals);
            if (!allowedResponseType) {
                String msg = "response_type '" + responseType.getResponseTypeString() + "' is not allowed for client: " + clientId;
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.unsupported_response_type, msg);
            }
        }
        if (responseType.getResponseMode() == ResponseType.ResponseMode.pi_flow && !MgmtFactory.getAuthnApiManager().isApiEnabled()) {
            String msg = "response_mode " + ResponseType.ResponseMode.pi_flow.getIdentifier() + " requested, but authentication API is not enabled";
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.access_denied, msg);
        }
    }

    private void checkParRequired(Client client, InMessageContext inMsgCtx, HttpServletRequest req) throws AuthorizationRequestException {
        ParServerPolicy.Status parStatus = this.authzServerManager.getParServerPolicy().getStatus();
        boolean parForClient = client.isRequirePushedAuthorizationRequests();
        if ((parStatus == ParServerPolicy.Status.REQUIRED || parForClient) && !inMsgCtx.isBackChannelBinding() && StringUtils.isBlank((String)req.getParameter("request_uri"))) {
            String s = "Authorization request data is accepted only via the pushed authorization request method" + (parForClient ? " for the given client." : ".");
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, s);
        }
    }

    private void checkJarmRequired(Client client, InMessageContext inMsgCtx) throws AuthorizationRequestException {
        String responseMode = inMsgCtx.getParam("response_mode");
        if (client.isRequireJwtSecuredAuthorizationResponseMode() && !ResponseType.ResponseMode.isJarmType(responseMode)) {
            String msg = "JWT secured authorization response mode is required";
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, msg);
        }
    }

    public void generalRequestProcessing(Client client, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, HttpServletRequest req) throws AuthorizationRequestException {
        this.checkRedirectUri(client, inMsgCtx, outMsgCtx);
        this.checkParRequired(client, inMsgCtx, req);
        this.checkJarmRequired(client, inMsgCtx);
        ResponseType responseType = this.getResponseType(inMsgCtx, true, client);
        this.checkRespType(responseType, client);
        this.checkClientAuthorizedForType(responseType, client);
        Scope scope = this.checkScope(inMsgCtx, client);
        this.checkOfflineAccessScope(client, responseType, scope);
        this.checkOfflineAccessConsentPrompt(client, scope, inMsgCtx);
        this.checkAuthorizationDetails(inMsgCtx, client, req, scope);
        this.checkNonce(inMsgCtx, responseType, scope);
        this.checkRedirect(client, inMsgCtx, scope);
        this.checkRequest(req);
        this.checkCodeChallengeIsRequired(inMsgCtx, client, responseType);
        this.checkCodeChallenge(inMsgCtx);
        this.checkResponseTypeConstraints(client, responseType);
    }

    private void checkOfflineAccessScope(Client client, ResponseType responseType, Scope scope) throws AuthorizationRequestException {
        boolean isNotCodeRspType;
        if (!this.offlineAccessSupport.isRequireOfflineAccessScopeToIssueRefreshToken(client)) {
            return;
        }
        if (!scope.hasScope("offline_access")) {
            return;
        }
        boolean bl = isNotCodeRspType = !responseType.has("code");
        if (isNotCodeRspType) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_scope, "The 'offline_access' scope can only be requested with the 'code' response type.");
        }
    }

    private void checkOfflineAccessConsentPrompt(Client client, Scope scope, InMessageContext inMsgCtx) throws AuthorizationRequestException {
        if (!this.offlineAccessSupport.isOfflineAccessRequireConsentPromptEnabled(client)) {
            return;
        }
        if (!scope.hasScope("offline_access")) {
            return;
        }
        String rawPrompt = inMsgCtx.getParam("prompt", String.class);
        Prompt prompt = new Prompt(rawPrompt);
        if (!prompt.isConsent()) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "The 'offline_access' scope requires user consent.");
        }
    }
}

