/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect;

import com.pingidentity.common.util.LogGuard;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jose4j.jwt.NumericDate;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.service.OAuthJwtTokenService;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.OidcSession;
import org.sourceid.util.json.JsonUtils;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class OidcLogoutSupport {
    public static final String EVENT_BACKCHANNEL_LOGOUT = "http://schemas.openid.net/event/backchannel-logout";
    private static final String CFG_LOGOUT_TOKEN_EXPIRY_MINS = "LogoutTokenExpiryMins";
    private static final String CFG_INCLUDE_SUBJECT_IN_LOGOUT_TOKEN = "IncludeSubjectInLogoutToken";
    private static final String CFG_INCLUDE_SID_IN_LOGOUT_TOKEN = "IncludeSidInLogoutToken";
    private static final Log log = LogFactory.getLog(OidcLogoutSupport.class);
    private final OAuthJwtTokenService oAuthJwtTokenService = MgmtFactory.getOAuthJwtTokenService();
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.openid.connect.OidcLogoutSupport");

    public Map<String, Object> getLogoutTokenClaims(OidcSession session) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("iss", session.getIssuer());
        if (session.getSubject() != null && this.configStore.getBooleanValue(CFG_INCLUDE_SUBJECT_IN_LOGOUT_TOKEN, true)) {
            claims.put("sub", session.getSubject());
        }
        claims.put("aud", session.getClientId());
        claims.put("iat", NumericDate.now().getValue());
        String jti = IDGenerator.rndAlphaNumeric(22);
        AsAuditLogger.setRequestJti(jti);
        claims.put("jti", jti);
        HashMap events = new HashMap();
        events.put(EVENT_BACKCHANNEL_LOGOUT, Collections.emptyMap());
        claims.put("events", events);
        if (this.configStore.getBooleanValue(CFG_INCLUDE_SID_IN_LOGOUT_TOKEN, true)) {
            claims.put("sid", session.getExtendedSri());
        }
        NumericDate date = NumericDate.now();
        int expiryMins = this.configStore.getIntValue(CFG_LOGOUT_TOKEN_EXPIRY_MINS, 5);
        date.addSeconds(60L * (long)expiryMins);
        long expiration = date.getValue();
        claims.put("exp", expiration);
        return claims;
    }

    public String makeToken(Client client, OidcSession session, Map<String, Object> claims) {
        return this.oAuthJwtTokenService.issueLogoutToken(session.getOAuthIssuerId(), client, claims);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public boolean sendLogoutRequest(Client client, OidcSession session) {
        Map<String, Object> claims = this.getLogoutTokenClaims(session);
        if (log.isDebugEnabled()) {
            String logMessage = "Sending OIDC back-channel logout request to client " + client.getClientId();
            logMessage = logMessage + ", issuer: " + session.getIssuer();
            logMessage = logMessage + ", user key: " + session.getUserNameForLog();
            logMessage = logMessage + ", sid: " + session.getExtendedSri();
            log.debug((Object)logMessage);
        }
        String logoutToken = this.makeToken(client, session, claims);
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("logout_token", logoutToken));
            HttpPost post = new HttpPost(client.getBackChannelLogoutUri());
            post.addHeader("Content-Type", "application/x-www-form-urlencoded");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            try (CloseableHttpResponse resp = HttpConnectionPoolingManager.getInstance().doRequestWithResponse((HttpRequestBase)post);){
                int statusCode = resp.getStatusLine().getStatusCode();
                String responseString = EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)Consts.UTF_8);
                if (statusCode != 200 && statusCode != 204) {
                    Map<String, Object> responseMap = JsonUtils.getInstance().readToMap(responseString);
                    String logMessage = this.makeBaseLogMessage(client) + " returned " + statusCode;
                    Object error = responseMap.get("error");
                    Object errorDescription = responseMap.get("error_description");
                    if (error instanceof String) {
                        logMessage = logMessage + ", error: " + LogGuard.encode((String)error);
                    }
                    if (errorDescription instanceof String) {
                        logMessage = logMessage + ", description: " + LogGuard.encode((String)errorDescription);
                    }
                    log.warn((Object)logMessage);
                    boolean bl = false;
                    return bl;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.makeBaseLogMessage(client) + " returned " + statusCode));
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            String logMessage = this.makeBaseLogMessage(client) + " threw error " + ExceptionUtil.toStringWithCauses(e);
            log.warn((Object)logMessage);
            return false;
        }
    }

    private String makeBaseLogMessage(Client client) {
        return "Back-channel logout request to client " + client.getClientId() + " at endpoint " + client.getBackChannelLogoutUri();
    }
}

