/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.bindings;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.oauth20.bindings.OauthBindingGroup;
import org.sourceid.openid.connect.profiles.sp.LogoutException;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class FrontChannelLogoutBinding
implements Binding {
    private static final String FC_LOGOUT_BINDING = "oidc:fc:logout";

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RedirectException, RenderPageException, HttpStatusCodeException {
        OauthBindingGroup.checkLicense();
        InMessageContext inMsgCtx = new InMessageContext(Role.SP);
        inMsgCtx.setIsRequest(true);
        String partnerEntityId = this.decodeIssuerFromRequestPath(request, inMsgCtx);
        IdpConnection idpConn = MgmtFactory.getMetadataDirectory().getIdpConnection(partnerEntityId, false);
        if (idpConn == null) {
            inMsgCtx.setDeferredException(new LogoutException(LogoutException.Error.invalid_request, "Entity ID '" + partnerEntityId + "' extracted from request does not match an IdP connection"));
        } else if (idpConn.getOidcSettings() == null) {
            inMsgCtx.setDeferredException(new LogoutException(LogoutException.Error.invalid_request, "IdP connection '" + partnerEntityId + "' does not have OIDC enabled"));
        } else {
            String sid;
            inMsgCtx.setEntityId(partnerEntityId);
            String issuer = request.getParameter("iss");
            if (issuer != null) {
                inMsgCtx.setParam("iss", issuer);
            }
            if ((sid = request.getParameter("sid")) != null) {
                inMsgCtx.setParam("sid", sid);
            }
        }
        return inMsgCtx;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException, RenderPageException {
        throw new ServletException((Throwable)e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public String getUri() {
        return FC_LOGOUT_BINDING;
    }

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }

    private String decodeIssuerFromRequestPath(HttpServletRequest request, InMessageContext inMsgCtx) {
        String issuer = null;
        try {
            PathUtil pathUtil = MetaDataFactory.getLocalMetaData().getPathUtil();
            Map<String, Object> paramMap = pathUtil.getDecodedParamMap(request.getServletPath());
            issuer = (String)paramMap.get("iss");
        }
        catch (IllegalArgumentException e) {
            inMsgCtx.setDeferredException(new LogoutException(LogoutException.Error.invalid_request, "Unable to decode issuer from request path", e));
        }
        return issuer;
    }
}

