/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.bindings;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.sourceid.openid.connect.util.OIDCUtil;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.RelayStateSupport;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.servlet.ServletExceptionSupport;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class OIDCBaseBinding
implements Binding {
    public static final String ORIGINAL_NONCE = "originalNonce";
    private static final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RedirectException, RenderPageException, HttpStatusCodeException {
        String issuer = this.decodeIssuerFromRequestPath(request);
        IdpConnection idpConn = this.getIdpConnection(issuer);
        this.validateIssuer(request, idpConn);
        String state = request.getParameter("state");
        InMessageContext msgCtxIn = this.getInMessageContext(request, response, partnerRole, issuer, state);
        return this.doReceive(request, issuer, idpConn, msgCtxIn, state);
    }

    protected IdpConnection getIdpConnection(String issuer) throws BindingException {
        IdpConnection idpConn = metadataDirectory.getIdpConnection(issuer, false);
        if (idpConn == null) {
            throw new BindingException("There is no IdP connection found for the issuer " + issuer);
        }
        if (idpConn.getOidcSettings() == null) {
            throw new BindingException("The IdP connection " + idpConn.getEntityId() + " does not have OIDC enabled.");
        }
        return idpConn;
    }

    protected InMessageContext getInMessageContext(HttpServletRequest request, HttpServletResponse response, Role partnerRole, String issuer, String state) throws RenderPageException, BindingException {
        InMessageContext msgCtxIn = this.getBaseMessageContext(partnerRole);
        RelayStateSupport relayStateSupport = new RelayStateSupport();
        relayStateSupport.lookupAssociation(msgCtxIn, state, request, response);
        this.verifyIssuerAndState(issuer, state, msgCtxIn);
        SessionStateSupport sessionStateSupport = new SessionStateSupport();
        String key = OIDCUtil.getNonceSessionKey(state);
        String originalNonce = (String)sessionStateSupport.removeAttribute(key, request, response);
        msgCtxIn.setParam(ORIGINAL_NONCE, originalNonce);
        return msgCtxIn;
    }

    protected void verifyIssuerAndState(String issuer, String state, InMessageContext msgCtxIn) throws RenderPageException, BindingException {
        if (issuer == null) {
            throw new BindingException("the issuer returned is null");
        }
        if (msgCtxIn.getOriginalRequest() == null) {
            throw new BindingException("Could not find the original request associated with this callback.");
        }
        String originalState = msgCtxIn.getOriginalRequest().getRelayState();
        if (state == null || !state.equals(originalState)) {
            throw new BindingException("State value returned does not match the original state value");
        }
        String originalEntityId = msgCtxIn.getOriginalRequest().getEntityId();
        if (originalEntityId == null || !originalEntityId.equals(issuer)) {
            throw new BindingException("Issuer value returned does not match the original entity ID");
        }
    }

    public abstract InMessageContext doReceive(HttpServletRequest var1, String var2, IdpConnection var3, InMessageContext var4, String var5) throws IOException, BindingException;

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException, RenderPageException {
        ServletExceptionSupport.throwServletException(e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public abstract String getUri();

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }

    protected List<? extends NameValuePair> getParameters(Map<String, Object> params) {
        if (params != null) {
            return params.entrySet().stream().map(entity -> new BasicNameValuePair((String)entity.getKey(), (String)entity.getValue())).collect(Collectors.toList());
        }
        return null;
    }

    protected InMessageContext getBaseMessageContext(Role partnerRole) {
        InMessageContext msgCtxIn = new InMessageContext(partnerRole);
        msgCtxIn.setIsRequest(false);
        msgCtxIn.setSignatureRequired(true);
        msgCtxIn.setBinding(this.getUri());
        return msgCtxIn;
    }

    protected String decodeIssuerFromRequestPath(HttpServletRequest request) {
        PathUtil pathUtil = MetaDataFactory.getLocalMetaData().getPathUtil();
        Map<String, Object> paramMap = pathUtil.getDecodedParamMap(request.getServletPath());
        return (String)paramMap.get("iss");
    }

    private void validateIssuer(HttpServletRequest request, IdpConnection idpConn) throws BindingException {
        String issuer = request.getParameter("iss");
        if (issuer == null) {
            return;
        }
        if (issuer.equals(idpConn.getEntityId())) {
            return;
        }
        if (idpConn.isAllowAdditionalEntities()) {
            if (idpConn.isAllowAllEntities()) {
                return;
            }
            if (idpConn.getAdditionalAllowedEntities().stream().anyMatch(entity -> issuer.equals(entity.getEntityId()))) {
                return;
            }
        }
        throw new BindingException("The IdP connection " + idpConn.getEntityId() + " does not allow issuer " + issuer + ".");
    }
}

