/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.bindings;

import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.sourceid.openid.connect.bindings.BackChannelLogoutBinding;
import org.sourceid.openid.connect.bindings.FrontChannelLogoutBinding;
import org.sourceid.openid.connect.bindings.JsonBinding;
import org.sourceid.openid.connect.bindings.JwtBinding;
import org.sourceid.openid.connect.bindings.OIDCCodeBinding;
import org.sourceid.openid.connect.bindings.OIDCImplicitBinding;
import org.sourceid.openid.connect.bindings.OIDCJarmBinding;
import org.sourceid.openid.connect.bindings.RpInitiatedLogoutBinding;
import org.sourceid.openid.connect.bindings.UserInfoEndpointBinding;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.websso.bindings.ProtocolBindingGroup;

public class OIDCBindingGroup
extends ProtocolBindingGroup {
    public static final String SUFFIX = ".openid";
    public static final Scope REQUIRED_SCOPES = Scope.getScope((String)"openid");
    public static final Scope SUGGESTED_SCOPES = new Scope(new String[]{"openid", "email", "profile", "address", "phone"});
    public static final String REALM = "UserInfo";
    private final UserInfoEndpointBinding userInfoBinding = new UserInfoEndpointBinding("UserInfo", REQUIRED_SCOPES, SUGGESTED_SCOPES);
    private final OIDCCodeBinding oidcCodeBinding = new OIDCCodeBinding();
    private final OIDCImplicitBinding oidcImplicitBinding = new OIDCImplicitBinding();
    private final OIDCJarmBinding oidcJarmBinding = new OIDCJarmBinding();
    private final BackChannelLogoutBinding oidcBackChannelLogoutBinding = new BackChannelLogoutBinding();
    private final FrontChannelLogoutBinding oidcFrontChannelLogoutBinding = new FrontChannelLogoutBinding();
    private final RpInitiatedLogoutBinding oidcRpInitiatedLogoutBinding = new RpInitiatedLogoutBinding();
    private final MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();

    public OIDCBindingGroup() {
        this.bindings = new Binding[]{this.userInfoBinding, this.oidcCodeBinding, this.oidcImplicitBinding, this.oidcJarmBinding, this.oidcBackChannelLogoutBinding, this.oidcFrontChannelLogoutBinding, this.oidcRpInitiatedLogoutBinding, new JsonBinding(), new JwtBinding()};
    }

    @Override
    public String ascertainBindingName(HttpServletRequest req, boolean isPost) throws IOException {
        if ("/idp/userinfo.openid".equals(req.getServletPath())) {
            return this.userInfoBinding.getUri();
        }
        if ("/sp/bc-logout.openid".equals(this.metadataLocal.getPathUtil().stripPathParams(req.getServletPath()))) {
            return this.oidcBackChannelLogoutBinding.getUri();
        }
        if ("/sp/fc-logout.openid".equals(this.metadataLocal.getPathUtil().stripPathParams(req.getServletPath()))) {
            return this.oidcFrontChannelLogoutBinding.getUri();
        }
        if ("/idp/init_logout.openid".equals(req.getServletPath()) || "/sp/post-logout.openid".equals(req.getServletPath())) {
            return this.oidcRpInitiatedLogoutBinding.getUri();
        }
        if (req.getParameter("response") != null) {
            return this.oidcJarmBinding.getUri();
        }
        String responseType = req.getParameter("code");
        if (responseType != null) {
            return this.oidcCodeBinding.getUri();
        }
        return this.oidcImplicitBinding.getUri();
    }
}

