/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.bindings;

import java.io.IOException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.sourceid.oauth20.protocol.HttpsJwksCache;
import org.sourceid.oauth20.utils.JwtProcessingUtils;
import org.sourceid.openid.connect.MultiDecryptionKeyResolver;
import org.sourceid.openid.connect.MultiSigningKeyResolver;
import org.sourceid.openid.connect.bindings.OIDCBaseBinding;
import org.sourceid.openid.connect.bindings.OIDCCodeBinding;
import org.sourceid.openid.connect.bindings.OIDCImplicitBinding;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.openid.connect.util.OidcJwtRpIssuerValidator;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.Entity;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;

public class OIDCJarmBinding
extends OIDCBaseBinding {
    private static final String OIDC_JARM_BINDING = "oidc:jarm";
    private static final Log log = LogFactory.getLog(OIDCJarmBinding.class);
    private static final AlgorithmConstraints ENC_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, OpenIdConnectProviderInfo.getEncryptionAlgorithms().toArray(new String[0]));
    private static final AlgorithmConstraints CONTENT_ENC_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, OpenIdConnectProviderInfo.getContentEncryptionAlgorithms().toArray(new String[0]));
    private final HttpsJwksCache httpsJwksCache = HttpsJwksCache.getInstance();

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RedirectException, RenderPageException, HttpStatusCodeException {
        String issuer = this.decodeIssuerFromRequestPath(request);
        IdpConnection idpConn = this.getIdpConnection(issuer);
        String jwt = request.getParameter("response");
        JwtClaims claims = this.processJwtResponseWithSignatureRequired(jwt, idpConn);
        String state = this.getJwtClaimValue(claims, "state");
        InMessageContext msgCtxIn = this.getInMessageContext(request, response, partnerRole, issuer, state);
        String error = this.getJwtClaimValue(claims, "error");
        if (error != null) {
            msgCtxIn.setParam("error", error);
            String errorDescription = this.getJwtClaimValue(claims, "error_description");
            if (errorDescription != null && errorDescription.isEmpty()) {
                msgCtxIn.setParam("error_description", errorDescription);
            }
            return msgCtxIn;
        }
        String code = this.getJwtClaimValue(claims, "code");
        if (code != null) {
            OIDCCodeBinding oidcCodeBinding = new OIDCCodeBinding();
            Function<HttpServletRequest, String> codeExtractor = unused -> code;
            oidcCodeBinding.setCodeExtractor(codeExtractor);
            return oidcCodeBinding.doReceive(request, issuer, idpConn, msgCtxIn, state);
        }
        String idToken = this.getJwtClaimValue(claims, "id_token");
        String accessToken = this.getJwtClaimValue(claims, "access_token");
        Function<HttpServletRequest, String> idTokenExtractor = unused -> idToken;
        Function<HttpServletRequest, String> accessTokenExtractor = unused -> accessToken;
        OIDCImplicitBinding oidcImplicitBinding = new OIDCImplicitBinding();
        oidcImplicitBinding.setIdTokenExtractor(idTokenExtractor);
        oidcImplicitBinding.setAccessTokenExtractor(accessTokenExtractor);
        return oidcImplicitBinding.doReceive(request, issuer, idpConn, msgCtxIn, state);
    }

    @Override
    public InMessageContext doReceive(HttpServletRequest request, String issuer, IdpConnection idpConn, InMessageContext msgCtxIn, String state) throws IOException, BindingException {
        throw new BindingException("Unexpected flow: method not implemented.");
    }

    @Override
    public String getUri() {
        return OIDC_JARM_BINDING;
    }

    private JwtClaims processJwtResponseWithSignatureRequired(String jwtResponse, IdpConnection idpConnection) throws BindingException {
        try {
            OIDCSettings oidcSettings = idpConnection.getOidcSettings();
            String jwksUri = oidcSettings.getJwksUri().getFullLocation();
            HttpsJwks httpsJwks = this.httpsJwksCache.getJwks(jwksUri, idpConnection.getEntityId());
            MultiSigningKeyResolver resolver = new MultiSigningKeyResolver(oidcSettings.getSecretAsUtf8Bytes(), httpsJwks);
            String expectedAudience = oidcSettings.getClientId();
            OidcJwtRpIssuerValidator issuerValidator = new OidcJwtRpIssuerValidator(idpConnection.getEntityId(), idpConnection.getAdditionalAllowedEntities().stream().map(Entity::getEntityId).collect(Collectors.toSet()), idpConnection.isAllowAllEntities());
            JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setRequireExpirationTime().setExpectedAudience(new String[]{expectedAudience}).setVerificationKeyResolver((VerificationKeyResolver)resolver).setJwsAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE).registerValidator((ErrorCodeValidator)issuerValidator);
            MultiDecryptionKeyResolver decryptionKeyResolver = new MultiDecryptionKeyResolver(oidcSettings.getSecretAsUtf8Bytes());
            jwtConsumerBuilder.setDecryptionKeyResolver((DecryptionKeyResolver)decryptionKeyResolver);
            jwtConsumerBuilder.setJweAlgorithmConstraints(ENC_CONSTRAINTS);
            jwtConsumerBuilder.setJweContentEncryptionAlgorithmConstraints(CONTENT_ENC_CONSTRAINTS);
            JwtProcessingUtils.checkApplyKeyProviderContextOverride(jwtResponse, decryptionKeyResolver, jwtConsumerBuilder);
            JwtConsumer jwtConsumer = jwtConsumerBuilder.build();
            return jwtConsumer.processToClaims(jwtResponse);
        }
        catch (InvalidJwtException e) {
            log.error((Object)e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            throw new BindingException("The JWT response could not be processed: ", e);
        }
    }

    private String getJwtClaimValue(JwtClaims claims, String parameter) throws BindingException {
        try {
            return claims.getStringClaimValue(parameter);
        }
        catch (MalformedClaimException e) {
            log.error((Object)e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            throw new BindingException("The JWT string claim value could not be retrieved: ", e);
        }
    }
}

