/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.domain;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ConnectProviderRuntimePolicySupport {
    private final Log log = LogFactory.getLog(this.getClass());
    private OpenIdConnectProviderPolicyManager connectProviderPolicyManager = MgmtFactory.getOIDCProviderPolicyManager();

    public OpenIdConnectProviderPolicy.PolicyGroup getPolicyGroup(Client client) {
        return this.getPolicyGroup(client, true);
    }

    public OpenIdConnectProviderPolicy.PolicyGroup getPolicyGroup(Client client, boolean throwExceptionOnFailure) {
        String id;
        OpenIdConnectProviderPolicy idConnectProviderPolicy = this.connectProviderPolicyManager.getPolicy();
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = null;
        String string = id = client != null ? client.getPolicyGroupId() : null;
        if (StringUtils.isNotEmpty((String)id) && (policyGroup = idConnectProviderPolicy.getPolicyGroup(id)) == null) {
            this.log.debug((Object)String.format("Unknown policy group id %s for client %s so using the default.", id, client.getClientId()));
        }
        if (policyGroup == null) {
            OpenIdConnectProviderPolicy.PolicyGroup defaultPolicyGroup = idConnectProviderPolicy.getDefaultPolicyGroup();
            if (defaultPolicyGroup == null && throwExceptionOnFailure) {
                throw new IllegalStateException("The default connect policy group has not been configured.");
            }
            policyGroup = defaultPolicyGroup;
        }
        return policyGroup;
    }

    public OpenIdConnectProviderPolicyManager getConnectProviderPolicyManager() {
        return this.connectProviderPolicyManager;
    }
}

