/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.domain;

import com.pingidentity.crypto.Password;
import com.pingidentity.crypto.PkCert;
import java.util.Collection;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.sourceid.openid.connect.domain.OAuthClientConnection;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;

public class OIDCProviderConnection
extends OAuthClientConnection {
    private String authorizationEndpoint;
    private VerificationKeyResolver verificationKeyResolver;
    private PkCert signingKeyPair;
    private String providerId;
    private int allowedClockSkewSecs = 300;
    private String endSessionEndpoint;
    private String tokenEndpoint;
    private String userInfoEndpoint;
    private String issuer;
    private Collection<String> acrValues;
    private Collection<OIDCRequestParamSetting> requestParamSettings;
    private boolean enableProofKeyForCodeExchange = false;
    private String pushedAuthorizationRequestEndpoint;
    private String type;
    private String audience;

    private OIDCProviderConnection(String clientId, String authzEndpoint, String endSessionEndpoint) {
        super(clientId);
        this.authorizationEndpoint = authzEndpoint;
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public OIDCProviderConnection(String providerId, String clientId, String authzEndpoint, String endSessionEndpoint, PkCert signingKeyPair, VerificationKeyResolver resolver) {
        this(clientId, authzEndpoint, endSessionEndpoint);
        this.providerId = providerId;
        this.signingKeyPair = signingKeyPair;
        this.verificationKeyResolver = resolver;
    }

    public OIDCProviderConnection(String clientId, String authzEndpoint, String endSessionEndpoint, String tokenEndpoint, String userInfoEndpoint, String issuer, Password clientSecret, String clientAuthType, Collection<String> scopes, Collection<String> acrValues, boolean enableProofKeyForCodeExchange, Collection<OIDCRequestParamSetting> requestParamSettings, String pushedAuthorizationRequestEndpoint, String type, String audience) {
        super(clientId, clientSecret, clientAuthType, scopes);
        this.authorizationEndpoint = authzEndpoint;
        this.endSessionEndpoint = endSessionEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.userInfoEndpoint = userInfoEndpoint;
        this.issuer = issuer;
        this.acrValues = acrValues;
        this.enableProofKeyForCodeExchange = enableProofKeyForCodeExchange;
        this.requestParamSettings = requestParamSettings;
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
        this.type = type;
        this.audience = audience;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public VerificationKeyResolver getVerificationKeyResolver() {
        return this.verificationKeyResolver;
    }

    public void setVerificationKeyResolver(VerificationKeyResolver verificationKeyResolver) {
        this.verificationKeyResolver = verificationKeyResolver;
    }

    public PkCert getSigningKeyPair() {
        return this.signingKeyPair;
    }

    public void setSigningKeyPair(PkCert signingKeyPair) {
        this.signingKeyPair = signingKeyPair;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public int getAllowedClockSkewSecs() {
        return this.allowedClockSkewSecs;
    }

    public void setAllowedClockSkewSecs(int allowedClockSkewSecs) {
        this.allowedClockSkewSecs = allowedClockSkewSecs;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public Collection<String> getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(Collection<String> acrValues) {
        this.acrValues = acrValues;
    }

    public boolean isEnableProofKeyForCodeExchange() {
        return this.enableProofKeyForCodeExchange;
    }

    public Collection<OIDCRequestParamSetting> getRequestParamSettings() {
        return this.requestParamSettings;
    }

    public String getPushedAuthorizationRequestEndpoint() {
        return this.pushedAuthorizationRequestEndpoint;
    }

    public void setPushedAuthorizationRequestEndpoint(String pushedAuthorizationRequestEndpoint) {
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }
}

