/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.domain;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwa.AlgorithmFactory;
import org.jose4j.jwa.AlgorithmFactoryFactory;
import org.sourceid.oauth20.domain.JWKSEndpointManager;
import org.sourceid.oauth20.domain.JWKSEndpointSetting;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OpenIdConnectProviderInfo {
    private static final JWKSEndpointManager jwksEndpointMgr = MgmtFactory.getJWKSEndpointManager();
    private static final Map<String, String> hmacMap = new LinkedHashMap<String, String>();
    private static final Map<String, String> rsaMap = new LinkedHashMap<String, String>();
    private static final Map<String, String> ecMap = new LinkedHashMap<String, String>();
    private static final Map<String, String> pssMap = new LinkedHashMap<String, String>();
    private static final Map<String, String> encryptionAlgs = new LinkedHashMap<String, String>();
    private static final Map<String, String> contentEncryptionAlgs = new LinkedHashMap<String, String>();

    public static List<String> idTokenSigningAlgValuesSupportedWithNoneHmac() {
        return new ArrayList<String>(OpenIdConnectProviderInfo.idTokenSigningAlgMapSupportedWithNoneHmac().keySet());
    }

    public static List<String> idTokenSigningAlgValuesSupported() {
        return Collections.unmodifiableList(new ArrayList<String>(OpenIdConnectProviderInfo.idTokenSigningAlgMapSupported().keySet()));
    }

    public static Map<String, String> getSupportedAsymmetricSignatureVerificationAlgorithms() {
        LinkedHashMap<String, String> supportedAsymmetricAlgorithms = new LinkedHashMap<String, String>();
        supportedAsymmetricAlgorithms.putAll(rsaMap);
        supportedAsymmetricAlgorithms.putAll(ecMap);
        if (SignatureAlgorithm.isRSAPSSAvailable()) {
            supportedAsymmetricAlgorithms.putAll(pssMap);
        }
        return supportedAsymmetricAlgorithms;
    }

    public static Map<String, String> getSupportedSymmetricSignatureVerificationAlgorithms() {
        return Collections.unmodifiableMap(hmacMap);
    }

    public static Map<String, String> idTokenSigningAlgMapSupportedWithNoneHmac() {
        return OpenIdConnectProviderInfo.jwtSigningAlgorithmMap(true, true);
    }

    public static Map<String, String> jwtSigningAlgorithmMapWithHmacWithoutNone() {
        return OpenIdConnectProviderInfo.jwtSigningAlgorithmMap(true, false);
    }

    public static Set<String> jwtSigningAlgorithmSetWithHmacWithoutNone() {
        return Collections.unmodifiableSet(OpenIdConnectProviderInfo.jwtSigningAlgorithmMapWithHmacWithoutNone().keySet());
    }

    public static Map<String, String> jwtSigningAlgorithmMap(boolean includeHmac, boolean includeNone) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (includeNone) {
            map.put("none", "None");
        }
        if (includeHmac) {
            map.putAll(hmacMap);
        }
        map.putAll(OpenIdConnectProviderInfo.idTokenSigningAlgMapSupportedCheckJwks());
        return map;
    }

    public static Map<String, String> idTokenSigningAlgMapSupported() {
        return OpenIdConnectProviderInfo.idTokenSigningAlgMapSupported(false);
    }

    public static Map<String, String> idTokenSigningAlgMapSupportedCheckJwks() {
        return OpenIdConnectProviderInfo.idTokenSigningAlgMapSupported(true);
    }

    public static List<String> getEncryptionAlgorithms() {
        AlgorithmFactoryFactory aff = AlgorithmFactoryFactory.getInstance();
        AlgorithmFactory jweKeyManagementAlgorithmFactory = aff.getJweKeyManagementAlgorithmFactory();
        return encryptionAlgs.keySet().stream().filter(arg_0 -> ((AlgorithmFactory)jweKeyManagementAlgorithmFactory).isAvailable(arg_0)).collect(Collectors.toList());
    }

    public static List<String> getVerificationAlgorithmsSupported() {
        return OpenIdConnectProviderInfo.getVerificationAlgorithmsSupported(true);
    }

    private static List<String> getVerificationAlgorithmsSupported(boolean includeSymmetric) {
        ArrayList<String> algorithms = new ArrayList<String>();
        algorithms.addAll(rsaMap.keySet());
        algorithms.addAll(ecMap.keySet());
        algorithms.addAll(pssMap.keySet());
        if (includeSymmetric) {
            algorithms.addAll(hmacMap.keySet());
        }
        AlgorithmFactoryFactory aff = AlgorithmFactoryFactory.getInstance();
        AlgorithmFactory af = aff.getJwsAlgorithmFactory();
        return algorithms.stream().filter(arg_0 -> ((AlgorithmFactory)af).isAvailable(arg_0)).collect(Collectors.toList());
    }

    public static List<String> getAsymmetricVerificationAlgorithmsSupported() {
        return OpenIdConnectProviderInfo.getVerificationAlgorithmsSupported(false);
    }

    public static String getEncryptionAlgName(String key) {
        return encryptionAlgs.get(key);
    }

    public static String getContentEncryptionAlgName(String key) {
        return contentEncryptionAlgs.get(key);
    }

    public static List<String> getContentEncryptionAlgorithms() {
        AlgorithmFactoryFactory aff = AlgorithmFactoryFactory.getInstance();
        AlgorithmFactory jweContentEncryptionAlgorithmFactory = aff.getJweContentEncryptionAlgorithmFactory();
        return contentEncryptionAlgs.keySet().stream().filter(arg_0 -> ((AlgorithmFactory)jweContentEncryptionAlgorithmFactory).isAvailable(arg_0)).collect(Collectors.toList());
    }

    private static Map<String, String> idTokenSigningAlgMapSupported(boolean checkJwksMode) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        JWKSEndpointSetting setting = jwksEndpointMgr.getSetting();
        if (!setting.isEnableStaticKeys() || setting.isEnableStaticKeys() && StringUtils.isNotBlank((String)setting.getRsaActiveId())) {
            map.putAll(rsaMap);
        }
        if (!setting.isEnableStaticKeys() || setting.isEnableStaticKeys() && StringUtils.isNotBlank((String)setting.getP256ActiveId())) {
            map.put("ES256", ecMap.get("ES256"));
        }
        if (!setting.isEnableStaticKeys() || setting.isEnableStaticKeys() && StringUtils.isNotBlank((String)setting.getP384ActiveId())) {
            map.put("ES384", ecMap.get("ES384"));
        }
        if (!setting.isEnableStaticKeys() || setting.isEnableStaticKeys() && StringUtils.isNotBlank((String)setting.getP521ActiveId())) {
            map.put("ES512", ecMap.get("ES512"));
        }
        if (SignatureAlgorithm.isRSAPSSAvailable() && (!checkJwksMode || PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode() || PropertyInfo.HSM_MODE.BCFIPS == PropertyInfo.getHSMMode() || PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode() && setting.isEnableStaticKeys()) && (!setting.isEnableStaticKeys() || setting.isEnableStaticKeys() && StringUtils.isNotBlank((String)setting.getRsaActiveId()))) {
            map.putAll(pssMap);
        }
        return map;
    }

    static {
        hmacMap.put("HS256", "HMAC using SHA-256");
        hmacMap.put("HS384", "HMAC using SHA-384");
        hmacMap.put("HS512", "HMAC using SHA-512");
        rsaMap.put("RS256", "RSA using SHA-256");
        rsaMap.put("RS384", "RSA using SHA-384");
        rsaMap.put("RS512", "RSA using SHA-512");
        ecMap.put("ES256", "ECDSA using P256 Curve and SHA-256");
        ecMap.put("ES384", "ECDSA using P384 Curve and SHA-384");
        ecMap.put("ES512", "ECDSA using P521 Curve and SHA-512");
        pssMap.put("PS256", "RSASSA-PSS using SHA-256");
        pssMap.put("PS384", "RSASSA-PSS using SHA-384");
        pssMap.put("PS512", "RSASSA-PSS using SHA-512");
        encryptionAlgs.put("dir", "Direct Encryption with symmetric key");
        encryptionAlgs.put("A128KW", "AES-128 Key Wrap");
        encryptionAlgs.put("A192KW", "AES-192 Key Wrap");
        encryptionAlgs.put("A256KW", "AES-256 Key Wrap");
        encryptionAlgs.put("A128GCMKW", "AES-GCM-128 key encryption");
        encryptionAlgs.put("A192GCMKW", "AES-GCM-192 key encryption");
        encryptionAlgs.put("A256GCMKW", "AES-GCM-256 key encryption");
        encryptionAlgs.put("ECDH-ES", "ECDH-ES");
        encryptionAlgs.put("ECDH-ES+A128KW", "ECDH-ES with AES-128 Key Wrap");
        encryptionAlgs.put("ECDH-ES+A192KW", "ECDH-ES with AES-192 Key Wrap");
        encryptionAlgs.put("ECDH-ES+A256KW", "ECDH-ES with AES-256 Key Wrap");
        encryptionAlgs.put("RSA-OAEP", "RSAES OAEP");
        encryptionAlgs.put("RSA-OAEP-256", "RSAES OAEP using SHA-256 and MGF1 with SHA-256");
        contentEncryptionAlgs.put("A128CBC-HS256", "Composite AES-CBC-128 HMAC-SHA-256");
        contentEncryptionAlgs.put("A192CBC-HS384", "Composite AES-CBC-192 HMAC-SHA-384");
        contentEncryptionAlgs.put("A256CBC-HS512", "Composite AES-CBC-256 HMAC-SHA-512");
        contentEncryptionAlgs.put("A128GCM", "AES-GCM-128");
        contentEncryptionAlgs.put("A192GCM", "AES-GCM-192");
        contentEncryptionAlgs.put("A256GCM", "AES-GCM-256");
    }
}

