/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.domain;

import com.pingidentity.util.DateUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.openid.connect.domain.UserInfoAttrContract;
import org.sourceid.openid.connect.domain.UserInfoAttrMapping;

public class OpenIdConnectProviderPolicy {
    private String issuer;
    private String defaultPolicyGroupId;
    private boolean trackUserSessionsForLogout;
    private Map<String, PolicyGroup> policyGroups = new LinkedHashMap<String, PolicyGroup>();

    public boolean isEnabled() {
        return true;
    }

    @Deprecated
    public String getIssuer() {
        return this.issuer;
    }

    @Deprecated
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public PolicyGroup getDefaultPolicyGroup() {
        return this.policyGroups.get(this.defaultPolicyGroupId);
    }

    public String getDefaultPolicyGroupId() {
        return this.defaultPolicyGroupId;
    }

    public void setDefaultPolicyGroupId(String id) {
        this.defaultPolicyGroupId = id;
    }

    public Map<String, PolicyGroup> getPolicyGroups() {
        return this.policyGroups;
    }

    public void addPolicyGroup(PolicyGroup pg) {
        this.policyGroups.put(pg.getPolicyId(), pg);
    }

    public boolean containsPolicyGroup(String id) {
        return this.policyGroups.containsKey(id);
    }

    public void setPolicyGroups(LinkedHashMap<String, PolicyGroup> policyGroups) {
        this.policyGroups = policyGroups;
    }

    public PolicyGroup getPolicyGroup(String id) {
        return this.policyGroups.get(id);
    }

    public void deletePolicyGroup(String id) {
        this.policyGroups.remove(id);
    }

    public boolean isTrackUserSessionsForLogout() {
        return this.trackUserSessionsForLogout;
    }

    public void setTrackUserSessionsForLogout(boolean trackUserSessionsForLogout) {
        this.trackUserSessionsForLogout = trackUserSessionsForLogout;
    }

    public static class AttributeInclusionInfo {
        private boolean includeInIdToken;
        private boolean includeInUserInfo;

        public AttributeInclusionInfo(boolean includeInIdToken, boolean includeInUserInfo) {
            this.includeInIdToken = includeInIdToken;
            this.includeInUserInfo = includeInUserInfo;
        }

        public boolean isIncludeInIdToken() {
            return this.includeInIdToken;
        }

        public void setIncludeInIdToken(boolean includeInIdToken) {
            this.includeInIdToken = includeInIdToken;
        }

        public boolean isIncludeInUserInfo() {
            return this.includeInUserInfo;
        }

        public void setIncludeInUserInfo(boolean includeInUserInfo) {
            this.includeInUserInfo = includeInUserInfo;
        }
    }

    public static class PolicyGroup {
        private String policyId;
        private String name;
        private int idTokenLife;
        private UserInfoAttrContract userInfoAttributeContract = new UserInfoAttrContract();
        private UserInfoAttrMapping userInfoAttributeMapping = new UserInfoAttrMapping();
        private boolean includeSriInIdToken = false;
        private boolean includeUserInfoInIdToken = false;
        private boolean includeSHashInIdToken = false;
        private boolean includeX5tInIdToken = false;
        private String idTokenTypHeaderValue;
        private boolean returnIdTokenOnRefreshGrant = false;
        private boolean returnIdTokenOnTokenExchangeGrant = false;
        private String accessTokenManagerId;
        private Map<String, List<String>> scopeAttributeMappings = new HashMap<String, List<String>>();
        private Map<String, AttributeInclusionInfo> attributeInclusionMappings = new HashMap<String, AttributeInclusionInfo>();
        private boolean reissueIdTokenHybridFlows = false;
        private boolean allowIdTokenIntrospection = false;
        private Set<String> multiValuedAttributes = new HashSet<String>();
        private Calendar lastModified = null;

        public String getPolicyId() {
            return this.policyId;
        }

        public void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getIdTokenLife() {
            return this.idTokenLife;
        }

        public void setIdTokenLife(int idTokenLife) {
            this.idTokenLife = idTokenLife;
        }

        public void setIncludeSriInIdToken(boolean include) {
            this.includeSriInIdToken = include;
        }

        public boolean isIncludeSriInIdToken() {
            return this.includeSriInIdToken;
        }

        public UserInfoAttrContract getUserInfoAttributeContract() {
            return this.userInfoAttributeContract;
        }

        public void setUserInfoAttributeContract(UserInfoAttrContract userInfoAttributeContract) {
            this.userInfoAttributeContract = userInfoAttributeContract;
        }

        public UserInfoAttrMapping getUserInfoAttributeMapping() {
            return this.userInfoAttributeMapping;
        }

        public void setUserInfoAttributeMapping(UserInfoAttrMapping userInfoAttributeMapping) {
            this.userInfoAttributeMapping = userInfoAttributeMapping;
        }

        public String getAccessTokenManagerId() {
            return this.accessTokenManagerId;
        }

        public void setAccessTokenManagerId(String accessTokenManagerId) {
            this.accessTokenManagerId = accessTokenManagerId;
        }

        public boolean isIncludeUserInfoInIdToken() {
            return this.includeUserInfoInIdToken;
        }

        public void setIncludeUserInfoInIdToken(boolean includeUserInfoInIdToken) {
            this.includeUserInfoInIdToken = includeUserInfoInIdToken;
        }

        public boolean isIncludeSHashInIdToken() {
            return this.includeSHashInIdToken;
        }

        public void setIncludeSHashInIdToken(boolean includeSHash) {
            this.includeSHashInIdToken = includeSHash;
        }

        public boolean isIncludeX5tInIdToken() {
            return this.includeX5tInIdToken;
        }

        public void setIncludeX5tInIdToken(boolean includeX5tInIdToken) {
            this.includeX5tInIdToken = includeX5tInIdToken;
        }

        public String getIdTokenTypHeaderValue() {
            return this.idTokenTypHeaderValue;
        }

        public void setIdTokenTypHeaderValue(String idTokenTypHeaderValue) {
            this.idTokenTypHeaderValue = idTokenTypHeaderValue;
        }

        public boolean isReturnIdTokenOnRefreshGrant() {
            return this.returnIdTokenOnRefreshGrant;
        }

        public void setReturnIdTokenOnRefreshGrant(boolean returnIdTokenOnRefreshGrant) {
            this.returnIdTokenOnRefreshGrant = returnIdTokenOnRefreshGrant;
        }

        public boolean isReturnIdTokenOnTokenExchangeGrant() {
            return this.returnIdTokenOnTokenExchangeGrant;
        }

        public void setReturnIdTokenOnTokenExchangeGrant(boolean returnIdTokenOnTokenExchangeGrant) {
            this.returnIdTokenOnTokenExchangeGrant = returnIdTokenOnTokenExchangeGrant;
        }

        public void setScopeAttributeMappings(Map<String, List<String>> scopeAttributeMappings) {
            this.scopeAttributeMappings = scopeAttributeMappings;
        }

        public Map<String, List<String>> getScopeAttributeMappings() {
            return this.scopeAttributeMappings;
        }

        public Map<String, AttributeInclusionInfo> getAttributeInclusionMappings() {
            return this.attributeInclusionMappings;
        }

        public void setAttributeInclusionMappings(Map<String, AttributeInclusionInfo> attributeInclusionMappings) {
            this.attributeInclusionMappings = attributeInclusionMappings;
        }

        public boolean isReissueIdTokenHybridFlows() {
            return this.reissueIdTokenHybridFlows;
        }

        public void setReissueIdTokenHybridFlows(boolean reissueIdTokenHybridFlows) {
            this.reissueIdTokenHybridFlows = reissueIdTokenHybridFlows;
        }

        public boolean isAllowIdTokenIntrospection() {
            return this.allowIdTokenIntrospection;
        }

        public void setAllowIdTokenIntrospection(boolean allowIdTokenIntrospection) {
            this.allowIdTokenIntrospection = allowIdTokenIntrospection;
        }

        public Set<String> getMultiValuedAttributes() {
            return this.multiValuedAttributes;
        }

        public void setMultiValuedAttributes(Set<String> multiValuedAttributes) {
            this.multiValuedAttributes = multiValuedAttributes;
        }

        public Calendar getLastModified() {
            return DateUtil.copyCalendar(this.lastModified);
        }

        public void setLastModified(Calendar lastModified) {
            this.lastModified = DateUtil.copyCalendar(lastModified);
        }
    }
}

