/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.SpaceDelimitedStringUtil;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailType;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ParServerPolicy;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.openid.ciba.CibaDeliveryMode;
import org.sourceid.openid.ciba.handlers.CibaHelper;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.UserInfoAttrContract;
import org.sourceid.openid.connect.domain.UserInfoClaims;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.openid.connect.model.Prompt;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.IDPLocalPathMappings;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.websso.profiles.BasicHttpRequestHandler;
import org.sourceid.websso.servlet.HttpStatusCodeException;

public class ProviderConfigurationInfoHandler
implements BasicHttpRequestHandler {
    private final ConnectProviderRuntimePolicySupport policySupport = new ConnectProviderRuntimePolicySupport();
    private final AuthzServerManager authnServerSettingsManager = MgmtFactory.getAuthzServerManager();
    private final OpenIdConnectProviderPolicyManager connectProviderPolicyManager = this.policySupport.getConnectProviderPolicyManager();
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private final CibaHelper cibaHelper = new CibaHelper();
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();
    private static final String WELL_KNOWN_TEMPLATE_FILE = "openid-configuration.template.json";
    private static final String EXCLUSIVE_SCOPES_SUPPORTED = "exclusive_scopes_supported";
    private final ProviderType providerType;

    private ProviderConfigurationInfoHandler(ProviderType type) {
        this.providerType = type;
    }

    public static ProviderConfigurationInfoHandler createOpenIDConnectProviderConfigurationInfoHandler() {
        return new ProviderConfigurationInfoHandler(ProviderType.OPEN_ID_CONNECT);
    }

    public static ProviderConfigurationInfoHandler createOAuthProviderConfigurationInfoHandler() {
        return new ProviderConfigurationInfoHandler(ProviderType.OAUTH);
    }

    @Override
    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException, HttpStatusCodeException {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        String issuer = this.oAuthIssuerUtils.getIssuerValue(req);
        info.put("issuer", issuer);
        info.put("authorization_endpoint", issuer + "/as/authorization.oauth2");
        info.put("token_endpoint", this.getTokenEndpointBaseUrl(issuer) + "/as/token.oauth2");
        info.put("revocation_endpoint", issuer + "/as/revoke_token.oauth2");
        info.put("userinfo_endpoint", issuer + "/idp/userinfo.openid");
        info.put("introspection_endpoint", issuer + "/as/introspect.oauth2");
        info.put("device_authorization_endpoint", issuer + "/as/device_authz.oauth2");
        info.put("backchannel_authentication_endpoint", issuer + "/as/bc-auth.ciba");
        ParServerPolicy.Status parStatus = this.authnServerSettingsManager.getParServerPolicy().getStatus();
        if (parStatus != ParServerPolicy.Status.DISABLED) {
            info.put("pushed_authorization_request_endpoint", issuer + "/as/par.oauth2");
        }
        info.put("require_pushed_authorization_requests", parStatus == ParServerPolicy.Status.REQUIRED);
        info.put("end_session_endpoint", issuer + "/idp/init_logout.openid");
        info.put("jwks_uri", issuer + "/pf/JWKS");
        info.put("registration_endpoint", issuer + "/as/clients.oauth2");
        info.put("ping_revoked_sris_endpoint", issuer + "/pf-ws/rest/sessionMgmt/revokedSris");
        info.put("ping_session_management_sris_endpoint", issuer + "/pf-ws/rest/sessionMgmt/sessions");
        info.put("ping_session_management_users_endpoint", issuer + "/pf-ws/rest/sessionMgmt/users");
        IDPLocalPathMappings idpLocalPaths = this.localMetaData.getIdpLocalPathMappings();
        String idpInitSloPath = idpLocalPaths.getInitiateSLOPath();
        info.put("ping_end_session_endpoint", issuer + idpInitSloPath);
        info.put("backchannel_logout_supported", true);
        info.put("backchannel_logout_session_supported", true);
        info.put("frontchannel_logout_supported", true);
        info.put("frontchannel_logout_session_supported", true);
        ArrayList<String> dynamicCommonScopes = new ArrayList<String>(ScopeUtil.getDynamicCommonScopeDescriptions().keySet());
        info.put("dynamic_scopes_supported", dynamicCommonScopes);
        ArrayList<String> dynamicExclusiveScopes = new ArrayList<String>(ScopeUtil.getDynamicExclusiveScopeDescriptions().keySet());
        info.put("dynamic_exclusive_scopes_supported", dynamicExclusiveScopes);
        ArrayList<String> supportedScopes = new ArrayList<String>(ScopeUtil.getScopeAndGroupNames());
        supportedScopes.removeAll(dynamicCommonScopes);
        supportedScopes.removeAll(dynamicExclusiveScopes);
        info.put("scopes_supported", supportedScopes);
        ArrayList<String> supportedExclusiveScopes = new ArrayList<String>(ScopeUtil.getExclusiveScopeAndGroupNames());
        supportedExclusiveScopes.removeAll(dynamicExclusiveScopes);
        info.put(EXCLUSIVE_SCOPES_SUPPORTED, supportedExclusiveScopes);
        String policyId = req.getParameter("policy_id");
        OpenIdConnectProviderPolicy policy = this.connectProviderPolicyManager.getPolicy();
        if (policy.getPolicyGroups().size() > 0) {
            policyId = policy.containsPolicyGroup(policyId) ? policyId : policy.getDefaultPolicyGroup().getPolicyId();
            OpenIdConnectProviderPolicy.PolicyGroup policyGroup = policy.getPolicyGroup(policyId);
            UserInfoAttrContract userInfoAttributeContract = policyGroup.getUserInfoAttributeContract();
            ResponseType.ResponseMode[] claimsSet = userInfoAttributeContract.getAllAttributeNames();
            for (String addressClaimMember : UserInfoClaims.ADDRESS_CLAIMS) {
                if (!claimsSet.remove(addressClaimMember)) continue;
                claimsSet.add((String)"address");
            }
            if (policyGroup.isIncludeSriInIdToken()) {
                claimsSet.add((String)"pi.sri");
                claimsSet.add((String)"sid");
            }
            ArrayList<String> claims = new ArrayList<String>((Collection<String>)claimsSet);
            claims.sort(String.CASE_INSENSITIVE_ORDER);
            if (claims.size() > 0) {
                info.put("claims_supported", claims);
            }
        }
        ArrayList<String> responseTypes = new ArrayList<String>();
        responseTypes.add("code");
        responseTypes.add("token");
        responseTypes.add("id_token");
        responseTypes.add(SpaceDelimitedStringUtil.toString((String[])new String[]{"code", "token"}));
        responseTypes.add(SpaceDelimitedStringUtil.toString((String[])new String[]{"code", "id_token"}));
        responseTypes.add(SpaceDelimitedStringUtil.toString((String[])new String[]{"token", "id_token"}));
        responseTypes.add(SpaceDelimitedStringUtil.toString((String[])new String[]{"code", "token", "id_token"}));
        info.put("response_types_supported", responseTypes);
        ArrayList<String> responseModes = new ArrayList<String>();
        for (ResponseType.ResponseMode mode : ResponseType.ResponseMode.values()) {
            responseModes.add(mode.toString());
        }
        if (!MgmtFactory.getAuthnApiManager().isApiEnabled()) {
            responseModes.remove(ResponseType.ResponseMode.pi_flow.toString());
        }
        info.put("response_modes_supported", responseModes);
        ArrayList<String> grantTypes = new ArrayList<String>(Arrays.asList("implicit", "authorization_code", "refresh_token", "password", "client_credentials", "urn:pingidentity.com:oauth2:grant_type:validate_bearer", "urn:ietf:params:oauth:grant-type:jwt-bearer", "urn:ietf:params:oauth:grant-type:saml2-bearer", "urn:ietf:params:oauth:grant-type:device_code", "urn:ietf:params:oauth:grant-type:token-exchange", "urn:openid:params:grant-type:ciba"));
        info.put("grant_types_supported", grantTypes);
        info.put("subject_types_supported", new ArrayList<String>(Arrays.asList("public", "pairwise")));
        List<String> idTokenSigningAlgs = OpenIdConnectProviderInfo.idTokenSigningAlgValuesSupportedWithNoneHmac();
        info.put("id_token_signing_alg_values_supported", idTokenSigningAlgs);
        info.put("token_endpoint_auth_methods_supported", new ArrayList<String>(Arrays.asList("client_secret_basic", "client_secret_post", "client_secret_jwt", "private_key_jwt", "tls_client_auth", "none")));
        info.put("token_endpoint_auth_signing_alg_values_supported", OpenIdConnectProviderInfo.getVerificationAlgorithmsSupported());
        info.put("claim_types_supported", Collections.singletonList("normal"));
        info.put("claims_parameter_supported", false);
        info.put("request_parameter_supported", true);
        info.put("request_uri_parameter_supported", false);
        info.put("request_object_signing_alg_values_supported", OpenIdConnectProviderInfo.getAsymmetricVerificationAlgorithmsSupported());
        info.put("request_object_encryption_alg_values_supported", OpenIdConnectProviderInfo.getEncryptionAlgorithms());
        info.put("request_object_encryption_enc_values_supported", OpenIdConnectProviderInfo.getContentEncryptionAlgorithms());
        info.put("id_token_encryption_alg_values_supported", OpenIdConnectProviderInfo.getEncryptionAlgorithms());
        info.put("id_token_encryption_enc_values_supported", OpenIdConnectProviderInfo.getContentEncryptionAlgorithms());
        info.put("userinfo_signing_alg_values_supported", OpenIdConnectProviderInfo.jwtSigningAlgorithmSetWithHmacWithoutNone());
        info.put("userinfo_encryption_alg_values_supported", OpenIdConnectProviderInfo.getEncryptionAlgorithms());
        info.put("userinfo_encryption_enc_values_supported", OpenIdConnectProviderInfo.getContentEncryptionAlgorithms());
        info.put("backchannel_token_delivery_modes_supported", new ArrayList<CibaDeliveryMode>(Arrays.asList(CibaDeliveryMode.values())));
        info.put("backchannel_authentication_request_signing_alg_values_supported", OpenIdConnectProviderInfo.getAsymmetricVerificationAlgorithmsSupported());
        info.put("backchannel_user_code_parameter_supported", this.cibaHelper.userCodeSupportedInDefaultPolicy());
        info.put("authorization_response_iss_parameter_supported", this.authnServerSettingsManager.isIncludeIssuerInAuthzResponse());
        info.put("introspection_signing_alg_values_supported", OpenIdConnectProviderInfo.jwtSigningAlgorithmSetWithHmacWithoutNone());
        info.put("introspection_encryption_alg_values_supported", OpenIdConnectProviderInfo.getEncryptionAlgorithms());
        info.put("introspection_encryption_enc_values_supported", OpenIdConnectProviderInfo.getContentEncryptionAlgorithms());
        info.put("authorization_signing_alg_values_supported", OpenIdConnectProviderInfo.jwtSigningAlgorithmSetWithHmacWithoutNone());
        info.put("authorization_encryption_alg_values_supported", OpenIdConnectProviderInfo.getEncryptionAlgorithms());
        info.put("authorization_encryption_enc_values_supported", OpenIdConnectProviderInfo.getContentEncryptionAlgorithms());
        info.put("authorization_details_types_supported", MgmtFactory.getAuthorizationDetailTypesManager().getAllAuthorizationDetailTypes().stream().filter(AuthorizationDetailType::isActive).map(AuthorizationDetailType::getType).collect(Collectors.toList()));
        ArrayList<String> pkceMethods = new ArrayList<String>();
        if (!this.authnServerSettingsManager.isRestrictPlainPKCE()) {
            pkceMethods.add("plain");
        }
        pkceMethods.add("S256");
        info.put("code_challenge_methods_supported", pkceMethods);
        info.put("type", this.providerType.getValue());
        info.put("dpop_signing_alg_values_supported", DpopUtil.getSupportedSigningAlgorithms());
        info.put("prompt_values_supported", Prompt.PROMPT_VALUES_SUPPORTED);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("info", info);
        ResponseTemplateRenderer templateRenderer = ResponseTemplateRenderer.getInstance();
        templateRenderer.render(req, resp, WELL_KNOWN_TEMPLATE_FILE, results, "application/json", true);
    }

    private String getTokenEndpointBaseUrl(String currentBaseUrl) {
        return StringUtils.isBlank((String)this.authnServerSettingsManager.getTokenEndpointBaseUrl()) ? currentBaseUrl : this.authnServerSettingsManager.getTokenEndpointBaseUrl();
    }

    private static enum ProviderType {
        OAUTH("oauth"),
        OPEN_ID_CONNECT("openid-connect");

        private final String value;

        private ProviderType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

