/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.handlers;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.locale.LocaleUtil;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientVerificationSecretResolver;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.utils.ClientSecretUtils;
import org.sourceid.oauth20.utils.JwtProcessingUtils;
import org.sourceid.openid.connect.MultiSigningKeyResolver;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.profiles.idp.StartSloRequest;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.OidcSession;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.util.UriValidationUtil;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.RequestHandlerBase;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.ExtendedSri;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class RpInitiatedLogoutEndpoint
extends RequestHandlerBase
implements SloHandler {
    private static final Log log = LogFactory.getLog(RpInitiatedLogoutEndpoint.class);
    private final SLOSupport sloSupport = new SLOSupport(MetaDataFactory.getLocalMetaData());

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        return new OutMessageContext(Role.SP);
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        req = this.wrapRequest(inMsgCtx, req);
        ArrayList<String> problems = new ArrayList<String>();
        if (e.getCause() instanceof InvalidRequestParameterException) {
            problems.add(e.getCause().getMessage());
        }
        this.sloSupport.renderErrorPage(req, resp, problems);
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        try {
            IdTokenHintInfo idTokenHintInfo;
            String clientId = inMsgCtx.getParam(Parameters.CLIENT_ID);
            String logoutHint = inMsgCtx.getParam("logout_hint");
            String idTokenHint = inMsgCtx.getParam("id_token_hint");
            String requestedRedirectUri = inMsgCtx.getParam("post_logout_redirect_uri");
            String state = inMsgCtx.getParam("state");
            String uiLocales = inMsgCtx.getParam("ui_locales");
            if (logoutHint != null && log.isDebugEnabled()) {
                log.debug((Object)"logout_hint was provided but will be ignored (PingFederate does not support this optional parameter)");
            }
            Client clientFromClientId = null;
            if (clientId != null) {
                clientFromClientId = MgmtFactory.getClientManager().getCachedClient(clientId);
                if (clientFromClientId == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(Parameters.CLIENT_ID + " not recognized"));
                    }
                    throw new InvalidRequestParameterException(Parameters.CLIENT_ID + " not recognized");
                }
                AsAuditLogger.setPartnerId(clientFromClientId.getClientId());
            }
            Client client = (idTokenHintInfo = this.getIdTokenHintInfo(idTokenHint, clientFromClientId, req, resp)) != null ? idTokenHintInfo.getClient() : clientFromClientId;
            String redirectUri = this.validateRedirectUri(requestedRedirectUri, state, client);
            this.logRequest(client, idTokenHintInfo, redirectUri);
            String requestStateRef = this.sloSupport.makeRequestStateRef();
            StartSloRequest startSloRequest = new StartSloRequest(requestStateRef, redirectUri, true, null, null, false);
            if (StringUtils.isNotBlank((String)uiLocales)) {
                startSloRequest.setUiLocales(uiLocales);
            }
            startSloRequest.setConfirmLogout(idTokenHintInfo == null || idTokenHintInfo.getOidcSession() == null);
            this.sloSupport.sendStartSloRequest(startSloRequest, req, resp);
        }
        catch (InvalidRequestParameterException e) {
            throw new RequestProcessingException("An invalid request parameter was provided: " + e.getMessage(), e);
        }
    }

    private String validateRedirectUri(String requestedRedirectUri, String state, Client client) {
        if (requestedRedirectUri == null) {
            return null;
        }
        if (client == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No client could be identified from the " + Parameters.CLIENT_ID + " and id_token_hint parameters, so post_logout_redirect_uri will be ignored"));
            }
            return null;
        }
        if (UriValidationUtil.compareAsUris(requestedRedirectUri, client.getPostLogoutRedirectUris(), false, false)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found match between post_logout_redirect_uri and client's registered post-logout redirect URIs");
            }
            if (StringUtils.isNotBlank((String)state)) {
                return requestedRedirectUri + "?state=" + state;
            }
            return requestedRedirectUri;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post_logout_redirect_uri does not match one of client's registered post-logout redirect URIs, so it will be ignored");
        }
        return null;
    }

    private void logRequest(Client client, IdTokenHintInfo idTokenHintInfo, String redirectUri) {
        String clientId = null;
        String username = null;
        String issuer = null;
        String sid = null;
        if (client != null) {
            clientId = client.getClientId();
            AsAuditLogger.setPartnerId(clientId);
        }
        if (idTokenHintInfo != null) {
            if (idTokenHintInfo.getOidcSession() != null) {
                username = idTokenHintInfo.getOidcSession().getUserNameForLog();
                AsAuditLogger.setUserName(username);
            }
            if ((issuer = idTokenHintInfo.getIssuer()) != null) {
                AsAuditLogger.setVirtualServerId(issuer);
            }
            if ((sid = idTokenHintInfo.getSid()) != null) {
                TrackingIdSupport.addReference(sid);
                try {
                    AsAuditLogger.setExtendedSri(new ExtendedSri(sid));
                }
                catch (InvalidParameterException e) {
                    log.error((Object)("Unexpected error parsing sid as SRI: " + e.getMessage()));
                }
            }
            if (idTokenHintInfo.getJti() != null) {
                AsAuditLogger.setIdTokenJti(idTokenHintInfo.getJti());
            }
        }
        AsAuditLogger.setEvent("SLO");
        AsAuditLogger.setProtocol(Protocol.OIDC.toString());
        ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"SP");
        AsAuditLogger.log("RP-initiated logout");
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Handling RP-initiated logout request");
            if (clientId != null) {
                sb.append(", client id: ").append(clientId);
            }
            if (username != null) {
                sb.append(", username: ").append(username);
            }
            if (issuer != null) {
                sb.append(", issuer: ").append(issuer);
            }
            if (sid != null) {
                sb.append(", sid: ").append(sid);
            }
            if (redirectUri != null) {
                sb.append(", redirect uri: ").append(redirectUri);
            }
            log.debug((Object)sb.toString());
        }
    }

    private IdTokenHintInfo getIdTokenHintInfo(String idTokenHint, Client clientFromClientId, HttpServletRequest req, HttpServletResponse resp) throws InvalidParameterException {
        if (idTokenHint == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"id_token_hint was not provided, user will be prompted to confirm logout");
            }
            return null;
        }
        IdTokenHintInfo idTokenHintInfo = this.validateIdTokenHint(idTokenHint, clientFromClientId, req);
        if (idTokenHintInfo == null) {
            return null;
        }
        Map<IdpHashableAuthnBean, Collection<Session>> registered = IdpSessionRegistrySupport.getRegisteredForSession(req, resp);
        List sessions = registered.values().stream().flatMap(Collection::stream).filter(Session::isOidcSession).collect(Collectors.toList());
        OidcSession foundOidcSession = null;
        for (Session session : sessions) {
            OidcSession oidcSession = (OidcSession)session;
            if (!oidcSession.getClientId().equals(idTokenHintInfo.getClient().getClientId()) || !StringUtils.equals((String)oidcSession.getIssuer(), (String)idTokenHintInfo.getIssuer()) || !StringUtils.equals((String)oidcSession.getSubject(), (String)idTokenHintInfo.getSubject()) || idTokenHintInfo.getSid() != null && !StringUtils.equals((String)oidcSession.getExtendedSri(), (String)idTokenHintInfo.getSid())) continue;
            foundOidcSession = oidcSession;
            break;
        }
        if (foundOidcSession != null) {
            idTokenHintInfo.setOidcSession(foundOidcSession);
            return idTokenHintInfo;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No matching session found for " + Parameters.CLIENT_ID + ", iss, sub, and sid. Please ensure client's logout mode is not None."));
        }
        return idTokenHintInfo;
    }

    private IdTokenHintInfo validateIdTokenHint(String idTokenHint, Client clientFromClientId, HttpServletRequest req) throws InvalidRequestParameterException {
        try {
            JwtClaims jwtClaims;
            JsonWebStructure structure = JsonWebStructure.fromCompactSerialization((String)idTokenHint);
            boolean encrypted = structure instanceof JsonWebEncryption;
            if (encrypted && clientFromClientId == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("id_token_hint is encrypted, but no " + Parameters.CLIENT_ID + " was provided, the id_token_hint will be ignored"));
                }
                return null;
            }
            JwtConsumerBuilder consumerBuilder = new JwtConsumerBuilder().setSkipAllValidators().setSkipSignatureVerification();
            if (encrypted) {
                try {
                    jwtClaims = JwtProcessingUtils.processEncryptedJwt(idTokenHint, consumerBuilder, clientFromClientId, ClientSecretUtils.ActivityType.ID_TOKEN_HINT_DECRYPTION);
                }
                catch (InvalidJwtException e) {
                    this.logIdTokenHintValidationError("decrypting", (Exception)((Object)e), false);
                    return null;
                }
            } else {
                jwtClaims = consumerBuilder.build().processToClaims(idTokenHint);
            }
            Client client = this.resolveClient(jwtClaims, clientFromClientId);
            JsonWebKeySet jwks = OAuthIssuerUtils.getInstance().getIssuersJsonWebKeySet(req);
            MultiSigningKeyResolver signingKeyResolver = new MultiSigningKeyResolver(new ClientVerificationSecretResolver(client), (VerificationKeyResolver)new JwksVerificationKeyResolver(jwks.getJsonWebKeys()));
            consumerBuilder = new JwtConsumerBuilder().setSkipAllValidators().setVerificationKeyResolver((VerificationKeyResolver)signingKeyResolver).setJwsAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE);
            try {
                jwtClaims = JwtProcessingUtils.processEncryptedJwt(idTokenHint, consumerBuilder, client, ClientSecretUtils.ActivityType.ID_TOKEN_HINT_DECRYPTION);
            }
            catch (InvalidJwtException e) {
                this.logIdTokenHintValidationError("verifying signature of", (Exception)((Object)e), false);
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully validated id_token_hint for logout request");
            }
            return new IdTokenHintInfo(jwtClaims, client);
        }
        catch (MalformedClaimException | InvalidJwtException | JoseException e) {
            this.logIdTokenHintValidationError("decoding", (Exception)e, true);
            throw new InvalidRequestParameterException("Invalid id_token_hint");
        }
    }

    private Client resolveClient(JwtClaims jwtClaims, Client clientFromClientId) throws InvalidParameterException, MalformedClaimException {
        if (clientFromClientId != null && !jwtClaims.getAudience().contains(clientFromClientId.getClientId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("id_token_hint audiences " + LogGuard.encode(jwtClaims.getAudience().toString()) + " do not include the provided " + Parameters.CLIENT_ID + ": " + clientFromClientId.getClientId()));
            }
            throw new InvalidRequestParameterException("Invalid id_token_hint");
        }
        if (clientFromClientId != null) {
            return clientFromClientId;
        }
        for (String audience : jwtClaims.getAudience()) {
            Client client = MgmtFactory.getClientManager().getCachedClient(audience);
            if (client == null) continue;
            return client;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("id_token_hint audiences " + LogGuard.encode(jwtClaims.getAudience().toString()) + " do not match a configured client"));
        }
        throw new InvalidRequestParameterException("Invalid id_token_hint");
    }

    private void logIdTokenHintValidationError(String context, Exception cause, boolean severe) throws InvalidParameterException {
        if (log.isDebugEnabled()) {
            String message = "An error occurred while " + context + " id_token_hint";
            if (!severe) {
                message = message + ", this parameter will be ignored";
            }
            if (log.isTraceEnabled()) {
                message = message + ": " + cause.getMessage();
            }
            log.debug((Object)message);
        }
    }

    private HttpServletRequest wrapRequest(InMessageContext inMsgCtx, HttpServletRequest req) {
        String uiLocales = inMsgCtx.getParam("ui_locales");
        if (StringUtils.isNotBlank((String)uiLocales)) {
            return LocaleUtil.createLocaleWrappedRequest(req, uiLocales);
        }
        return req;
    }

    private static class IdTokenHintInfo {
        private final String issuer;
        private final Client client;
        private final String subject;
        private final String sid;
        private final String jti;
        private OidcSession oidcSession;

        public IdTokenHintInfo(JwtClaims claims, Client client) throws MalformedClaimException {
            this.issuer = claims.getIssuer();
            this.client = client;
            this.subject = claims.getSubject();
            this.sid = claims.getStringClaimValue("sid");
            this.jti = claims.getJwtId();
        }

        public String getIssuer() {
            return this.issuer;
        }

        public Client getClient() {
            return this.client;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getSid() {
            return this.sid;
        }

        public String getJti() {
            return this.jti;
        }

        public OidcSession getOidcSession() {
            return this.oidcSession;
        }

        public void setOidcSession(OidcSession oidcSession) {
            this.oidcSession = oidcSession;
        }
    }
}

