/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.profiles.sp;

import com.pingidentity.common.util.Base64URL;
import java.util.Arrays;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwt.consumer.Validator;
import org.jose4j.jwx.JsonWebStructure;
import org.sourceid.openid.connect.LeftHalfHash;

public class AtHashValidator
implements Validator {
    String accessToken;
    boolean viaFrontChannel;

    public AtHashValidator(String accessToken, boolean viaFrontChannel) {
        this.accessToken = accessToken;
        this.viaFrontChannel = viaFrontChannel;
    }

    public String validate(JwtContext jwtContext) throws MalformedClaimException {
        boolean accessTokenPresent;
        JwtClaims claims = jwtContext.getJwtClaims();
        boolean hasClaim = claims.hasClaim("at_hash");
        boolean bl = accessTokenPresent = this.accessToken != null;
        if (hasClaim) {
            JsonWebStructure jws;
            String alg;
            byte[] calculated;
            if (!accessTokenPresent) {
                return "at_hash in the ID token but no access token present.";
            }
            String atHashString = claims.getStringClaimValue("at_hash");
            byte[] atHash = Base64URL.decode((String)atHashString);
            if (!Arrays.equals(atHash, calculated = LeftHalfHash.leftHalfHashToBytes(this.accessToken, alg = (jws = (JsonWebStructure)jwtContext.getJoseObjects().get(0)).getAlgorithmHeaderValue()))) {
                return "at_hash does not match the value calculated from the access token: " + Base64URL.encodeToString((byte[])calculated);
            }
        } else if (accessTokenPresent && this.viaFrontChannel) {
            return "at_hash is required in this context to bind the access and ID tokens together.";
        }
        return null;
    }
}

