/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.profiles.sp;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.oauth20.handlers.GeneralOAuthError;
import org.sourceid.openid.connect.profiles.sp.LogoutException;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.profiles.idp.StartSloRequest;
import org.sourceid.saml20.profiles.idp.StartSloResponse;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumableRequestHandlerBase;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class FrontChannelLogoutEndpoint
extends ResumableRequestHandlerBase
implements SloHandler {
    private static final String SIGNOUT_TEMPLATE = "sourceid-wsfed-sp-signout-cleanup-template.html";
    private static final String KEY_REQUEST_STATE_REF = "requestStateRef";
    private static final String MSG_INCOMPLETE = "Unable to completely sign out of ";
    private static final String MSG_EXCEPTION = "Exception occurred during signing out of ";
    private static final String VAR_SUCCESS = "success";
    private static final String VAR_SERVER_NAME = "servername";
    private static final String VAR_MSG = "msg";
    private final SLOSupport idpSloSupport;
    private final ResponseTemplateRenderer renderer;

    public FrontChannelLogoutEndpoint() {
        this.idpSloSupport = new SLOSupport(this.localMetaData);
        this.renderer = ResponseTemplateRenderer.getInstance();
    }

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        return new OutMessageContext(inMsgCtx.getRoleType());
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        String partnerEntityId = inMsgCtx.getEntityId();
        SpAuditLogger.setPartnerId(partnerEntityId);
        SpAuditLogger.setProtocol(Protocol.OIDC.name());
        ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"IdP");
        if (this.hasAnySessions(req, resp)) {
            IdpConnection idpConnection = MgmtFactory.getMetadataDirectory().getIdpConnection(partnerEntityId, true);
            LicenseManager.checkLicenseForConnection(idpConnection);
            String issuer = inMsgCtx.getParam("iss");
            String sid = inMsgCtx.getParam("sid");
            if (StringUtils.isNotBlank((String)issuer) && StringUtils.isNotBlank((String)sid)) {
                this.validateIssuer(issuer, idpConnection);
                String localSessionId = StateMgmtFactory.getLocalSessionId(req, resp);
                IdpSessionRegistrySupport.checkLogSessionDeleted(req, resp);
                IdpSessionRegistrySupport.setSessionBeansInvalidForSso(Collections.singletonList(localSessionId));
                IdpSessionRegistrySupport.deleteStoredSessions(req, resp, null);
                this.idpSloSupport.checkRevokeUserSession(req, resp);
                String requestStateRef = this.idpSloSupport.makeRequestStateRef();
                HashMap<String, Object> otherInfo = new HashMap<String, Object>();
                otherInfo.put(KEY_REQUEST_STATE_REF, requestStateRef);
                String resumeUrl = this.saveState(req, resp, inMsgCtx, outMsgCtx, otherInfo);
                StartSloRequest startSloRequest = new StartSloRequest(requestStateRef, resumeUrl, false, null, partnerEntityId, false);
                this.idpSloSupport.sendStartSloRequest(startSloRequest, req, resp);
            } else if (StringUtils.isBlank((String)issuer) && !StringUtils.isBlank((String)sid) || !StringUtils.isBlank((String)issuer) && StringUtils.isBlank((String)sid)) {
                throw new LogoutException(LogoutException.Error.invalid_request, "Logout request must have both issuer and sid included, or none. iss : " + req.getParameter("iss") + " and sid : " + req.getParameter("sid"));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Sessions not found");
            }
            this.sendResponse(req, resp, true, null);
        }
    }

    @Override
    protected void exeResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws RequestProcessingException, IOException, GeneralAdapterException, GeneralServiceException {
        String requestStateRef = (String)otherState.get(KEY_REQUEST_STATE_REF);
        StartSloResponse response = this.idpSloSupport.getStartSloResponse(requestStateRef, req, resp);
        if (response == null) {
            throw new RequestProcessingException("Expected StartSloResponse but none was found");
        }
        if (response.getOverallResult()) {
            this.sendResponse(req, resp, true, null);
        } else {
            this.sendResponse(req, resp, false, MSG_INCOMPLETE + req.getServerName());
        }
    }

    @Override
    protected boolean isStateAppropriate(State state) {
        return true;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) {
        if (e instanceof GeneralOAuthError) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Error processing logout request: " + ExceptionUtil.toStringWithCauses(e)));
            }
        } else {
            this.log.error((Object)"Unexpected error processing logout request", (Throwable)e);
        }
        this.sendResponse(req, resp, false, MSG_EXCEPTION + req.getServerName());
    }

    private boolean hasAnySessions(HttpServletRequest req, HttpServletResponse resp) {
        String localSessionId = StateMgmtFactory.getLocalSessionId(req, resp);
        Map<SpHashableAuthnBean, WebSsoSession> beansAndSessions = SpSessionRegistrySupport.lookupAuthnBeansAndSessions(localSessionId);
        return !beansAndSessions.isEmpty() || IdpSessionRegistrySupport.hasSessions(req, resp);
    }

    private void validateIssuer(String issuer, IdpConnection idpConnection) throws LogoutException {
        if (idpConnection.getEntityId().equals(issuer)) {
            return;
        }
        boolean isAdditionalIssuerMatchFound = false;
        if (idpConnection.isAllowAdditionalEntities()) {
            isAdditionalIssuerMatchFound = idpConnection.isAllowAllEntities() ? true : idpConnection.getAdditionalAllowedEntities().stream().anyMatch(entity -> entity.getEntityId().equals(issuer));
        }
        if (!isAdditionalIssuerMatchFound) {
            throw new LogoutException(LogoutException.Error.invalid_request, "Invalid issuer value in the logout request. iss : " + issuer);
        }
    }

    private void sendResponse(HttpServletRequest req, HttpServletResponse resp, boolean success, String msg) {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        if (success) {
            objMap.put(VAR_SERVER_NAME, req.getServerName());
        } else {
            objMap.put(VAR_MSG, msg);
        }
        objMap.put(VAR_SUCCESS, success);
        try {
            this.renderer.render(req, resp, SIGNOUT_TEMPLATE, objMap);
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Unable to send out signout cleanup message.", ex);
        }
    }
}

