/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.profiles.sp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.session.quotas.exception.SessionQuotaException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.ThreadContext;
import org.joda.time.DateTime;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.Validator;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.protocol.HttpsJwksCache;
import org.sourceid.oauth20.utils.ClientSecretUtils;
import org.sourceid.oauth20.utils.JwtProcessingUtils;
import org.sourceid.openid.connect.MultiDecryptionKeyResolver;
import org.sourceid.openid.connect.MultiSigningKeyResolver;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.openid.connect.profiles.sp.AtHashValidator;
import org.sourceid.openid.connect.profiles.sp.SHashValidator;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.openid.connect.util.OidcJwtRpIssuerValidator;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.Entity;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.ProfileProcessorMatrix;
import org.sourceid.saml20.profiles.sp.SLOSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupportBase;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.util.AuthenticationContextUtil;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.InvalidOidcResponseException;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;
import org.sourceid.websso.profiles.ResumableResponseHandlerBase;
import org.sourceid.websso.profiles.sp.IdpIdCookieSupport;
import org.sourceid.websso.profiles.sp.ProvisioningProcessor;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.profiles.sp.SsoRespSupport;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class HandleOIDCResponse
extends ResumableResponseHandlerBase {
    private static final String KEY_ASSERTION_ATTRIBUTES = "HOIDCR.AssertionAttributes";
    private static final String APPLICATION_JWT = "application/JWT";
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.buildObjectMapper();
    protected final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    protected final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private final SsoRespSupport ssoRespSupport = new SsoRespSupport(this.localMetaData);
    private static final Log log = LogFactory.getLog(HandleOIDCResponse.class);
    private final ProfileProcessorMatrix profileProcessorMatrix = ProfileProcessorMatrix.getInstance();
    private final SpAdapterSupport spAdapterSupport = new SpAdapterSupport();
    private final SLOSupport sloSupport = new SLOSupport();
    private final ProvisioningProcessor provisioningProcessor = new ProvisioningProcessor();
    private final HttpsJwksCache httpsJwksCache = HttpsJwksCache.getInstance();
    private static final AlgorithmConstraints ENC_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, OpenIdConnectProviderInfo.getEncryptionAlgorithms().toArray(new String[OpenIdConnectProviderInfo.getEncryptionAlgorithms().size()]));
    private static final AlgorithmConstraints CONTENT_ENC_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, OpenIdConnectProviderInfo.getContentEncryptionAlgorithms().toArray(new String[OpenIdConnectProviderInfo.getContentEncryptionAlgorithms().size()]));

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public void doProcess(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws InvalidResponseException, IOException, RenderPageException {
        String subject;
        JwtConsumerBuilder jwtConsumerBuilder;
        String partnerEntityId = respMsgCtx.getEntityId();
        SpAuditLogger.setPartnerId(partnerEntityId);
        IdpConnection idpConnection = MetadataSupport.getIdpConnection(partnerEntityId);
        if (idpConnection == null) {
            String message = "The IdP connection " + LogGuard.encode(partnerEntityId) + " does not exist.";
            log.error((Object)message);
            throw new InvalidSsoResponseException(message);
        }
        if (idpConnection.getOidcSettings() == null) {
            String message = "The IdP connection " + LogGuard.encode(partnerEntityId) + " does not have OIDC enabled.";
            log.error((Object)message);
            throw new InvalidSsoResponseException(message);
        }
        HashMap<String, Long> claims = new HashMap<String, Long>();
        OIDCSettings settings = idpConnection.getOidcSettings();
        String accessTokenString = respMsgCtx.getParam("access_token");
        SpAuditLogger.setInAccessTokenHash(accessTokenString);
        String jwksUri = settings.getJwksUri().getFullLocation();
        HttpsJwks httpsJwks = this.httpsJwksCache.getJwks(jwksUri, idpConnection.getEntityId());
        try {
            String originalNonce;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using JWKS URI: " + jwksUri));
            }
            boolean isSignatureRequired = respMsgCtx.isSignatureRequired();
            String jwt = respMsgCtx.getParam("id_token");
            OidcJwtRpIssuerValidator customerIssuerValidator = new OidcJwtRpIssuerValidator(partnerEntityId, idpConnection.getAdditionalAllowedEntities().stream().map(Entity::getEntityId).collect(Collectors.toSet()), idpConnection.isAllowAllEntities());
            AtHashValidator atHashValidator = new AtHashValidator(accessTokenString, isSignatureRequired);
            SHashValidator sHashValidator = new SHashValidator(respMsgCtx.getRelayState());
            String expectedAudience = settings.getClientId();
            MultiSigningKeyResolver resolver = new MultiSigningKeyResolver(settings.getSecretAsUtf8Bytes(), httpsJwks);
            jwtConsumerBuilder = new JwtConsumerBuilder().setRequireIssuedAt().setRequireSubject().setRequireExpirationTime().registerValidator((ErrorCodeValidator)customerIssuerValidator).setExpectedAudience(new String[]{expectedAudience}).registerValidator((Validator)atHashValidator).registerValidator((Validator)sHashValidator);
            if (isSignatureRequired) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Signature is required");
                }
                jwtConsumerBuilder.setVerificationKeyResolver((VerificationKeyResolver)resolver);
                jwtConsumerBuilder.setJwsAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Signature is not required");
                }
                jwtConsumerBuilder.setJwsAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
                jwtConsumerBuilder.setDisableRequireSignature();
                jwtConsumerBuilder.setVerificationKeyResolver((jws, ctx) -> "none".equals(jws.getAlgorithmHeaderValue()) ? null : resolver.resolveKey(jws, ctx));
            }
            MultiDecryptionKeyResolver decryptionKeyResolver = new MultiDecryptionKeyResolver(settings.getSecretAsUtf8Bytes());
            jwtConsumerBuilder.setDecryptionKeyResolver((DecryptionKeyResolver)decryptionKeyResolver);
            jwtConsumerBuilder.setJweAlgorithmConstraints(ENC_CONSTRAINTS);
            jwtConsumerBuilder.setJweContentEncryptionAlgorithmConstraints(CONTENT_ENC_CONSTRAINTS);
            JwtProcessingUtils.checkApplyKeyProviderContextOverride(jwt, decryptionKeyResolver, jwtConsumerBuilder);
            JwtConsumer jwtConsumer = jwtConsumerBuilder.build();
            JwtClaims jwtClaims = jwtConsumer.processToClaims(jwt);
            subject = jwtClaims.getSubject();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Subject from JWT Claims: " + subject));
            }
            Map payload = jwtClaims.getClaimsMap();
            String returnedNonce = (String)payload.get("nonce");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returned nonce: " + returnedNonce));
            }
            claims.putAll(payload);
            if (payload.get("auth_time") != null) {
                claims.put(AssertionMapKeys.getAuthnInstantKey(), (Long)payload.get("auth_time") * 1000L);
            }
            if ((originalNonce = respMsgCtx.getParam("originalNonce")) == null) {
                String message = "Original nonce value is not found or already removed for this session.";
                log.error((Object)message);
                throw new InvalidSsoResponseException(message);
            }
            if (!originalNonce.equals(returnedNonce)) {
                String message = "nonce values do not match for this session.";
                log.error((Object)message);
                throw new InvalidSsoResponseException(message);
            }
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            log.error((Object)e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            throw new InvalidSsoResponseException("Jwt was not validated for issuer: " + partnerEntityId, e);
        }
        log.debug((Object)("entityId: " + respMsgCtx.getEntityId()));
        SpAuditLogger.setProtocol(idpConnection.getProtocol().toString());
        LicenseManager.checkLicenseForConnection(idpConnection);
        if (respMsgCtx.isUnsolicitedResponse()) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"IdP");
            EnabledProfiles profs = idpConnection.getEnabledProfiles();
            this.profileProcessorMatrix.verifyProcessorEnablement(2, profs);
        } else {
            ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"SP");
        }
        AttributeValue accessToken = new AttributeValue(accessTokenString);
        accessToken.setMasked(true);
        claims.put("access_token", (Long)accessToken);
        if (settings.getUserInfoEndpoint() != null && StringUtils.isNotBlank((String)settings.getUserInfoEndpoint().getLocation()) && StringUtils.isNotBlank((String)accessToken.getValue())) {
            String responseString;
            String responseContentType;
            String userInfoEndpoint = settings.getUserInfoEndpoint().getFullLocation();
            HttpGet getRequest = new HttpGet(userInfoEndpoint);
            getRequest.setHeader("Authorization", "Bearer " + accessToken);
            try (TimerScope ignored = Meters.getTimerScope("connection.userinfo", "connection.id", idpConnection.getEntityId());
                 CloseableHttpResponse userInfoResp = HttpConnectionPoolingManager.getInstance().doRequestWithResponse((HttpRequestBase)getRequest);){
                responseContentType = userInfoResp.getEntity().getContentType().getValue();
                responseString = EntityUtils.toString((HttpEntity)userInfoResp.getEntity(), (Charset)Consts.UTF_8);
            }
            catch (IOException e) {
                Meters.getCounter("connection.userinfo.errors", "connection.id", idpConnection.getEntityId()).increment();
                throw e;
            }
            if (responseString != null) {
                if (StringUtils.containsIgnoreCase((String)responseContentType, (String)APPLICATION_JWT)) {
                    JwtClaims jwtClaims;
                    log.debug((Object)("Processing JWT response from UserInfo endpoint " + userInfoEndpoint));
                    Client client = new Client();
                    client.setSecret(Obfuscator.deobfuscate(settings.getClientSecret()));
                    MultiSigningKeyResolver signingKeyResolver = new MultiSigningKeyResolver(settings.getSecretAsUtf8Bytes(), httpsJwks);
                    jwtConsumerBuilder = new JwtConsumerBuilder().setRequireSubject().setExpectedIssuer(partnerEntityId).setExpectedAudience(new String[]{settings.getClientId()}).setVerificationKeyResolver((VerificationKeyResolver)signingKeyResolver);
                    try {
                        jwtClaims = JwtProcessingUtils.processEncryptedJwt(responseString, jwtConsumerBuilder, client, ClientSecretUtils.ActivityType.REQUEST_OBJ_DECRYPTION);
                    }
                    catch (InvalidJwtException e) {
                        String message = "UserInfo endpoint " + userInfoEndpoint + " returned an invalid JWT.";
                        log.error((Object)e.getMessage());
                        throw new InvalidSsoResponseException(message);
                    }
                    claims.putAll(jwtClaims.getClaimsMap());
                } else {
                    String message;
                    Map userInfo;
                    log.debug((Object)("Processing JSON response from UserInfo endpoint " + userInfoEndpoint));
                    try {
                        userInfo = (Map)OBJECT_MAPPER.readValue(responseString, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    }
                    catch (JsonProcessingException e) {
                        message = "UserInfo endpoint " + userInfoEndpoint + " returned an invalid JSON response." + (String)(e.getMessage() != null ? " " + e.getMessage() : "");
                        log.error((Object)message);
                        throw new InvalidSsoResponseException(message);
                    }
                    Object userInfoSubject = userInfo.get("sub");
                    if (userInfoSubject == null) {
                        message = "User info from " + userInfoEndpoint + " does not contain subject: " + userInfo;
                        log.error((Object)message);
                        throw new InvalidSsoResponseException(message);
                    }
                    if (!subject.equals(userInfoSubject)) {
                        message = "User info subject (" + LogGuard.encode(userInfoSubject.toString()) + ") does not match ID token subject (" + LogGuard.encode(subject) + ").User info retrieved from " + userInfoEndpoint;
                        log.error((Object)message);
                        throw new InvalidSsoResponseException(message);
                    }
                    claims.putAll(userInfo);
                }
            }
        }
        AttributeMap assertionAttributes = new AttributeMap();
        for (Map.Entry entry : claims.entrySet()) {
            Object value = entry.getValue();
            AttributeValue av = value instanceof Collection ? AttrValueSupport.make((Collection)((Collection)value)) : AttrValueSupport.make(value);
            assertionAttributes.put((String)entry.getKey(), av);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_ASSERTION_ATTRIBUTES, assertionAttributes);
        this.resume(respMsgCtx, reqMsgCtx, req, resp, params);
    }

    @Override
    protected void handleException(InvalidResponseException e, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.ssoRespSupport.isResumeFromException(e, reqMsgCtx, req, resp)) {
            this.ssoRespSupport.handleException(e, respMsgCtx, reqMsgCtx, req, resp);
        }
    }

    @Override
    public void mainProcessTemplate(OutMessageContext reqMstCtx, InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, InvalidResponseException, RenderPageException {
        this.checkStatus(req, inMsgCtx);
        this.doProcess(inMsgCtx, reqMstCtx, req, resp);
    }

    @Override
    protected void doResume(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, GeneralAdapterException, GeneralServiceException {
        AttributeValue jtiAttributeValue;
        IdpConnHashableAuthnBean idpConnBean;
        String partnerEntityId = respMsgCtx.getEntityId();
        AttributeMap assertionAttributes = (AttributeMap)params.get(KEY_ASSERTION_ATTRIBUTES);
        IdpConnection idpConnection = MetadataSupport.getIdpConnection(partnerEntityId);
        IdpIdCookieSupport.writeIdpIdCookie(resp, partnerEntityId);
        TargetSessionId targetId = this.ssoRespSupport.getTargetSessionIdFromCtx(reqMsgCtx, idpConnection);
        String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)respMsgCtx, idpConnection).getVirtualEntityId(DomainMode.RUNTIME);
        SpAuditLogger.setVirtualServerId(virtualServerId);
        String targetUrl = this.ssoRespSupport.getTargetUri(reqMsgCtx, respMsgCtx);
        SsoContext tempSsoContext = new SsoContext(null, null, null, partnerEntityId, targetUrl);
        if (targetId == null) {
            targetId = this.ssoRespSupport.getTargetSessionId(null, targetUrl, idpConnection, virtualServerId);
        }
        if (targetId == null) {
            this.ssoRespSupport.finishAndRedirect(req, resp, respMsgCtx.getTargetResource(), partnerEntityId, true);
            return;
        }
        SpAuditLogger.setTargetSessionId(targetId);
        Set<String> maskedAttributeNames = idpConnection.getMaskedAttributeNames();
        maskedAttributeNames.addAll(this.getDefaultMaskedAttributes());
        AttrValueSupport.checkSetMasked((Map)assertionAttributes, maskedAttributeNames);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Incoming Assertion Attributes: " + assertionAttributes));
        }
        List<String> authnAuthorities = SpAdapterSupportBase.retrieveAuthenticatingAuthorities(idpConnection, null, null, false);
        AttributeValue authnCtxAttributeValue = (AttributeValue)assertionAttributes.get((Object)"acr");
        if (authnCtxAttributeValue != null) {
            AuthenticationContextUtil.performRemoteToLocalMapping(idpConnection, assertionAttributes, authnCtxAttributeValue, "acr");
        }
        NameIDType nameId = NameIDType.Factory.newInstance();
        nameId.setStringValue(String.valueOf(assertionAttributes.get((Object)"sub")));
        AttributeValue issuerAttr = (AttributeValue)assertionAttributes.get((Object)"iss");
        String issuer = issuerAttr != null ? issuerAttr.getValue() : null;
        AttributeValue subjectAttr = (AttributeValue)assertionAttributes.get((Object)"sub");
        String subject = subjectAttr != null ? subjectAttr.getValue() : null;
        AttributeValue sidAttr = (AttributeValue)assertionAttributes.get((Object)"sid");
        String sid = sidAttr != null ? sidAttr.getValue() : null;
        String idTokenToStore = null;
        if (idpConnection.getOidcSettings().isTrackUserSessionsForLogout() && idpConnection.getOidcSettings().getLogoutEndpoint() != null) {
            idTokenToStore = respMsgCtx.getParam("id_token");
        }
        if ((idpConnBean = new IdpConnHashableAuthnBean(assertionAttributes, StateMgmtFactory.getLocalSessionId(req, resp), new IdpConnAuthnSourceKey(idpConnection.getId()), partnerEntityId, this.ssoRespSupport.getRequestedUserIdFromCtx(reqMsgCtx), virtualServerId, authnAuthorities, issuer, subject, sid, idTokenToStore, DeviceSharingType.UNSPECIFIED)).getAssertionAttrs() != null) {
            SpAuditLogger.setAttributes(idpConnBean.getAssertionAttrs().toString());
        }
        if ((jtiAttributeValue = (AttributeValue)assertionAttributes.get((Object)"jti")) != null) {
            AuditLogger.setIdTokenJti(jtiAttributeValue.toString());
        }
        if (this.ssoRespSupport.accountLinking(idpConnection, virtualServerId, idpConnBean.getAssertionAttrs(), respMsgCtx, params, targetId, targetUrl, req, resp, reqMsgCtx, this)) {
            return;
        }
        if (idpConnection.getUserProvisioning() != null) {
            this.provisioningProcessor.process(req, resp, idpConnection, idpConnBean.getAssertionAttrs());
        }
        SpAuditLogger.setUserName(assertionAttributes.getSingleValue("sub"));
        try {
            IdpSessionRegistrySupport.checkRegisterAuthnBean(req, resp, this.ssoRespSupport.getOriginalStateParams(reqMsgCtx, params), idpConnBean, null, true, false);
        }
        catch (SessionQuotaException e) {
            throw new GeneralServiceException("Session limit exceeded.");
        }
        if (!StringUtils.isBlank((String)tempSsoContext.getTargetResourceUrl()) && idpConnBean.getAssertionAttrs().get((Object)"TargetResource") == null) {
            idpConnBean.getAssertionAttrs().put("TargetResource", tempSsoContext.getTargetResourceUrl());
        }
        String authnCtx = this.ssoRespSupport.getAuthnCtx(idpConnBean);
        AttributeMap contextAttributes = this.ssoRespSupport.makeIdpConnContextAttributes(idpConnBean, req);
        if (this.ssoRespSupport.isResumeOtherHandler(reqMsgCtx, req, resp, idpConnBean, contextAttributes)) {
            return;
        }
        AttributeMap mappedAttributes = this.ssoRespSupport.executeIdpConnMapping(idpConnection, idpConnBean.getAssertionAttrs(), targetId, contextAttributes);
        Date authnInst = assertionAttributes.get((Object)"auth_time") != null ? new DateTime(Long.parseLong(((AttributeValue)assertionAttributes.get((Object)"auth_time")).getValue()) * 1000L).toDate() : new Date();
        SsoContext ssoContext = new SsoContext(mappedAttributes, null, null, partnerEntityId, targetUrl, authnCtx, authnInst);
        String resumePath = this.saveState(req, resp, respMsgCtx, reqMsgCtx, params);
        SpHashableAuthnBean authnBean = this.spAdapterSupport.createAuthN(ssoContext, req, resp, targetId, resumePath, reqMsgCtx, respMsgCtx, idpConnBean);
        if (SpAdapterSupportBase.isCreateAuthnComplete(req, resp)) {
            if (this.sloSupport.checkRegisterSpAuthnBean(idpConnection, targetId)) {
                SpSessionRegistrySupport.registerSessionReceived(authnBean, idpConnBean);
            }
            this.ssoRespSupport.finishAndRedirect(req, resp, ssoContext, false);
        }
    }

    public Collection<String> getDefaultMaskedAttributes() {
        return Arrays.asList("access_token", "id_token");
    }

    private void checkStatus(HttpServletRequest request, InMessageContext inMsgCtx) throws InvalidOidcResponseException {
        String error = request.getParameter("error");
        if (StringUtils.isNotEmpty((String)error)) {
            String errorDesc = request.getParameter("error_description");
            String errorMsg = this.getExceptionErrorMessage(error, errorDesc);
            throw new InvalidOidcResponseException(errorMsg);
        }
        error = inMsgCtx.getParam("error");
        if (StringUtils.isNotEmpty((String)error)) {
            String errorDesc = inMsgCtx.getParam("error_description");
            String errorMsg = this.getExceptionErrorMessage(error, errorDesc);
            throw new InvalidOidcResponseException(errorMsg);
        }
    }

    private String getExceptionErrorMessage(String error, String errorDesc) {
        String errorMsg = "The OAuth auth server has returned an error for the auth request - " + error;
        if (StringUtils.isNotBlank((String)errorDesc)) {
            errorMsg = errorMsg + " - " + errorDesc;
        }
        return errorMsg;
    }
}

