/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.profiles.sp;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigurationException;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.SessionIdUtil;
import org.sourceid.websso.wrapper.InMessageContext;

public class OIDCRequestParamHandler {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final List<OIDCRequestParamSetting> reqParamsWhiteList;

    public OIDCRequestParamHandler(List<OIDCRequestParamSetting> reqParamsWhiteList) {
        this.reqParamsWhiteList = reqParamsWhiteList;
    }

    HashMap<String, AttributeMap> getAttributeMappingSubstitutions(HttpServletRequest req, HttpServletResponse resp, Map<String, Collection<String>> trackedParams) {
        InMessageContext inMessageContext = (InMessageContext)req.getAttribute("FEDHUB_IN_REQ_CONTEXT");
        HashMap<String, AttributeMap> sourceAttrs = new HashMap<String, AttributeMap>();
        this.populateContextSourceAttributeMap(req, resp, inMessageContext, sourceAttrs);
        AuthnPolicyUtil.addTrackedParamsToAttributeMappingSource(trackedParams, sourceAttrs);
        return sourceAttrs;
    }

    private void populateAdditionalContextExpressionAttributes(HttpServletRequest req, InMessageContext inMsgCtx, AttributeMap contextAttributes) {
        XmlObject authnReq;
        this.populateRequestObjClaimsAttributeMap(inMsgCtx, contextAttributes);
        Map<String, Object> chainedAttributes = MessageCustomization.getChainedAttributesToContext(req);
        if (chainedAttributes != null && !chainedAttributes.isEmpty()) {
            contextAttributes.put(SourceContextType.CHAINED_ATTRIBUTES.getId(), AttrValueSupport.make(chainedAttributes));
        }
        if ((authnReq = MessageCustomization.getSpConnectionIncomingRequestMessage(req, new HashMap<String, Object>())) != null) {
            contextAttributes.put(SourceContextType.SAML_AUTHN_REQUEST.getId(), AttrValueSupport.make((Object)authnReq));
        }
    }

    private void populateContextSourceAttributeMap(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMessageContext, HashMap<String, AttributeMap> sourceAttrs) {
        AttributeMap contextSourceAttrs = new AttributeMap();
        contextSourceAttrs.put(SourceContextType.CLIENT_IP.getId(), req.getRemoteAddr());
        contextSourceAttrs.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
        if (this.isSriContextConfigured()) {
            contextSourceAttrs.put(SourceContextType.SRI.getId(), SessionIdUtil.getInstance().getExtendedSriV2(req, resp, null));
        }
        if (inMessageContext != null) {
            String spEntityId;
            String authorizationDetails;
            String clientId = null;
            Client client = null;
            if ("oauth:authz".equals(inMessageContext.getBinding()) && StringUtils.isNotEmpty((String)inMessageContext.getEntityId())) {
                clientId = inMessageContext.getEntityId();
                client = MgmtFactory.getClientManager().getCachedClient(clientId);
                if (client != null) {
                    contextSourceAttrs.put(SourceContextType.OAUTH_CLIENT.getId(), clientId);
                }
            }
            this.populateExtendedProperties(inMessageContext, contextSourceAttrs, client);
            String scope = inMessageContext.getParam(Parameters.SCOPE);
            if (scope != null) {
                contextSourceAttrs.put(SourceContextType.OAUTH_SCOPES.getId(), AttrValueSupport.make((Object)scope));
            }
            if ((authorizationDetails = inMessageContext.getParam("authorization_details")) != null) {
                AuthorizationDetails details = AuthorizationDetailsUtil.getAuthorizationDetails(authorizationDetails);
                try {
                    AuthorizationDetailsUtil.enrich(details, req, clientId, Scope.getScope((String)scope));
                }
                catch (AuthorizationRequestException e) {
                    throw new ProcessRuntimeException(e.getMessage(), e);
                }
                contextSourceAttrs.put(SourceContextType.OAUTH_AUTHORIZATION_DETAILS.getId(), details.toJson());
            }
            if ((spEntityId = MessageCustomization.getFedhubSpConnectionEntityId(inMessageContext)) != null) {
                contextSourceAttrs.put(SourceContextType.SP_CONN_ENTITY_ID.getId(), spEntityId);
            }
            this.populateAdditionalContextExpressionAttributes(req, inMessageContext, contextSourceAttrs);
        }
        sourceAttrs.put("context", contextSourceAttrs);
    }

    private boolean isSriContextConfigured() {
        return this.reqParamsWhiteList.stream().anyMatch(param -> param.getValue().getValue().equals(SourceContextType.SRI.getId()));
    }

    private void populateExtendedProperties(InMessageContext inMessageContext, AttributeMap contextSourceAttrs, Client client) {
        if (client != null) {
            HandlerUtil.addExtPropertiesToAttrMap(client.getExtendedParams(), contextSourceAttrs);
        } else {
            String spConnEntityId = inMessageContext.getEntityId();
            try {
                SpConnection spConn = MetadataSupport.getSpConnection(spConnEntityId);
                if (spConn != null) {
                    HandlerUtil.addExtPropertiesToAttrMap(spConn.getExtendedProperties(), contextSourceAttrs);
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
    }

    private void populateRequestObjClaimsAttributeMap(InMessageContext inMsgCtx, AttributeMap additionalContextExpressionAttributes) {
        Map reqObjectMap;
        if (inMsgCtx != null && inMsgCtx.getParam("request") != null && (reqObjectMap = inMsgCtx.getParam("request", Map.class)) != null && !reqObjectMap.isEmpty()) {
            additionalContextExpressionAttributes.put(SourceContextType.SIGNED_REQUEST_OBJECT_CLAIMS.getId(), AttrValueSupport.make((Object)reqObjectMap));
        }
    }
}

