/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.profiles.sp;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestCreatorBase;
import org.sourceid.websso.profiles.sp.CreateSsoRequest;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.wrapper.OutMessageContext;

public class OidcThirdPartyLoginRequestCreator
extends RequestCreatorBase {
    @Override
    public OutMessageContext doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OutMessageContext ctx = new OutMessageContext(Role.IDP);
        String issuer = req.getParameter("iss");
        if (issuer != null) {
            if (!ValidationUtil.isValidHttpsUrl(issuer)) {
                throw new ProcessRuntimeException("'iss' must be a valid https url.");
            }
            IdpConnection idpConn = this.metadataDirectory.getIdpConnection(issuer, false);
            if (idpConn == null) {
                throw new ProcessRuntimeException("There is no IdP connection found for the issuer " + issuer);
            }
            if (idpConn.getOidcSettings() == null) {
                throw new ProcessRuntimeException("The IdP connection " + idpConn.getEntityId() + " does not have OIDC enabled.");
            }
            ctx.setEntityId(issuer);
            if (req.getParameter("target_link_uri") != null) {
                ctx.setTargetResource(req.getParameter("target_link_uri"));
            }
            if (req.getParameter("login_hint") != null) {
                ctx.setRequestedUserId(req.getParameter("login_hint"));
            }
            ctx.setBinding("oauth:authz");
            CreateSsoRequest ssoReqCreator = this.localMetaData.getProfileProcessFactory().getSsoRequestCreator();
            return ssoReqCreator.completeBasicSsoReqCtx(req, resp, idpConn, ctx, CreateSsoRequest.getAuthnPolicy(req));
        }
        AuditLogger.setStatus("failure");
        SpAuditLogger.setEvent("SSO");
        String msg = "'iss' is a required parameter.";
        AuditLogger.setDescription(msg);
        SpAuditLogger.log(msg);
        throw new ProcessRuntimeException(msg);
    }
}

