/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.util;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.SimpleJwkFilter;
import org.jose4j.keys.AesKey;
import org.jose4j.lang.JoseException;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.token.jwt.JWTKeyDerivationUtil;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class EncryptionUtil {
    public static byte[] leftTruncatedSecret(byte[] secretAsUtf8Bytes, int keySize) {
        MessageDigest messageDigest = EncryptionUtil.chooseHashAlgorithmForSymmetricKey(keySize);
        byte[] hash = messageDigest.digest(secretAsUtf8Bytes);
        byte[] truncatedLength = new byte[keySize / 8];
        System.arraycopy(hash, 0, truncatedLength, 0, truncatedLength.length);
        return truncatedLength;
    }

    public static MessageDigest chooseHashAlgorithmForSymmetricKey(int keySize) {
        String digestAlg = null;
        if (keySize <= 256) {
            digestAlg = HashAlgorithm.SHA256.getJceName();
        } else if (keySize > 256 && keySize <= 384) {
            digestAlg = HashAlgorithm.SHA384.getJceName();
        } else if (keySize > 384 && keySize <= 512) {
            digestAlg = HashAlgorithm.SHA512.getJceName();
        }
        if (digestAlg != null) {
            try {
                return MessageDigest.getInstance(digestAlg);
            }
            catch (NoSuchAlgorithmException e) {
                String msg = "No MessageDigest found/known for " + digestAlg + " with keySize " + keySize;
                throw new ProcessRuntimeException(msg, e);
            }
        }
        String msg = "No MessageDigest found/known for keySize " + keySize;
        throw new ProcessRuntimeException(msg);
    }

    public static Key getSymmetricEncryptionKey(String idTokenEncryptionAlgorithm, String idTokenContentEncryptionAlgorithm, byte[] secretAsUtf8Bytes) {
        int keySize = "dir".equals(idTokenEncryptionAlgorithm) ? JWTKeyDerivationUtil.getKeySize(idTokenContentEncryptionAlgorithm) : JWTKeyDerivationUtil.getSymmetricEncryptionAlgKeySize(idTokenEncryptionAlgorithm);
        byte[] encryptionKey = EncryptionUtil.leftTruncatedSecret(secretAsUtf8Bytes, keySize);
        return new AesKey(encryptionKey);
    }

    public static PublicJsonWebKey filterAsymmetricEncryptionKey(JsonWebEncryption jwe, List<JsonWebKey> jsonWebKeys, String location) throws JoseException {
        SimpleJwkFilter filter = new SimpleJwkFilter();
        filter.setKty(jwe.getAlgorithm().getKeyType());
        filter.setUse("enc", false);
        filter.setAlg(jwe.getAlgorithmHeaderValue(), false);
        List filtered = filter.filter(jsonWebKeys);
        if (filtered.isEmpty()) {
            filter.setAlg(jwe.getAlgorithmHeaderValue(), true);
            filtered = filter.filter(jsonWebKeys);
            if (filtered.isEmpty()) {
                filter.setUse("enc", true);
                filtered = filter.filter(jsonWebKeys);
            }
        }
        if (filtered.isEmpty()) {
            StringBuilder sb = new StringBuilder("Unable to find suitable encryption key for " + jwe.getAlgorithmHeaderValue() + " in JWKs from ");
            if (location != null) {
                sb.append(location).append(" ");
            }
            sb.append(jsonWebKeys);
            throw new JoseException(sb.toString());
        }
        return (PublicJsonWebKey)filtered.iterator().next();
    }
}

