/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.util;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.monitoring.metrics.TimerScope;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManagerInterface;

public class HttpConnectionPoolingManager
implements HttpConnectionPoolingManagerInterface,
ServiceInformation {
    private final Map<String, Client> clients = new ConcurrentHashMap<String, Client>();
    private static final String DEFAULT_CLIENT_KEY = "HTTP_CONNECTION_POOLING_MANAGER_DEFAULT_CLIENT";
    private static final String DEFAULT_CLIENT_NO_HOSTNAME_VERIFICATION_KEY = "HTTP_CONNECTION_POOLING_MANAGER_DEFAULT_CLIENT_NO_HOSTNAME_VERIFICATION";
    private static final String CONNECT_TIMEOUT = "connection-timeout";
    private static final String REQUEST_TIMEOUT = "request-timeout";
    private static final String MAX_CONNECTIONS = "max-connections";
    private static final String MAX_DEFAULT_CONNECTIONS_PER_ROUTE = "max-connections-per-route";
    private static final String CONN_IDLE_TIMEOUT = "connection-idle-timeout";
    private static final String DEFAULT_KEEP_ALIVE_TIMEOUT = "keepalive-timeout";
    private static final String CLEANUP_DELAY_SECS = "cleanup-delay-secs";
    private static final String APPLICATION_JSON = "application/json";
    private static final Log log = LogFactory.getLog(HttpConnectionPoolingManager.class);
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig("http-connection-pooling-manager");
    private static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private static final HttpConnectionPoolingManager instance = new HttpConnectionPoolingManager();

    private HttpConnectionPoolingManager() {
        this.clients.put(DEFAULT_CLIENT_KEY, this.createHttpConnectionPoolingManagerClient(true, null, 0, 0));
        this.clients.put(DEFAULT_CLIENT_NO_HOSTNAME_VERIFICATION_KEY, this.createHttpConnectionPoolingManagerClient(false, null, 0, 0));
        executorService.scheduleWithFixedDelay(new IdleConnectionCleanupTask(this.clients), 5L, 5L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info((Object)"Shutting down all HttpConnectionPoolingManager clients");
            for (Client client : this.clients.values()) {
                this.clearClient(client);
            }
            log.info((Object)"HttpConnectionPoolingManager clients shut down");
        }));
    }

    public static HttpConnectionPoolingManager getInstance() {
        return instance;
    }

    public CloseableHttpClient getDefaultClient() {
        return this.clients.get(DEFAULT_CLIENT_KEY);
    }

    public CloseableHttpClient getDefaultClientWithoutHostnameVerification() {
        return this.clients.get(DEFAULT_CLIENT_NO_HOSTNAME_VERIFICATION_KEY);
    }

    public CloseableHttpClient getClient(String key, boolean useHostnameVerification, SSLSocketFactory sslSocketFactory, int maxConnectionsOverride, int maxConnectionsPerRouteOverride) {
        Client client = this.clients.get(key);
        if (client != null) {
            log.debug((Object)("Reusing existing client with key: " + key));
            return client;
        }
        client = this.createHttpConnectionPoolingManagerClient(useHostnameVerification, sslSocketFactory, maxConnectionsOverride, maxConnectionsPerRouteOverride);
        this.clients.put(key, client);
        return client;
    }

    public CloseableHttpClient createClient(boolean useHostnameVerification, SSLSocketFactory sslSocketFactory, int maxConnectionsOverride, int maxConnectionsPerRouteOverride) {
        return this.createHttpConnectionPoolingManagerClient(useHostnameVerification, sslSocketFactory, maxConnectionsOverride, maxConnectionsPerRouteOverride);
    }

    private Client createHttpConnectionPoolingManagerClient(boolean useHostnameVerification, SSLSocketFactory sslSocketFactory, int maxConnectionsOverride, int maxConnectionsPerRouteOverride) {
        int defaultKeepAlive = configStore.getIntValue(DEFAULT_KEEP_ALIVE_TIMEOUT, 1000);
        ConnectionKeepAliveStrategy keepAliveStrategy = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return defaultKeepAlive;
        };
        try {
            SSLConnectionSocketFactory socketFactory;
            if (sslSocketFactory != null) {
                socketFactory = useHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, SSLConnectionSocketFactory.getDefaultHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            } else {
                TrustManager[] trustMgrArray = new TrustManager[]{PingSslClientTrustManager.getInstance()};
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustMgrArray, SecurityProviderUtil.getSecureRandom());
                socketFactory = useHostnameVerification ? new SSLConnectionSocketFactory(sslContext) : new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)socketFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
            int defaultConnectTimeout = configStore.getIntValue(CONNECT_TIMEOUT, 60000);
            int defaultRequestTimeout = configStore.getIntValue(REQUEST_TIMEOUT, 120000);
            PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connMgr.setMaxTotal(maxConnectionsOverride > 0 ? maxConnectionsOverride : configStore.getIntValue(MAX_CONNECTIONS, 350));
            connMgr.setDefaultMaxPerRoute(maxConnectionsPerRouteOverride > 0 ? maxConnectionsPerRouteOverride : configStore.getIntValue(MAX_DEFAULT_CONNECTIONS_PER_ROUTE, 100));
            log.info((Object)("max-connections " + connMgr.getMaxTotal()));
            log.info((Object)("max-connections-per-route " + connMgr.getDefaultMaxPerRoute()));
            log.info((Object)("keepalive-timeout " + defaultKeepAlive));
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectionRequestTimeout(defaultRequestTimeout).setConnectTimeout(defaultConnectTimeout).setCookieSpec("ignoreCookies").build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().disableCookieManagement().useSystemProperties().setUserAgent("PingFederate").setConnectionManager((HttpClientConnectionManager)connMgr).setKeepAliveStrategy(keepAliveStrategy).setDefaultRequestConfig(defaultRequestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
            return new Client(httpClient, connMgr);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected error creating HTTP client", e);
        }
    }

    @Override
    public CloseableHttpResponse doRequestWithResponse(HttpRequestBase request) throws IOException {
        return this.doRequestWithResponse(request, true);
    }

    public CloseableHttpResponse doRequestWithResponse(HttpRequestBase request, boolean useHostnameVerification) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        Client client = useHostnameVerification ? this.clients.get(DEFAULT_CLIENT_KEY) : this.clients.get(DEFAULT_CLIENT_NO_HOSTNAME_VERIFICATION_KEY);
        return client.execute((HttpUriRequest)request, (HttpContext)HttpClientContext.create());
    }

    @Override
    public String doRequest(HttpRequestBase request) throws IOException {
        return this.doRequest(request, true);
    }

    public String doRequest(HttpRequestBase request, boolean useHostnameVerification) throws IOException {
        request.addHeader("Accept", APPLICATION_JSON);
        Client client = useHostnameVerification ? this.clients.get(DEFAULT_CLIENT_KEY) : this.clients.get(DEFAULT_CLIENT_NO_HOSTNAME_VERIFICATION_KEY);
        CloseableHttpResponse response = client.execute((HttpUriRequest)request, (HttpContext)HttpClientContext.create());
        int statusCode = response.getStatusLine().getStatusCode();
        if (200 == statusCode || 201 == statusCode) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                return EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            }
        } else {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            throw new IOException(statusCode + " - " + response.getStatusLine().getReasonPhrase());
        }
        return "";
    }

    public void removeClient(String key) {
        Client clientToRemove = this.clients.remove(key);
        if (clientToRemove != null) {
            log.info((Object)("removing client with key '" + key + "' from cache"));
            this.clearClient(clientToRemove);
        } else {
            log.info((Object)("could not remove client from cache because client with key '" + key + "' was not found or the key is not associated with a REST API data store"));
        }
    }

    public void delayedClear() {
        log.info((Object)"Clearing HttpConnectionPoolingManager cache");
        List<Client> removedClients = this.removeClients();
        executorService.schedule(() -> {
            int clientsToCleanup = removedClients.size();
            if (clientsToCleanup > 0) {
                log.debug((Object)("Cleaning up " + clientsToCleanup + " HTTP clients"));
            }
            removedClients.forEach(this::clearClient);
        }, (long)configStore.getIntValue(CLEANUP_DELAY_SECS, 10), TimeUnit.SECONDS);
    }

    private List<Client> removeClients() {
        HashSet keysToRemove = new HashSet(this.clients.keySet().stream().filter(key -> !key.equals(DEFAULT_CLIENT_KEY) && !key.equals(DEFAULT_CLIENT_NO_HOSTNAME_VERIFICATION_KEY)).collect(Collectors.toSet()));
        ArrayList<Client> removedClients = new ArrayList<Client>();
        for (String key2 : keysToRemove) {
            Client client = this.clients.remove(key2);
            if (client == null) continue;
            removedClients.add(client);
        }
        return removedClients;
    }

    private void clearClient(Client client) {
        try {
            PoolingHttpClientConnectionManager connMgr;
            CloseableHttpClient httpClient = client.getHttpClient();
            if (httpClient != null) {
                httpClient.close();
            }
            if ((connMgr = client.getConnMgr()) != null) {
                connMgr.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"could not close httpClient");
        }
    }

    public String getServiceName() {
        return "http-request";
    }

    private static class IdleConnectionCleanupTask
    implements Runnable {
        Map<String, Client> clients;

        private IdleConnectionCleanupTask(Map<String, Client> clients) {
            this.clients = clients;
        }

        @Override
        public void run() {
            long idleTimeout = configStore.getLongValue(HttpConnectionPoolingManager.CONN_IDLE_TIMEOUT, 30000L);
            for (Client client : this.clients.values()) {
                client.getConnMgr().closeExpiredConnections();
                client.getConnMgr().closeIdleConnections(idleTimeout, TimeUnit.MILLISECONDS);
            }
        }
    }

    private static class Client
    extends CloseableHttpClient {
        private final CloseableHttpClient httpClient;
        private final PoolingHttpClientConnectionManager connMgr;

        public Client(CloseableHttpClient client, PoolingHttpClientConnectionManager connMgr) {
            this.httpClient = client;
            this.connMgr = connMgr;
        }

        public PoolingHttpClientConnectionManager getConnMgr() {
            return this.connMgr;
        }

        public CloseableHttpClient getHttpClient() {
            return this.httpClient;
        }

        public HttpParams getParams() {
            return this.httpClient.getParams();
        }

        public ClientConnectionManager getConnectionManager() {
            return this.httpClient.getConnectionManager();
        }

        public CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
            try (TimerScope ignored = TimerScope.getTimerScopeForService("http-request", "host", request.getURI().getHost());){
                CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(request);
                return closeableHttpResponse;
            }
        }

        public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
            try (TimerScope ignored = TimerScope.getTimerScopeForService("http-request", "host", request.getURI().getHost());){
                CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(request, context);
                return closeableHttpResponse;
            }
        }

        public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
            try (TimerScope ignored = TimerScope.getTimerScopeForService("http-request", "host", target.getHostName());){
                CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(target, request);
                return closeableHttpResponse;
            }
        }

        protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
            try (TimerScope ignored = TimerScope.getTimerScopeForService("http-request", "host", target.getHostName());){
                CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(target, request, context);
                return closeableHttpResponse;
            }
        }

        public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
            try (TimerScope ignored = TimerScope.getTimerScopeForService("http-request", "host", target.getHostName());){
                CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(target, request, context);
                return closeableHttpResponse;
            }
        }

        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
            try (TimerScope ignored = TimerScope.getTimerScopeForService("http-request", "host", request.getURI().getHost());){
                Object object = this.httpClient.execute(request, responseHandler);
                return (T)object;
            }
        }

        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
            try (TimerScope ignored = TimerScope.getTimerScopeForService("http-request", "host", request.getURI().getHost());){
                Object object = this.httpClient.execute(request, responseHandler, context);
                return (T)object;
            }
        }

        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
            try (TimerScope ignored = TimerScope.getTimerScopeForService("http-request", "host", target.getHostName());){
                Object object = this.httpClient.execute(target, request, responseHandler);
                return (T)object;
            }
        }

        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
            try (TimerScope ignored = TimerScope.getTimerScopeForService("http-request", "host", target.getHostName());){
                Object object = this.httpClient.execute(target, request, responseHandler, context);
                return (T)object;
            }
        }

        public void close() throws IOException {
            this.httpClient.close();
        }
    }
}

