/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.util;

import java.util.Collections;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.util.BaseUrlUtil;

public class OIDCUtil {
    private static MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();

    private OIDCUtil() {
    }

    public static String getRedirectUri(String entityId) {
        return localMetaData.getBaseUrl() + localMetaData.getPathUtil().encodeParamMap("/sp/cb.openid", Collections.singletonMap("iss", entityId));
    }

    public static String getBackChannelLogoutUri(String entityId) {
        return localMetaData.getBaseUrl() + localMetaData.getPathUtil().encodeParamMap("/sp/bc-logout.openid", Collections.singletonMap("iss", entityId));
    }

    public static String getFrontChannelLogoutUri(String entityId) {
        return localMetaData.getBaseUrl() + localMetaData.getPathUtil().encodeParamMap("/sp/fc-logout.openid", Collections.singletonMap("iss", entityId));
    }

    public static String getPostLogoutRedirectUri() {
        return localMetaData.getBaseUrl() + "/sp/post-logout.openid";
    }

    public static String getNonceSessionKey(String nonce) {
        return "nonce_" + nonce;
    }

    public static String getRuntimeRedirectUri(String entityId) {
        String redirectUri = OIDCUtil.getRedirectUri(entityId);
        return BaseUrlUtil.getCurrentBaseUrl(redirectUri);
    }
}

