/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.bindings;

import com.pingidentity.common.util.ByteArrayHashKey;
import com.pingidentity.common.util.xml.XmlIDUtil;
import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Artifact;
import org.sourceid.common.Util;
import org.sourceid.protocol.samlp11.xml.RequestDocument;
import org.sourceid.protocol.samlp11.xml.RequestType;
import org.sourceid.protocol.samlp11.xml.ResponseDocument;
import org.sourceid.protocol.samlp11.xml.ResponseType;
import org.sourceid.saml1x.bindings.ArtifactV1;
import org.sourceid.saml1x.bindings.BaseBrowserBinding;
import org.sourceid.saml1x.protocol.VersionSupport;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.bindings.ArtifactSupport;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class BrowserArtifact
extends BaseBrowserBinding {
    private final ArtifactPersistenceService artifactPersistenceSvc = StateMgmtFactory.getArtifactPersistenceService();
    private final ArtifactSupport artifactSupport = new ArtifactSupport();

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException {
        ArtifactPersistenceService.Handle handle;
        String entityId = msgCtx.getEntityId();
        SpConnection sp = this.metadataDirectory.getSpConnectionMetadata(entityId);
        XmlObject xml = msgCtx.getXmlObject();
        Role roleType = sp.getRoleType();
        ArtifactPersistenceService.Message msg = new ArtifactPersistenceService.Message(xml, entityId, roleType);
        msg.setMaskedAttributeNames(msgCtx.getMaskedAttributeNames());
        try {
            handle = this.artifactPersistenceSvc.saveArtifact(msg, sp.getArtifactTimeoutSeconds());
        }
        catch (GeneralServiceException e) {
            throw new BindingException("Unable to save Artifact", e);
        }
        byte[] sourceId = VirtualIdentityUtil.resolve(sp, request).getVirtualSourceId();
        ArtifactV1 artifact = new ArtifactV1(sourceId, handle.getMessageHandle());
        HashMap<String, String> queryParams = new HashMap<String, String>(4);
        String artifactString = artifact.toString();
        TrackingIdSupport.addReference(artifactString);
        msgCtx.setParam("SAMLart", artifactString);
        queryParams.put("SAMLart", artifactString);
        queryParams.put("TARGET", msgCtx.getTargetResource());
        String destination = Util.appendQueryParams(msgCtx.getEndpoint(), queryParams);
        response.sendRedirect(destination);
    }

    @Override
    void completeReceive(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws BindingException, IOException, RedirectException, RenderPageException {
        InMessageContext artRespMsgCtx;
        Object[] artStrings = req.getParameterValues("SAMLart");
        if (artStrings != null) {
            for (Object artStr : artStrings) {
                TrackingIdSupport.addReference((String)artStr);
            }
        } else {
            artStrings = new String[]{};
        }
        inMsgCtx.setParam("SAMLart", artStrings.length == 1 ? artStrings[0] : Arrays.toString(artStrings));
        IdpConnection idp = this.identifyIdp((String[])artStrings);
        inMsgCtx.setEntityId(idp.getEntityId());
        inMsgCtx.setVirtualServerId(VirtualIdentityUtil.resolve(idp, req).getVirtualEntityId(DomainMode.RUNTIME));
        RequestDocument requestDoc = RequestDocument.Factory.newInstance();
        RequestType request = requestDoc.addNewRequest();
        String requestId = XmlIDUtil.createID();
        request.setRequestID(requestId);
        request.setMajorVersion(BigInteger.ONE);
        request.setMinorVersion(VersionSupport.getMinorVersion(idp));
        request.setIssueInstant(Util.getUtcCalendar());
        request.setAssertionArtifactArray((String[])artStrings);
        Endpoint ars = this.getArtifactResolutionSvc(idp);
        OutMessageContext reqMsgCtx = new OutMessageContext(idp.getRoleType());
        reqMsgCtx.setEndpoint(ars.getFullLocation());
        reqMsgCtx.setEntityId(idp.getEntityId());
        reqMsgCtx.setVirtualServerId(VirtualIdentityUtil.getDefaultVirtualIdForRuntime(idp).getVirtualEntityId(DomainMode.RUNTIME));
        reqMsgCtx.setBinding("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        reqMsgCtx.setXmlObject((XmlObject)requestDoc);
        try (TimerScope ignored = Meters.getTimerScope("connection.ars", "connection.id", idp.getEntityId());){
            artRespMsgCtx = this.artifactSupport.resolve(req, resp, reqMsgCtx);
        }
        catch (IOException e) {
            Meters.getCounter("connection.ars.errors", "connection.id", idp.getEntityId()).increment();
            throw e;
        }
        XmlObject xmlObject = artRespMsgCtx.getXmlObject();
        ResponseDocument respDoc = (ResponseDocument)xmlObject;
        ResponseType response = respDoc.getResponse();
        String inResponseTo = response.getInResponseTo();
        if (!requestId.equals(inResponseTo)) {
            throw new BindingException("InResponseTo " + inResponseTo + " does not match original RequestDocument ID of " + requestId);
        }
        int numberAssertions = response.sizeOfAssertionArray();
        int numberArtifacts = artStrings.length;
        if (numberAssertions > 0 && numberAssertions != numberArtifacts) {
            String msg = "In the case where the source site returns assertions within <samlp:Response>, it MUST return exactly one assertion for each SAML artifact found in the corresponding <samlp:Request> element. The case where fewer or greater number of assertions is returned within the <samlp:Response> element MUST be treated as an error state by the destination site.  There were " + numberArtifacts + " artifacts but " + numberAssertions + " assertions.  Artifacts: " + Arrays.toString(artStrings) + " Response: " + respDoc;
            throw new BindingException(msg);
        }
        inMsgCtx.setXmlObject(artRespMsgCtx.getXmlObject());
        inMsgCtx.setSignatureStatus(artRespMsgCtx.getSignatureStatus());
    }

    private Endpoint getArtifactResolutionSvc(IdpConnection idp) throws BindingException {
        IndexedEndpoints artifactResolutionServices = idp.getArtifactResolutionServices();
        Endpoint ars = null;
        if (artifactResolutionServices.hasDefault()) {
            ars = artifactResolutionServices.getDefault();
        } else {
            Map<Integer, Endpoint> endpointsMap = artifactResolutionServices.getEndpointsMap();
            if (!Util.isEmpty(endpointsMap)) {
                ars = endpointsMap.values().iterator().next();
            }
        }
        if (ars == null) {
            throw new BindingException("No artifact resolution endpoint configured for " + idp.getEncodedEntityId());
        }
        return ars;
    }

    private IdpConnection identifyIdp(String[] artifactStrings) throws BindingException {
        if (artifactStrings == null || artifactStrings.length == 0) {
            throw new BindingException("No artifacts found on the request");
        }
        HashSet<ByteArrayHashKey> sourceIds = new HashSet<ByteArrayHashKey>();
        for (String artifactString : artifactStrings) {
            Artifact artifact = ArtifactV1.parse(artifactString);
            byte[] sourceId = artifact.getSourceId();
            ByteArrayHashKey sourceIdHashKey = new ByteArrayHashKey(sourceId);
            sourceIds.add(sourceIdHashKey);
        }
        if (sourceIds.size() > 1) {
            throw new BindingException("All the artifacts MUST have the same SourceID.  But found " + sourceIds);
        }
        ByteArrayHashKey sourceIdHashKey = (ByteArrayHashKey)sourceIds.iterator().next();
        String entityId = this.metadataDirectory.getEntityId(sourceIdHashKey, Protocol.SAML11, Protocol.SAML10);
        return this.metadataDirectory.getIdpConnectionMetadata(entityId);
    }

    @Override
    public String getUri() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01";
    }
}

