/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.bindings;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.Util;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.RelayStateSupport;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.servlet.ServletExceptionSupport;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class DestinationSiteFirstBinding
implements Binding {
    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException {
        RelayStateSupport relayStateSupport = new RelayStateSupport();
        relayStateSupport.associateUsingSessionId(msgCtx, req, resp);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TARGET", msgCtx.getTargetResource());
        String partnerId = VirtualIdentityUtil.resolve(msgCtx).getVirtualEntityId(DomainMode.RUNTIME);
        params.put("PartnerSpId", partnerId);
        String url = Util.appendQueryParams(msgCtx.getEndpoint(), params);
        resp.sendRedirect(url);
        return null;
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException {
        InMessageContext inMsgCtx = new InMessageContext(partnerRole);
        String target = request.getParameter("TARGET");
        inMsgCtx.setTargetResource(target);
        inMsgCtx.setIsRequest(true);
        String partnerSpId = ProprietaryURLParams.getParam(request, "PartnerSpId", "PARTNER");
        inMsgCtx.setEntityId(partnerSpId);
        String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, request).getVirtualEntityId(DomainMode.RUNTIME);
        inMsgCtx.setVirtualServerId(virtualServerId);
        return inMsgCtx;
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException {
        ServletExceptionSupport.throwServletException(e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public String getUri() {
        return "DestinationSiteFirstBinding:simple:http:302";
    }

    @Override
    public boolean isEntityIdRequired() {
        return true;
    }
}

