/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.bindings;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml1x.bindings.BrowserArtifact;
import org.sourceid.saml1x.bindings.BrowserPost;
import org.sourceid.saml1x.bindings.DestinationSiteFirstBinding;
import org.sourceid.saml1x.bindings.Saml1xSoapBinding;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.websso.bindings.ProtocolBindingGroup;

public class Saml1xBindingURIs
extends ProtocolBindingGroup {
    public static final String POST = "urn:oasis:names:tc:SAML:1.0:profiles:browser-post";
    public static final String ARTIFACT = "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01";
    public static final String SOAP = "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding";
    public static final String FAKE = "DestinationSiteFirstBinding:simple:http:302";
    public static final String AUTHN_REQ = "urn:mace:shibboleth:1.0:profiles:AuthnRequest";
    private static final String SAML1_CUSTOM_BINDING = "saml1-bindings";
    private static ConfigStore customBindingsConfigStore = ConfigStoreFarm.getConfig("custom-bindings");
    private static final Set<String> bindingSet = new HashSet<String>();

    public Saml1xBindingURIs() {
        this.bindings = new Binding[]{new BrowserPost(), new BrowserArtifact(), new Saml1xSoapBinding(), new DestinationSiteFirstBinding()};
    }

    @Override
    public String ascertainBindingName(HttpServletRequest req, boolean isPost) throws IOException {
        String binding = !isPost ? (this.hasParam(req, "SAMLart") ? ARTIFACT : FAKE) : (this.hasParam(req, "SAMLResponse") ? POST : SOAP);
        return binding;
    }

    public static Set<String> getBindingSet() {
        return bindingSet;
    }

    static {
        bindingSet.add(SOAP);
        bindingSet.add(POST);
        bindingSet.add(ARTIFACT);
        bindingSet.add(FAKE);
        Map customBindings = customBindingsConfigStore.getMapValue(SAML1_CUSTOM_BINDING, Collections.EMPTY_MAP);
        for (Object key : customBindings.keySet()) {
            bindingSet.add((String)customBindings.get(key));
        }
    }
}

