/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.profiles.ap;

import com.pingidentity.common.util.LogGuard;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Artifact;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.protocol.samlp11.xml.RequestDocument;
import org.sourceid.protocol.samlp11.xml.RequestType;
import org.sourceid.protocol.samlp11.xml.ResponseDocument;
import org.sourceid.protocol.samlp11.xml.ResponseType;
import org.sourceid.protocol.samlp11.xml.StatusType;
import org.sourceid.saml1x.bindings.ArtifactV1;
import org.sourceid.saml1x.profiles.ap.ProfileSupport;
import org.sourceid.saml1x.profiles.ap.Saml1xRespOutMessageContext;
import org.sourceid.saml1x.protocol.StatusCodeException;
import org.sourceid.saml1x.protocol.TopLevelStatusCode;
import org.sourceid.saml1x.protocol.VersionSupport;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.bindings.ArtifactSupport;
import org.sourceid.websso.profiles.RequestHandlerBase;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class HandleRequest
extends RequestHandlerBase {
    private ProfileSupport profileSupport = new ProfileSupport();
    private ArtifactSupport artifactSupport = new ArtifactSupport();
    private static final int ONE = 1;

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        Saml1xRespOutMessageContext outMsgCtx = this.profileSupport.getInitialOutMsgCtx(inMsgCtx);
        ResponseDocument responseDocument = outMsgCtx.getResponseDocument();
        ResponseType response = responseDocument.getResponse();
        XmlObject xmlObject = inMsgCtx.getXmlObject();
        RequestDocument requestDoc = (RequestDocument)xmlObject;
        RequestType request = requestDoc.getRequest();
        response.setInResponseTo(request.getRequestID());
        response.setMinorVersion(request.getMinorVersion());
        return outMsgCtx;
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        XmlObject xmlObject = inMsgCtx.getXmlObject();
        RequestDocument requestDocument = (RequestDocument)xmlObject;
        RequestType requestType = requestDocument.getRequest();
        this.verifySignature(inMsgCtx);
        BigInteger majorVersion = requestType.getMajorVersion();
        BigInteger minorVersion = requestType.getMinorVersion();
        SpConnection sp = this.metadataDirectory.getSpConnectionMetadata(inMsgCtx.getEntityId());
        VersionSupport.validateVersion(sp, majorVersion, minorVersion, "request doc");
        Calendar issueInstant = requestType.getIssueInstant();
        if (issueInstant.getTimeZone().getRawOffset() != 0) {
            throw new StatusCodeException("IssueInstant timezone is not UTC: " + issueInstant, TopLevelStatusCode.REQUESTER);
        }
        if (requestType.sizeOfAssertionArtifactArray() == 1) {
            String artifactString = requestType.getAssertionArtifactArray(0);
            TrackingIdSupport.addReference(artifactString);
            Artifact artifact = ArtifactV1.parse(artifactString);
            byte[] handle = artifact.getMessageHandle();
            XmlObject storedXmlObj = this.artifactSupport.retrieveArtifact(handle, inMsgCtx, outMsgCtx, artifactString, this.log);
            if (storedXmlObj != null) {
                XmlObject xml = outMsgCtx.getXmlObject();
                ResponseDocument responseDocument = (ResponseDocument)xml;
                ResponseType responseType = responseDocument.getResponse();
                ResponseDocument storedRespDoc = (ResponseDocument)storedXmlObj;
                ResponseType storedResponseType = storedRespDoc.getResponse();
                if (storedResponseType.sizeOfAssertionArray() > 0) {
                    responseType.setAssertionArray(storedResponseType.getAssertionArray());
                } else {
                    StatusType storedStatus = storedResponseType.getStatus();
                    responseType.setStatus(storedStatus);
                }
            }
        } else if (requestType.sizeOfAssertionArtifactArray() > 1) {
            StringBuilder msg = new StringBuilder().append("Artifact resolution request from ");
            msg.append(LogGuard.encode(inMsgCtx.getEntityId())).append(" has more than one artifact. ");
            msg.append("This system never sends more than one artifact to be resolved.");
            this.log.warn((Object)msg);
            this.log.debug((Object)("Request: " + requestDocument));
        } else {
            throw new StatusCodeException("Unsuported request: " + requestDocument, TopLevelStatusCode.REQUESTER);
        }
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) {
        this.log.warn((Object)("Writing error response: " + e));
        this.profileSupport.handleEx(e, inMsgCtx, outMsgCtx, req, resp);
    }

    private void verifySignature(InMessageContext inMsgCtx) throws RequestProcessingException {
        SignatureStatus signatureStatus = inMsgCtx.getSignatureStatus();
        if (signatureStatus == SignatureStatus.NOT_PRESENT || signatureStatus == SignatureStatus.UNVERIFIED) {
            if (inMsgCtx.isSignatureRequired()) {
                throw new StatusCodeException("Signature required", TopLevelStatusCode.REQUESTER);
            }
        } else {
            if (signatureStatus == SignatureStatus.INVALID) {
                throw new StatusCodeException("Invalid signature", TopLevelStatusCode.REQUESTER);
            }
            if (signatureStatus != SignatureStatus.VALID) {
                throw new StatusCodeException("Unexpected signature status: " + signatureStatus, TopLevelStatusCode.REQUESTER);
            }
        }
    }

    protected void countTx() {
    }
}

