/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.profiles.rp;

import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.session.quotas.exception.SessionQuotaException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.protocol.samlp11.xml.ResponseDocument;
import org.sourceid.protocol.samlp11.xml.ResponseType;
import org.sourceid.saml1x.protocol.AssertionAssembler;
import org.sourceid.saml1x.protocol.AssertionTypeUtil;
import org.sourceid.saml1x.protocol.ValidateWebSsoResponse;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.profiles.sp.SLOSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupportBase;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.ResumableResponseHandlerBase;
import org.sourceid.websso.profiles.sp.IdpIdCookieSupport;
import org.sourceid.websso.profiles.sp.ProvisioningProcessor;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.profiles.sp.SsoRespSupport;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.XmlMessageLogWrapper;

public class HandleResponse
extends ResumableResponseHandlerBase {
    private static final String KEY_ASSERTIONS = "assertions";
    private static final String KEY_SSO_ASSERTION_IDX = "idx";
    private final SsoRespSupport ssoRespSupport;
    private final ValidateWebSsoResponse validateWebSsoResponse;
    private final AssertionAssembler assembler;
    private final ProvisioningProcessor provisioningProcessor;
    private final SpAdapterSupport spAdapterSupport;
    private final AssertionTypeUtil assertionTypeUtil;
    private final SLOSupport sloSupport;

    public HandleResponse() {
        this.ssoRespSupport = new SsoRespSupport(this.localMetaData);
        this.validateWebSsoResponse = new ValidateWebSsoResponse(this.metadataDirectory, this.localMetaData);
        this.assembler = new AssertionAssembler();
        this.provisioningProcessor = new ProvisioningProcessor();
        this.spAdapterSupport = new SpAdapterSupport();
        this.assertionTypeUtil = new AssertionTypeUtil();
        this.sloSupport = new SLOSupport();
    }

    @Override
    protected void doProcess(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws InvalidResponseException, IOException {
        ValidateWebSsoResponse.ValidAssertions vAssertions = this.validateWebSsoResponse.validate(respMsgCtx);
        List<AssertionType> validAssertions = vAssertions.getValidAssertions();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_ASSERTIONS, validAssertions);
        params.put(KEY_SSO_ASSERTION_IDX, vAssertions.getPrimarySsoIdx());
        this.resume(respMsgCtx, reqMsgCtx, req, resp, params);
    }

    @Override
    protected void doResume(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, GeneralAdapterException, GeneralServiceException {
        if (respMsgCtx != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.IN_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(respMsgCtx).toString());
            ResponseDocument respDoc = (ResponseDocument)respMsgCtx.getXmlObject();
            if (respDoc != null) {
                ResponseType response = respDoc.getResponse();
                ThreadContext.put((String)AuditLogger.MDC_KEY.RESPONSE_ID.toString(), (String)response.getResponseID());
            }
        }
        String partnerEntityId = respMsgCtx.getEntityId();
        SpAuditLogger.setPartnerId(partnerEntityId);
        IdpConnection idp = this.metadataDirectory.getIdpConnectionMetadata(partnerEntityId);
        SpAuditLogger.setProtocol(idp.getProtocol().toString());
        LicenseManager.checkLicenseForConnection(idp);
        SsoContext ssoContext = (SsoContext)params.get("ssoctx");
        SsoContext tempSsoContext = (SsoContext)params.get("tmpssoctx");
        List assertions = (List)params.get(KEY_ASSERTIONS);
        Integer index = (Integer)params.get(KEY_SSO_ASSERTION_IDX);
        AssertionType ssoAssertion = (AssertionType)assertions.get(index);
        IdpIdCookieSupport.writeIdpIdCookie(resp, partnerEntityId);
        TargetSessionId targetId = this.ssoRespSupport.getTargetSessionIdFromCtx(reqMsgCtx, idp);
        String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)respMsgCtx, idp).getVirtualEntityId(DomainMode.RUNTIME);
        SpAuditLogger.setVirtualServerId(virtualServerId);
        if (tempSsoContext == null) {
            String targetUrl = respMsgCtx.getTargetResource();
            targetId = this.ssoRespSupport.getTargetSessionId(targetId, targetUrl, idp, virtualServerId);
            params.put("targetsessionid", targetId);
            tempSsoContext = new SsoContext(null, null, null, partnerEntityId, targetUrl);
            params.put("tmpssoctx", tempSsoContext);
        }
        if (targetId == null) {
            targetId = (TargetSessionId)params.get("targetsessionid");
        }
        if (targetId == null) {
            this.ssoRespSupport.finishAndRedirect(req, resp, respMsgCtx.getTargetResource(), partnerEntityId, true);
            return;
        }
        SpAuditLogger.setTargetSessionId(targetId);
        if (ssoContext == null) {
            IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)params.get("idpConnBean");
            if (idpConnBean == null) {
                AttributeMap assertionAttributes = this.assembler.disassemble(assertions, idp.getMaskedAttributeNames());
                this.log.info((Object)("Incoming Assertion Attributes: " + assertionAttributes));
                IdpConnAuthnSourceKey authnSourceKey = new IdpConnAuthnSourceKey(idp.getId());
                DeviceSharingType deviceSharingType = this.ssoRespSupport.getDeviceSharingTypeFromCtx(reqMsgCtx);
                idpConnBean = new IdpConnHashableAuthnBean(assertionAttributes, StateMgmtFactory.getLocalSessionId(req, resp), (AuthnSourceKey)authnSourceKey, partnerEntityId, this.ssoRespSupport.getRequestedUserIdFromCtx(reqMsgCtx), virtualServerId, null, null, AssertionTypeUtil.getSaml20NameId(ssoAssertion), deviceSharingType);
                params.put("idpConnBean", idpConnBean);
            }
            if (idpConnBean.getAssertionAttrs() != null) {
                SpAuditLogger.setAttributes(idpConnBean.getAssertionAttrs().toString());
            }
            if (this.ssoRespSupport.accountLinking(idp, virtualServerId, idpConnBean.getAssertionAttrs(), respMsgCtx, params, targetId, tempSsoContext.getTargetResourceUrl(), req, resp, reqMsgCtx, this)) {
                return;
            }
            if (idp.getUserProvisioning() != null) {
                this.provisioningProcessor.process(req, resp, idp, idpConnBean.getAssertionAttrs());
            }
            SpAuditLogger.setUserName((Map<String, AttributeValue>)idpConnBean.getAssertionAttrs());
            boolean checkRegisterForSso = !this.assertionTypeUtil.hasDoNotCacheAssertion(assertions);
            try {
                IdpSessionRegistrySupport.checkRegisterAuthnBean(req, resp, this.ssoRespSupport.getOriginalStateParams(reqMsgCtx, params), idpConnBean, null, checkRegisterForSso, false);
            }
            catch (SessionQuotaException e) {
                throw new GeneralServiceException("Session limit exceeded.");
            }
            if (!StringUtils.isBlank((String)respMsgCtx.getTargetResource()) && idpConnBean.getAssertionAttrs().get((Object)"TargetResource") == null) {
                idpConnBean.getAssertionAttrs().put("TargetResource", respMsgCtx.getTargetResource());
            }
            String authnCtx = this.ssoRespSupport.getAuthnCtx(idpConnBean);
            AttributeMap contextAttributes = this.ssoRespSupport.makeIdpConnContextAttributes(idpConnBean, req);
            if (this.ssoRespSupport.isResumeOtherHandler(reqMsgCtx, req, resp, idpConnBean, contextAttributes)) {
                return;
            }
            AttributeMap mappedAttributes = this.ssoRespSupport.executeIdpConnMapping(idp, idpConnBean.getAssertionAttrs(), targetId, contextAttributes);
            String targetUrl = tempSsoContext.getTargetResourceUrl();
            Date authnInst = this.ssoRespSupport.getAuthnInst(idpConnBean.getAssertionAttrs());
            ssoContext = new SsoContext(mappedAttributes, null, SsoRespSupport.EMPTY_ASSERTION20_LIST, partnerEntityId, targetUrl, authnCtx, authnInst);
            params.put("ssoctx", ssoContext);
            params.remove(KEY_ASSERTIONS);
        }
        String resumePath = this.saveState(req, resp, respMsgCtx, reqMsgCtx, params);
        SpHashableAuthnBean authnBean = this.spAdapterSupport.createAuthN(ssoContext, req, resp, targetId, resumePath, reqMsgCtx, respMsgCtx, (IdpConnHashableAuthnBean)params.get("idpConnBean"));
        if (SpAdapterSupportBase.isCreateAuthnComplete(req, resp)) {
            if (this.sloSupport.checkRegisterSpAuthnBean(idp, targetId)) {
                SpSessionRegistrySupport.registerSessionReceived(authnBean, ssoAssertion, partnerEntityId, respMsgCtx.getVirtualServerId());
            }
            this.ssoRespSupport.finishAndRedirect(req, resp, ssoContext, false);
        }
    }

    @Override
    protected void handleException(InvalidResponseException e, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.ssoRespSupport.handleException(e, respMsgCtx, reqMsgCtx, req, resp);
    }

    @Override
    protected void checkIssuer(OutMessageContext reqMsgCtx, InMessageContext respMsgCtx) throws InvalidResponseException {
    }
}

