/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.protocol;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlIDUtil;
import java.math.BigInteger;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.XmlEncryption;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.protocol.dsig10.xml.KeyInfoType;
import org.sourceid.protocol.saml11.xml.AssertionDocument;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.protocol.saml11.xml.AttributeStatementType;
import org.sourceid.protocol.saml11.xml.AttributeType;
import org.sourceid.protocol.saml11.xml.AuthenticationStatementType;
import org.sourceid.protocol.saml11.xml.NameIdentifierType;
import org.sourceid.protocol.saml11.xml.SubjectConfirmationType;
import org.sourceid.protocol.saml11.xml.SubjectType;
import org.sourceid.saml1x.protocol.AssertionTypeUtil;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.util.Defense;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.protocol.AssertionAssemblerUtil;

public class AssertionAssembler {
    Log log = LogFactory.getLog(this.getClass());
    private ConfigStore config = ConfigStoreFarm.getConfig(AssertionAssembler.class);
    private AssertionTypeUtil assertionTypeUtil = new AssertionTypeUtil();

    public AssertionType assemble(Map<String, AttributeValue> attributes, SpConnection sp, String attrNS, String issuer) {
        return this.assemble(attributes, sp, attrNS, issuer, null, null);
    }

    public AssertionType assembleForWSTrust(Map<String, AttributeValue> attributes, int before, int after, String attrNS, String issuer, String audience, boolean includeAudience, String confirmationMethod, Calendar authnInst, String guiDefinedNameIdFormat, Map<String, String> attributeNamespaceMappings) {
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        AssertionType assertion = assertionDoc.addNewAssertion();
        this.assertionTypeUtil.setVersion(BigInteger.ONE, assertion);
        this.assertionTypeUtil.setConditions(audience, includeAudience, before, after, assertion);
        Calendar issueInstant = Util.getUtcCalendar();
        assertion.setIssueInstant(issueInstant);
        assertion.setIssuer(issuer);
        assertion.setAssertionID(XmlIDUtil.createID());
        String assertionId = assertion.getAssertionID();
        TrackingIdSupport.addReference(assertionId);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ASSERTION_ID.toString(), (String)assertionId);
        SubjectType subjectType = null;
        if (authnInst != null) {
            AuthenticationStatementType authnStmt = assertion.addNewAuthenticationStatement();
            authnStmt.setAuthenticationInstant(authnInst);
            String authnMeth = AssertionAssemblerUtil.getValue(AssertionMapKeys.getAuthnCtxKey(), "urn:oasis:names:tc:SAML:1.0:am:unspecified", attributes);
            authnStmt.setAuthenticationMethod(authnMeth);
            subjectType = authnStmt.addNewSubject();
        } else {
            subjectType = SubjectType.Factory.newInstance();
        }
        if (confirmationMethod != null) {
            SubjectConfirmationType subjectConfirmationType = subjectType.addNewSubjectConfirmation();
            subjectConfirmationType.addConfirmationMethod(confirmationMethod);
        }
        String nameIdFormatKey = AssertionMapKeys.getNameIdFormatKey();
        String nameIdFormat = AssertionAssemblerUtil.getValue(nameIdFormatKey, guiDefinedNameIdFormat, attributes);
        NameIdentifierType nameIdentifierType = subjectType.addNewNameIdentifier();
        if (nameIdFormat != null) {
            nameIdentifierType.setFormat(nameIdFormat);
        }
        String subjectAttributeKey = AssertionMapKeys.getNameIdValueKey();
        AttributeValue subjectObj = attributes.get(subjectAttributeKey);
        Defense.notNull(subjectObj, "No entry found to map to SAML subject. Looking for key: " + subjectAttributeKey + " in map: " + attributes);
        attributes.remove(subjectAttributeKey);
        String subjectStringVal = subjectObj.toString();
        nameIdentifierType.setStringValue(subjectStringVal);
        String qualifier = AssertionAssemblerUtil.getValue(AssertionMapKeys.getNameIdQualifierKey(), null, attributes);
        if (qualifier != null) {
            nameIdentifierType.setNameQualifier(qualifier);
        }
        attributes.remove(AssertionMapKeys.getNameIdSpQualifierKey());
        this.assertionTypeUtil.addAttributeStatementForWSTrust(attributes, attributeNamespaceMappings, attrNS, subjectType, assertion);
        try {
            assertionDoc = XmlBeansUtil.canonicalize(assertionDoc, AssertionDocument.class);
        }
        catch (Exception e) {
            this.log.warn((Object)"Couldn't canonicalize assertion.", (Throwable)e);
        }
        return assertionDoc.getAssertion();
    }

    public AssertionType assembleForWSTrust(Map<String, AttributeValue> attributes, int before, int after, String attrNS, String issuer, String audience, String confirmationMethod, Calendar authnInst, String guiDefinedNameIdFormat, Map<String, String> attributeNamespaceMappings, X509Certificate spCert, Key key) throws XMLEncryptionException, XmlException {
        SubjectConfirmationType confirmationType;
        AssertionType saml = this.assembleForWSTrust(attributes, before, after, attrNS, issuer, audience, true, null, authnInst, guiDefinedNameIdFormat, attributeNamespaceMappings);
        KeyInfoType keyInfo = XmlEncryption.encryptProofKey((XmlObject)saml, key, spCert);
        if (saml.sizeOfAuthenticationStatementArray() > 0) {
            confirmationType = saml.getAuthenticationStatementArray(0).getSubject().addNewSubjectConfirmation();
            confirmationType.set((XmlObject)keyInfo);
            confirmationType.addConfirmationMethod(confirmationMethod);
        }
        if (saml.sizeOfAttributeStatementArray() > 0) {
            confirmationType = saml.getAttributeStatementArray(0).getSubject().addNewSubjectConfirmation();
            confirmationType.set((XmlObject)keyInfo);
            confirmationType.addConfirmationMethod(confirmationMethod);
        }
        return saml;
    }

    public AssertionType assembleForWSTrust(Map<String, AttributeValue> attributes, SpConnection sp, String attrNS, String issuer, String confirmationMethod, Calendar authnInst) {
        String audience = null;
        boolean includeAudience = this.config.getBooleanValue("include-AudienceRestrictionCondition-" + sp.getProtocol(), true);
        if (includeAudience) {
            audience = sp.getEntityId();
        }
        HashMap<String, String> attributeNamespaceMappings = new HashMap();
        if (sp.getWsTrustSettings().getAttributeContract() != null) {
            attributeNamespaceMappings = sp.getWsTrustSettings().getAttributeContract().getMutableAttributesInfo();
        }
        AssertionType saml = this.assembleForWSTrust(attributes, sp.getWsTrustSettings().getAssertionValidityBeforeMinutes(), sp.getWsTrustSettings().getAssertionValidityAfterMinutes(), attrNS, issuer, audience, includeAudience, confirmationMethod, authnInst, sp.getNameIdFormat(), attributeNamespaceMappings);
        return saml;
    }

    public AssertionType assembleForWSTrust(Map<String, AttributeValue> attributes, SpConnection sp, String attrNS, String issuer, String confirmationMethod, Calendar authnInst, Key key, String keyTransportAlgo) throws XmlException, XMLEncryptionException {
        String audience = null;
        boolean includeAudience = this.config.getBooleanValue("include-AudienceRestrictionCondition-" + sp.getProtocol(), true);
        if (this.config.getBooleanValue("include-AudienceRestrictionCondition-" + sp.getProtocol(), true)) {
            audience = sp.getEntityId();
        }
        HashMap<String, String> attributeNamespaceMappings = new HashMap();
        if (sp.getWsTrustSettings().getAttributeContract() != null) {
            attributeNamespaceMappings = sp.getWsTrustSettings().getAttributeContract().getMutableAttributesInfo();
        }
        AssertionType saml = this.assembleForWSTrust(attributes, sp.getWsTrustSettings().getAssertionValidityBeforeMinutes(), sp.getWsTrustSettings().getAssertionValidityAfterMinutes(), attrNS, issuer, audience, includeAudience, null, authnInst, sp.getNameIdFormat(), attributeNamespaceMappings);
        Defense.notNull(sp.getEncryptionSettings().getEncryptionCert(), "SP Encryption certificate is not defined.");
        KeyInfoType keyInfo = XmlEncryption.encryptProofKey((XmlObject)saml, key, sp.getEncryptionSettings().getEncryptionCert().getX509Certificate(), keyTransportAlgo);
        SubjectConfirmationType confirmationType = saml.getAuthenticationStatementArray(0).getSubject().addNewSubjectConfirmation();
        confirmationType.set((XmlObject)keyInfo);
        confirmationType.addConfirmationMethod(confirmationMethod);
        if (saml.sizeOfAttributeStatementArray() > 0) {
            confirmationType = saml.getAttributeStatementArray(0).getSubject().addNewSubjectConfirmation();
            confirmationType.set((XmlObject)keyInfo);
            confirmationType.addConfirmationMethod(confirmationMethod);
        }
        return saml;
    }

    public AssertionType assemble(Map<String, AttributeValue> attributes, SpConnection sp, String attrNS, String issuer, String confirmationMethod, Calendar authnInst) {
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        AssertionType assertion = assertionDoc.addNewAssertion();
        this.assertionTypeUtil.setVersion(sp, assertion);
        String assertionId = XmlIDUtil.createID();
        assertion.setAssertionID(assertionId);
        TrackingIdSupport.addReference(assertionId);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ASSERTION_ID.toString(), (String)assertionId);
        this.assertionTypeUtil.setConditions(sp.getEntityId(), this.config.getBooleanValue("include-AudienceRestrictionCondition-" + sp.getProtocol(), true), sp.getAssertionValidityBeforeMinutes(), sp.getAssertionValidityAfterMinutes(), assertion);
        Calendar issueInstant = Util.getUtcCalendar();
        assertion.setIssueInstant(issueInstant);
        assertion.setIssuer(issuer);
        AuthenticationStatementType authnStmt = assertion.addNewAuthenticationStatement();
        String subjectAttributeKey = AssertionMapKeys.getNameIdValueKey();
        AttributeValue subjectObj = attributes.get(subjectAttributeKey);
        Defense.notNull(subjectObj, "No entry found to map to SAML subject. Looking for key: " + subjectAttributeKey + " in map: " + attributes);
        attributes.remove(subjectAttributeKey);
        String subjectStringVal = subjectObj.toString();
        authnStmt.setAuthenticationInstant(authnInst);
        String authnMeth = AssertionAssemblerUtil.getValue(AssertionMapKeys.getAuthnCtxKey(), "urn:oasis:names:tc:SAML:1.0:am:unspecified", attributes);
        authnStmt.setAuthenticationMethod(authnMeth);
        SubjectType subjectType = authnStmt.addNewSubject();
        NameIdentifierType nameIdentifierType = subjectType.addNewNameIdentifier();
        if (confirmationMethod != null) {
            SubjectConfirmationType subjectConfirmationType = subjectType.addNewSubjectConfirmation();
            subjectConfirmationType.addConfirmationMethod(confirmationMethod);
        }
        String guiDefinedNameIdFormat = sp.getNameIdFormat();
        String nameIdFormatKey = AssertionMapKeys.getNameIdFormatKey();
        String nameIdFormat = AssertionAssemblerUtil.getValue(nameIdFormatKey, guiDefinedNameIdFormat, attributes);
        if (nameIdFormat != null) {
            nameIdentifierType.setFormat(nameIdFormat);
        }
        nameIdentifierType.setStringValue(subjectStringVal);
        String qualifier = AssertionAssemblerUtil.getValue(AssertionMapKeys.getNameIdQualifierKey(), null, attributes);
        if (qualifier != null) {
            nameIdentifierType.setNameQualifier(qualifier);
        }
        attributes.remove(AssertionMapKeys.getNameIdSpQualifierKey());
        HashMap<String, String> attributeNamespaceMappings = new HashMap();
        if (sp.getAttributeContract() != null) {
            attributeNamespaceMappings = sp.getAttributeContract().getMutableAttributesInfo();
        }
        this.assertionTypeUtil.addAttributeStatementForWebSSO(attributes, attributeNamespaceMappings, attrNS, subjectType, assertion);
        return assertion;
    }

    public AttributeMap disassemble(List<AssertionType> assertions, Set<String> maskedAttributeNames) {
        AttributeMap parsed = new AttributeMap();
        for (AssertionType assertionType : assertions) {
            parsed.putAll((Map)this.disassemble(assertionType, maskedAttributeNames));
        }
        return parsed;
    }

    public AttributeMap disassemble(AssertionType assertionType, Set<String> maskedAttributeNames) {
        AttributeStatementType[] attrStmts;
        AttributeMap parsedRsp = new AttributeMap();
        SubjectType subject = null;
        String assertionId = assertionType.getAssertionID();
        TrackingIdSupport.addReference(assertionId);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ASSERTION_ID.toString(), (String)assertionId);
        for (AttributeStatementType attrStmt : attrStmts = assertionType.getAttributeStatementArray()) {
            subject = attrStmt.getSubject();
            for (AttributeType attributeType : attrStmt.getAttributeArray()) {
                String name = attributeType.getAttributeName();
                AttributeValue value = this.getAttributeValues(attributeType);
                if (parsedRsp.get((Object)name) == null) {
                    parsedRsp.put(name, value);
                    continue;
                }
                parsedRsp.put(name, this.mergeValues((AttributeValue)parsedRsp.get((Object)name), value));
            }
        }
        if (assertionType.sizeOfAuthenticationStatementArray() > 0) {
            AuthenticationStatementType authnStatementType = assertionType.getAuthenticationStatementArray(0);
            subject = authnStatementType.getSubject();
            Calendar authenticationInstant = authnStatementType.getAuthenticationInstant();
            parsedRsp.put(AssertionMapKeys.getAuthnInstantKey(), AttrValueSupport.make((Object)authenticationInstant));
            String authenticationMethod = authnStatementType.getAuthenticationMethod();
            parsedRsp.put(AssertionMapKeys.getAuthnCtxKey(), new AttributeValue(authenticationMethod));
        }
        this.parseSubject(subject, parsedRsp);
        AttrValueSupport.checkSetMasked((Map)parsedRsp, maskedAttributeNames);
        return parsedRsp;
    }

    private void parseSubject(SubjectType subject, AttributeMap targetAttrs) {
        if (subject != null && subject.isSetNameIdentifier()) {
            NameIdentifierType nameID = subject.getNameIdentifier();
            String nameId = nameID.getStringValue();
            targetAttrs.put(AssertionMapKeys.getNameIdValueKey(), new AttributeValue(nameId));
            if (nameID.isSetFormat()) {
                targetAttrs.put(AssertionMapKeys.getNameIdFormatKey(), new AttributeValue(nameID.getFormat()));
            }
            if (nameID.isSetNameQualifier()) {
                String nameQualifier = nameID.getNameQualifier();
                targetAttrs.put(AssertionMapKeys.getNameIdQualifierKey(), new AttributeValue(nameQualifier));
            }
        }
    }

    private AttributeValue mergeValues(AttributeValue value1, AttributeValue value2) {
        ArrayList<String> strValues = new ArrayList<String>();
        for (String val : value1.getValues()) {
            strValues.add(val);
        }
        for (String val : value2.getValues()) {
            strValues.add(val);
        }
        return new AttributeValue(strValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeValue getAttributeValues(AttributeType attributeType) {
        XmlObject[] attributeValueArray = attributeType.getAttributeValueArray();
        ArrayList<String> values = new ArrayList<String>(attributeValueArray.length);
        for (XmlObject anAttributeValueArray : attributeValueArray) {
            XmlCursor xmlCursor = null;
            try {
                xmlCursor = anAttributeValueArray.newCursor();
                values.add(xmlCursor.getTextValue());
            }
            finally {
                XmlBeansUtil.disposeCursor(xmlCursor);
            }
        }
        return new AttributeValue(values);
    }
}

