/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.protocol;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlCursor;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.protocol.saml11.xml.AttributeStatementType;
import org.sourceid.protocol.saml11.xml.AttributeType;
import org.sourceid.protocol.saml11.xml.AudienceRestrictionConditionType;
import org.sourceid.protocol.saml11.xml.ConditionsType;
import org.sourceid.protocol.saml11.xml.NameIdentifierType;
import org.sourceid.protocol.saml11.xml.SubjectType;
import org.sourceid.saml1x.protocol.VersionSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;

public class AssertionTypeUtil {
    private static final AttributeStatementType[] EMPTY_ATTR_STMT_ARRAY = new AttributeStatementType[0];
    private static final String WS_TRUSTGLOBAL_SETTING_COFIG_NAME = "wstrust-global-settings";
    private static final String GROUP_MULTIATTR_FOR_ENTITY = "GroupMultiValuedAttributeForEntityIds";
    private Map connectionIdsMap;

    public AssertionTypeUtil() {
        ConfigStore cfg = ConfigStoreFarm.getConfig(WS_TRUSTGLOBAL_SETTING_COFIG_NAME);
        this.connectionIdsMap = cfg.getMapValue(GROUP_MULTIATTR_FOR_ENTITY, new HashMap());
    }

    public static NameIDType getSaml20NameId(AssertionType assertionType) {
        SubjectType subject = assertionType.getAuthenticationStatementArray(0).getSubject();
        NameIdentifierType nameID = subject.getNameIdentifier();
        NameIDType hackNameId = NameIDType.Factory.newInstance();
        hackNameId.setStringValue(nameID.getStringValue());
        return hackNameId;
    }

    public void setConditions(String audience, boolean includeAudience, int assertionValidityBeforeMinutes, int assertionValidityAfterMinutes, AssertionType assertionType) {
        ConditionsType conditions = assertionType.addNewConditions();
        Calendar now = Util.getUtcCalendar();
        Calendar notBefore = (Calendar)now.clone();
        Calendar notAfter = (Calendar)now.clone();
        notBefore.add(12, -1 * assertionValidityBeforeMinutes);
        notAfter.add(12, assertionValidityAfterMinutes);
        conditions.setNotBefore(notBefore);
        conditions.setNotOnOrAfter(notAfter);
        if (StringUtils.isNotBlank((String)audience) && includeAudience) {
            AudienceRestrictionConditionType audienceRestrictCondType = conditions.addNewAudienceRestrictionCondition();
            audienceRestrictCondType.addAudience(audience);
        }
    }

    public boolean hasDoNotCacheAssertion(Collection<AssertionType> assertions) {
        for (AssertionType assertionType : assertions) {
            ConditionsType conditions = assertionType.getConditions();
            if (conditions.sizeOfDoNotCacheConditionArray() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setVersion(ConnectionBase connection, AssertionType assertionType) {
        assertionType.setMajorVersion(BigInteger.ONE);
        BigInteger minorVersion = VersionSupport.getMinorVersion(connection);
        assertionType.setMinorVersion(minorVersion);
    }

    public void setVersion(BigInteger minorVersion, AssertionType assertionType) {
        assertionType.setMajorVersion(BigInteger.ONE);
        assertionType.setMinorVersion(minorVersion);
    }

    public void addAttributeStatementForWSTrust(Map<String, AttributeValue> values, Map<String, String> attrNamespaceMapping, String defaultAttrNamespace, SubjectType subjectType, AssertionType assertionType) {
        String entityId = assertionType.getIssuer();
        if (values.isEmpty()) {
            values.put(AssertionMapKeys.getNameIdValueKey(), new AttributeValue(subjectType.getNameIdentifier().getStringValue()));
        }
        AttributeStatementType attrStmt = this.addSubject(subjectType, assertionType);
        this.addAttributes(values, attrNamespaceMapping, defaultAttrNamespace, attrStmt, entityId);
    }

    public void addAttributeStatementForWebSSO(Map<String, AttributeValue> values, Map<String, String> attrNamespaceMapping, String defaultAttrNamespace, SubjectType subjectType, AssertionType assertionType) {
        if (!values.isEmpty() || assertionType.sizeOfAuthenticationStatementArray() == 0) {
            AttributeStatementType attrStmt = this.addAttributeStatement(values, attrNamespaceMapping, defaultAttrNamespace, subjectType, assertionType);
            this.setEmptyIfNoAttributes(assertionType, attrStmt);
        }
    }

    public AttributeStatementType addAttributeStatement(Map<String, AttributeValue> values, Map<String, String> attrNamespaceMapping, String defaultAttrNamespace, SubjectType subjectType, AssertionType assertionType) {
        String entityId = assertionType.getIssuer();
        AttributeStatementType attrStmt = this.addSubject(subjectType, assertionType);
        this.addAttributes(values, attrNamespaceMapping, defaultAttrNamespace, attrStmt, entityId);
        return attrStmt;
    }

    private void setEmptyIfNoAttributes(AssertionType assertionType, AttributeStatementType attrStmt) {
        if (attrStmt.sizeOfAttributeArray() == 0) {
            assertionType.setAttributeStatementArray(EMPTY_ATTR_STMT_ARRAY);
        }
    }

    private void addAttributes(Map<String, AttributeValue> values, Map<String, String> attrNamespaceMapping, String defaultAttrNamespace, AttributeStatementType attrStmt, String entityId) {
        String groupAttributeValue;
        boolean groupMultiValuesAttrEnabled = true;
        if (this.connectionIdsMap != null && !this.connectionIdsMap.isEmpty() && (groupAttributeValue = (String)this.connectionIdsMap.get(entityId)) != null && groupAttributeValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
            groupMultiValuesAttrEnabled = false;
        }
        for (Map.Entry<String, AttributeValue> e : values.entrySet()) {
            AttributeValue value = e.getValue();
            String key = e.getKey();
            String attrNS = defaultAttrNamespace;
            if (attrNamespaceMapping.containsKey(key) && StringUtils.isNotBlank((String)attrNamespaceMapping.get(key))) {
                attrNS = attrNamespaceMapping.get(key);
            }
            if (value == null) continue;
            if (groupMultiValuesAttrEnabled) {
                AttributeType attributeType = attrStmt.addNewAttribute();
                attributeType.setAttributeName(key);
                if (attrNamespaceMapping.containsKey(key) && StringUtils.isNotBlank((String)attrNamespaceMapping.get(key))) {
                    attributeType.setAttributeNamespace(attrNamespaceMapping.get(key));
                } else {
                    attributeType.setAttributeNamespace(defaultAttrNamespace);
                }
                attributeType.setAttributeNamespace(attrNS);
                for (String val : value.getValues()) {
                    this.addAttributeValue(attributeType, val);
                }
                continue;
            }
            for (String val : value.getValues()) {
                AttributeType attributeType = attrStmt.addNewAttribute();
                attributeType.setAttributeName(key);
                attributeType.setAttributeNamespace(attrNS);
                this.addAttributeValue(attributeType, val);
            }
        }
    }

    private AttributeStatementType addSubject(SubjectType subjectType, AssertionType assertionType) {
        AttributeStatementType attrStmt = assertionType.addNewAttributeStatement();
        attrStmt.setSubject(subjectType);
        return attrStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAttributeValue(AttributeType attributeType, String value) {
        XmlCursor xmlCursor = attributeType.addNewAttributeValue().newCursor();
        try {
            xmlCursor.setTextValue(value);
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }
}

