/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.protocol;

import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.protocol.saml11.xml.ConditionsType;
import org.sourceid.protocol.samlp11.xml.ResponseDocument;
import org.sourceid.protocol.samlp11.xml.ResponseType;
import org.sourceid.protocol.samlp11.xml.StatusCodeType;
import org.sourceid.protocol.samlp11.xml.StatusType;
import org.sourceid.saml1x.protocol.TopLevelStatusCode;
import org.sourceid.saml1x.protocol.ValidateAssertionConditions;
import org.sourceid.saml1x.protocol.ValidateAssertionConfirmationMethods;
import org.sourceid.saml1x.protocol.ValidateAssertionIssuer;
import org.sourceid.saml1x.protocol.ValidateAssertionSignature;
import org.sourceid.saml1x.protocol.ValidateAssertionVersion;
import org.sourceid.saml1x.protocol.VersionSupport;
import org.sourceid.saml1x.wrapper.AssertionStatus;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.BearerAssertionReplayPreventionServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.wrapper.InMessageContext;

public class ValidateWebSsoResponse {
    private final MetadataDirectory metadataDirectory;
    private final MetadataLocal metadataLocal;
    private final AssertionReplayPreventionService replayPreventionService;
    private final ConfigStore cfg;
    private final ValidateAssertionConditions validateAssertionConditions = new ValidateAssertionConditions();
    private final ValidateAssertionConfirmationMethods validateAssrtnConfMethods = new ValidateAssertionConfirmationMethods();
    private final ValidateAssertionIssuer validateAssertionIssuer = new ValidateAssertionIssuer();
    private final ValidateAssertionSignature validateAssertionSignature = new ValidateAssertionSignature();
    private final ValidateAssertionVersion validateAssertionVersion = new ValidateAssertionVersion();

    public ValidateWebSsoResponse(MetadataDirectory metadataDirectory, MetadataLocal metadataLocal) {
        this.metadataDirectory = metadataDirectory;
        this.metadataLocal = metadataLocal;
        this.replayPreventionService = StateMgmtFactory.getBearerAssertionReplayPreventionSvc();
        this.cfg = ConfigStoreFarm.getConfig(this.getClass());
    }

    public ValidAssertions validate(InMessageContext respMsgCtx) throws InvalidResponseException, IOException {
        IdpConnection idp = this.metadataDirectory.getIdpConnectionMetadata(respMsgCtx.getEntityId());
        XmlObject xmlObject = respMsgCtx.getXmlObject();
        ResponseDocument responseDocument = (ResponseDocument)xmlObject;
        ResponseType response = responseDocument.getResponse();
        StatusType status = response.getStatus();
        StatusCodeType statusCode = status.getStatusCode();
        QName scvalue = statusCode.getValue();
        String successLocalPart = TopLevelStatusCode.SUCCESS.getQName().getLocalPart();
        if (!successLocalPart.equals(scvalue.getLocalPart())) {
            StringBuilder sb = new StringBuilder();
            sb.append("Status code on response not ").append(successLocalPart).append(".  Status Message: '");
            sb.append(status.getStatusMessage()).append("'. Full response message: ").append(respMsgCtx);
            throw new InvalidSsoResponseException(sb.toString());
        }
        this.validateVersion(response, idp);
        this.validateIssueInstant(response);
        this.validateRecipient(response, respMsgCtx);
        int numberOfAssertions = response.sizeOfAssertionArray();
        if (numberOfAssertions == 0) {
            throw new InvalidSsoResponseException("No assertions present in the response: " + respMsgCtx);
        }
        ArrayList<AssertionStatus> assertionStatuses = new ArrayList<AssertionStatus>(numberOfAssertions);
        for (AssertionType assertionType : response.getAssertionArray()) {
            AssertionStatus assertionStatus = this.validateAssertion(assertionType, respMsgCtx, idp);
            assertionStatuses.add(assertionStatus);
        }
        Integer firstSsoAssertionIdx = null;
        ArrayList<AssertionType> validAssertions = new ArrayList<AssertionType>(assertionStatuses.size());
        int idx = -1;
        for (AssertionStatus assertionStatus : assertionStatuses) {
            ++idx;
            AssertionType assertion = assertionStatus.getAssertionType();
            boolean isSsoAssertion = true;
            if (!assertionStatus.isValid()) {
                isSsoAssertion = false;
            } else {
                validAssertions.add(assertion);
            }
            if (!assertion.isSetConditions()) {
                assertionStatus.addRemark("Not an SSO assertion because no conditions are set.");
                isSsoAssertion = false;
            } else {
                ConditionsType conditions = assertion.getConditions();
                if (!conditions.isSetNotBefore()) {
                    assertionStatus.addRemark("Not an SSO assertion because the 'Not Before' condition was not set.");
                    isSsoAssertion = false;
                }
                if (!conditions.isSetNotOnOrAfter()) {
                    assertionStatus.addRemark("Not an SSO assertion because the 'Not On Or After' condition was not set.");
                    isSsoAssertion = false;
                }
            }
            if (assertion.sizeOfAuthenticationStatementArray() == 0) {
                assertionStatus.addRemark("Not an SSO assertion because no authentication statements were present.");
                isSsoAssertion = false;
            }
            if (!isSsoAssertion) continue;
            Calendar notOnOrAfter = assertion.getConditions().getNotOnOrAfter();
            String assertionID = assertion.getAssertionID();
            try {
                if (this.replayPreventionService.isReplay(assertionID, notOnOrAfter)) {
                    throw new InvalidSsoResponseException("SSO Assertion with ID of " + assertionID + " has previously been processed - this may be an indication of a replay attack.");
                }
                if (firstSsoAssertionIdx != null) continue;
                firstSsoAssertionIdx = idx;
            }
            catch (BearerAssertionReplayPreventionServiceException e) {
                throw new ProcessRuntimeException("Unable to perform replay check on assertion.", e);
            }
        }
        if (firstSsoAssertionIdx == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("No SSO assertion found in response.  All assertions were either ");
            sb.append("not valid or didn't meet the criteria for an SSO assertion.  Assertions: ");
            sb.append(((Object)assertionStatuses).toString()).append(". ").append(respMsgCtx);
            throw new InvalidSsoResponseException(sb.toString());
        }
        return new ValidAssertions(validAssertions, firstSsoAssertionIdx);
    }

    private AssertionStatus validateAssertion(AssertionType assertionType, InMessageContext respMsgCtx, IdpConnection idp) {
        AssertionStatus assertionStatus = new AssertionStatus(assertionType);
        this.validateAssertionSignature.validate(assertionStatus, idp);
        this.validateAssertionConditions.validate(assertionStatus, this.getAudienceIds(respMsgCtx, idp));
        if (this.cfg.getBooleanValue("validate-confirmation-methods", true)) {
            this.validateAssrtnConfMethods.validate(assertionStatus, respMsgCtx.getBinding());
        }
        if (this.cfg.getBooleanValue("validate-issuer", true)) {
            this.validateAssertionIssuer.validate(assertionStatus, idp.getEntityId());
        }
        this.validateAssertionVersion.validate(assertionStatus, idp);
        return assertionStatus;
    }

    private void validateVersion(ResponseType response, IdpConnection idp) throws InvalidResponseException {
        BigInteger majorVersion = response.getMajorVersion();
        BigInteger minorVersion = response.getMinorVersion();
        VersionSupport.validateVersion(idp, majorVersion, minorVersion, "response doc");
    }

    private void validateIssueInstant(ResponseType response) throws InvalidSsoResponseException {
        Calendar issueInstant = response.getIssueInstant();
        if (issueInstant.getTimeZone().getRawOffset() != 0) {
            throw new InvalidSsoResponseException("IssueInstant timezone is not UTC: " + issueInstant.toString());
        }
    }

    private void validateRecipient(ResponseType response, InMessageContext respMsgCtx) throws InvalidResponseException, MalformedURLException {
        if (response.isSetRecipient() && "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01".equals(respMsgCtx.getBinding())) {
            URL recipientUrl;
            String recipient = response.getRecipient();
            try {
                recipientUrl = new URL(recipient.toLowerCase());
            }
            catch (MalformedURLException e) {
                throw new InvalidSsoResponseException("Unrecognized recipient (" + recipient + ") in response document: " + e);
            }
            String recipientHost = recipientUrl.getHost();
            String baseUrlString = this.metadataLocal.getBaseUrl();
            URL baseUrl = new URL(baseUrlString);
            String host = baseUrl.getHost();
            if (!(host.equals(recipientHost) || host.contains(recipientHost) || recipientHost.contains(host))) {
                throw new InvalidSsoResponseException("Unrecognized recipient in response document: " + recipient);
            }
        }
    }

    private List<String> getAudienceIds(InMessageContext respMsgCtx, ConnectionBase connection) {
        return VirtualIdentityUtil.getAllowedAudiences(respMsgCtx, connection);
    }

    public static class ValidAssertions {
        private final List<AssertionType> validAssertions;
        private final int primarySsoIdx;

        ValidAssertions(List<AssertionType> validAssertions, int primarySsoIdx) {
            this.validAssertions = validAssertions;
            this.primarySsoIdx = primarySsoIdx;
        }

        public List<AssertionType> getValidAssertions() {
            return this.validAssertions;
        }

        public int getPrimarySsoIdx() {
            return this.primarySsoIdx;
        }
    }
}

