/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.attribute;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pingidentity.sdk.internal.services.interfaces.AttrValueSupportService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.json.JsonUtils;
import org.sourceid.util.log.AttributeMap;

public class AttrValueSupportServiceImpl
implements AttrValueSupportService {
    private static final Log log = LogFactory.getLog(AttrValueSupport.class);

    public AttributeValue make(Object obj) {
        return this.make(obj, false);
    }

    public AttributeValue make(Object obj, boolean trim) {
        try {
            return (AttributeValue)obj;
        }
        catch (ClassCastException e) {
            return this.make(Arrays.asList(obj), trim);
        }
    }

    public AttributeValue make(Collection<?> objs) {
        return this.make(objs, false);
    }

    public AttributeValue make(Collection<?> objs, boolean trimValues) {
        ArrayList<String> strings = new ArrayList<String>(objs.size());
        ArrayList newobjs = new ArrayList(objs.size());
        for (Object o : objs) {
            String string;
            if (o == null) {
                string = null;
            } else if (o instanceof byte[]) {
                string = Base64.encodeBase64String((byte[])((byte[])o));
            } else if (o instanceof ObjectNode || o.getClass().getName().endsWith("ObjectNode")) {
                try {
                    string = o.toString();
                    o = JsonUtils.getInstance().readToMap(o.toString());
                }
                catch (JsonProcessingException e) {
                    log.debug((Object)"Error parsing attribute value.", (Throwable)e);
                    string = o.toString();
                }
            } else {
                string = trimValues ? o.toString().trim() : o.toString();
            }
            newobjs.add(o);
            strings.add(string);
        }
        return new AttributeValue(strings, newobjs);
    }

    public AttributeMap convert(Map<String, Object> srcMap, boolean maskAll) {
        return this.convert(srcMap, maskAll, false);
    }

    public AttributeMap convert(Map<String, Object> srcMap, boolean maskAll, boolean trim) {
        Set<String> empty = Collections.emptySet();
        return this.convert(srcMap, maskAll, empty, false, trim);
    }

    public AttributeMap convert(Map<String, Object> srcMap, Set<String> maskedKeySet, boolean maskOgnlValues) {
        return this.convert(srcMap, false, maskedKeySet, maskOgnlValues);
    }

    public AttributeMap setMasked(AttributeMap srcMap, Set<String> maskedKeySet, boolean maskOgnlValues) {
        AttributeMap values = new AttributeMap();
        for (Map.Entry e : srcMap.entrySet()) {
            if (maskedKeySet.contains(e.getKey())) {
                this.setMasked((AttributeValue)e.getValue());
            }
            values.put((String)e.getKey(), (AttributeValue)e.getValue());
        }
        values.setMaskOgnlValues(maskOgnlValues);
        return values;
    }

    public void checkSetMasked(Map<String, AttributeValue> attrMap, Set<String> maskedKeySet) {
        for (Map.Entry<String, AttributeValue> e : attrMap.entrySet()) {
            String name = e.getKey();
            AttributeValue attributeValue = e.getValue();
            attributeValue.setMasked(maskedKeySet.contains(name));
        }
    }

    public void setMasked(AttributeValue attributeValue) {
        if (attributeValue != null) {
            attributeValue.setMasked(true);
        }
    }

    public AttributeMap convert(Map<String, Object> srcMap, boolean maskAll, Set<String> maskedKeySet, boolean maskOgnlValues) {
        return this.convert(srcMap, maskAll, maskedKeySet, maskOgnlValues, false);
    }

    public AttributeMap convert(Map<String, Object> srcMap, boolean maskAll, Set<String> maskedKeySet, boolean maskOgnlValues, boolean trimValues) {
        if (srcMap == null) {
            srcMap = Collections.emptyMap();
        }
        AttributeMap values = new AttributeMap();
        for (Map.Entry<String, Object> e : srcMap.entrySet()) {
            AttributeValue av = this.make(e.getValue(), trimValues);
            if (maskAll || maskedKeySet.contains(e.getKey())) {
                this.setMasked(av);
            }
            values.put(e.getKey(), av);
        }
        values.setMaskOgnlValues(maskOgnlValues);
        return values;
    }
}

