/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.conf.internal;

import java.util.Set;

public class ConfigOverrideMetadata {
    private final Set<String> overriddenFields;
    private final Set<String> overriddenAdvancedFields;
    private final Set<String> overriddenTables;
    private final boolean overrideAll;

    public ConfigOverrideMetadata() {
        this(false);
    }

    public ConfigOverrideMetadata(boolean overrideAll) {
        this.overrideAll = overrideAll;
        this.overriddenFields = null;
        this.overriddenAdvancedFields = null;
        this.overriddenTables = null;
    }

    public ConfigOverrideMetadata(Set<String> overriddenFields, Set<String> overriddenAdvancedFields, Set<String> overriddenTables) {
        this.overrideAll = false;
        this.overriddenFields = overriddenFields;
        this.overriddenAdvancedFields = overriddenAdvancedFields;
        this.overriddenTables = overriddenTables;
    }

    public boolean isAdvancedFieldOverridden(String advancedFieldName) {
        if (this.overrideAll) {
            return true;
        }
        if (this.overriddenAdvancedFields == null) {
            return false;
        }
        return this.overriddenAdvancedFields.contains(advancedFieldName);
    }

    public boolean isFieldOverridden(String fieldName) {
        if (this.overrideAll) {
            return true;
        }
        if (this.overriddenFields == null) {
            return false;
        }
        return this.overriddenFields.contains(fieldName);
    }

    public boolean isTableOverridden(String tableName) {
        if (this.overrideAll) {
            return true;
        }
        if (this.overriddenTables == null) {
            return false;
        }
        return this.overriddenTables.contains(tableName);
    }
}

