/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.RelayStateBindingException;
import org.sourceid.saml20.bindings.RelayStateSupport;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.servlet.ServletExceptionSupport;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

abstract class AbstractAsyncBinding
implements Binding {
    public static final int MAX_RELAY_STATE = 80;
    private final ConfigStore config = ConfigStoreFarm.getConfig(AbstractAsyncBinding.class);
    protected Log log = LogFactory.getLog(this.getClass());
    final SignatureEngine signatureSvc = GlobalRegistry.getService(SignatureEngine.class);
    private final RelayStateSupport relayStateSupport = new RelayStateSupport();

    AbstractAsyncBinding() {
    }

    protected abstract InMessageContext doReceive(HttpServletRequest var1, HttpServletResponse var2, InMessageContext var3) throws IOException, BindingException, RedirectException, RenderPageException, HttpStatusCodeException;

    protected abstract void transport(HttpServletRequest var1, HttpServletResponse var2, OutMessageContext var3, boolean var4) throws IOException, BindingException, RedirectException;

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException {
        this.relayStateSupport.associate(msgCtx, req, resp, true);
        this.checkRelayStateLength(msgCtx);
        this.transport(req, resp, msgCtx, true);
        return null;
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException {
        this.checkRelayStateLength(msgCtx);
        this.transport(request, response, msgCtx, false);
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RedirectException, RenderPageException, HttpStatusCodeException {
        String relayState = request.getParameter("RelayState");
        this.checkRelayStateLength(relayState);
        InMessageContext msgCtxIn = new InMessageContext(partnerRole);
        msgCtxIn.setBinding(this.getUri());
        InMessageContext inMessageContext = this.doReceive(request, response, msgCtxIn);
        this.relayStateSupport.lookupAssociation(inMessageContext, relayState, request, response);
        return inMessageContext;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException {
        ServletExceptionSupport.throwServletException(e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    void checkRelayStateLength(String relayState) throws UnsupportedEncodingException, RelayStateBindingException {
        int size;
        if (this.isValidateRelayStateLength() && relayState != null && (size = Array.getLength(relayState.getBytes("UTF-8"))) > 80) {
            String msg = "The Relay State (" + relayState + ") length (" + size + ") exceeds 80 bytes";
            throw new RelayStateBindingException(msg);
        }
    }

    void checkRelayStateLength(BaseMessageContext msgCtx) throws UnsupportedEncodingException, RelayStateBindingException {
        if (this.isValidateRelayStateLength()) {
            String relayState = msgCtx.getRelayState();
            this.checkRelayStateLength(relayState);
        }
    }

    private boolean isValidateRelayStateLength() {
        return this.config.getBooleanValue("ValidateRelayStateLength", true);
    }

    @Override
    public boolean isEntityIdRequired() {
        return true;
    }
}

