/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.sourceid.common.ByteUtil;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public class Artifact
extends org.sourceid.common.Artifact {
    private byte[] enpointIndex;
    private static final int ENDPOINT_IDX_LENGTH = 2;
    private static final int LENGTH = 44;

    private Artifact(byte[] typecode, byte[] endpointIdx, byte[] sourceID, byte[] messageHandle) {
        super(typecode, sourceID, messageHandle);
        if (endpointIdx.length != 2) {
            throw new IllegalArgumentException("EndpointIndex must be 2 bytes.");
        }
        this.enpointIndex = endpointIdx;
    }

    protected Artifact(byte[] typecode, int endpointIdx, byte[] sourceID, byte[] messageHandle) {
        this(typecode, ByteUtil.getTwoBytes(endpointIdx), sourceID, messageHandle);
    }

    public byte[] getEndpointIndexBytes() {
        return this.enpointIndex;
    }

    public int getEndpointIndex() {
        return ByteUtil.getInt(this.enpointIndex);
    }

    @Override
    public byte[] rawBytes() {
        byte[] alldata = new byte[44];
        int idx = 0;
        System.arraycopy(this.typecode, 0, alldata, idx, 2);
        System.arraycopy(this.enpointIndex, 0, alldata, idx += 2, 2);
        System.arraycopy(this.sourceId, 0, alldata, idx += 2, 20);
        System.arraycopy(this.messageHandle, 0, alldata, idx += 20, 20);
        return alldata;
    }

    public static Artifact parse(String artifact) {
        byte[] alldata = org.sourceid.common.Artifact.parseToBytes(artifact);
        if (alldata.length != 44) {
            throw new IllegalArgumentException("Error parsing artifact (" + artifact + ") - expected length of 44 bytes but was " + alldata.length);
        }
        int idx = 0;
        byte[] typecode = new byte[2];
        System.arraycopy(alldata, idx, typecode, 0, 2);
        byte[] enpointIndex = new byte[2];
        System.arraycopy(alldata, idx += 2, enpointIndex, 0, 2);
        byte[] sourceId = new byte[20];
        System.arraycopy(alldata, idx += 2, sourceId, 0, 20);
        byte[] messageHandle = new byte[20];
        System.arraycopy(alldata, idx += 20, messageHandle, 0, 20);
        return new Artifact(typecode, enpointIndex, sourceId, messageHandle);
    }
}

