/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import com.pingidentity.common.util.LogGuard;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.oauth20.bindings.OauthBindingGroup;
import org.sourceid.openid.ciba.bindings.CibaBindingGroup;
import org.sourceid.openid.connect.bindings.OIDCBindingGroup;
import org.sourceid.saml1x.bindings.Saml1xBindingURIs;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.BindingLogProxy;
import org.sourceid.saml20.bindings.BindingURIs;
import org.sourceid.saml20.bindings.LoggingInterceptor;
import org.sourceid.servlet.QuietException;
import org.sourceid.websso.bindings.ProtocolBindingGroup;
import org.sourceid.wsfed.bindings.WSFedBindingURIs;
import org.sourceid.wstrust.bindings.WSTrustBindingGroup;

public class BindingFactory {
    private static final String REQ_ATTR_NAME_BINDING = "binding";
    private static final Log log = LogFactory.getLog(BindingFactory.class);
    private static final Map<String, Binding> bindingsMap;
    private static final Map<String, ProtocolBindingGroup> suffixToProtoMap;
    public static final String SAML2_AUTH_SUFFIX = ".ssaml2";
    public static final String SAML1X_AUTH_SUFFIX = ".ssaml1";
    public static final String SAML2_SUFFIX = ".saml2";
    public static final String SAML1X_SUFFIX = ".saml1";
    public static final String WSFED_SUFFIX = ".wsf";
    public static final String WSTRUST_SUFFIX = ".wst";

    public static boolean needTransportLayerAuth(String path) {
        boolean need = path.endsWith(SAML2_AUTH_SUFFIX);
        return need |= path.endsWith(SAML1X_AUTH_SUFFIX);
    }

    static String ascertainBindingName(HttpServletRequest req, boolean isPost, boolean logit) throws IOException {
        String bindingName = (String)req.getAttribute(REQ_ATTR_NAME_BINDING);
        if (bindingName == null) {
            String path = req.getServletPath();
            int idx = path.lastIndexOf(46);
            String suffix = idx >= 0 ? path.substring(idx) : null;
            ProtocolBindingGroup bindingGroup = suffixToProtoMap.get(suffix);
            bindingName = bindingGroup.ascertainBindingName(req, isPost);
            req.setAttribute(REQ_ATTR_NAME_BINDING, (Object)bindingName);
            if (logit && log.isDebugEnabled()) {
                BindingFactory.log(req, bindingName);
            }
        }
        return bindingName;
    }

    static Binding getBinding(String bindingName) throws BindingException {
        Binding binding = bindingsMap.get(bindingName);
        if (binding == null) {
            Object msg = bindingName == null ? "Request contains insufficient information to determine the protocol binding (did you type a protocol endpoint URL directly into the location bar of your browser?)." : "Unknown or unsupported binding: " + bindingName;
            throw new UnknownBindingException((String)msg);
        }
        return binding;
    }

    private static void log(HttpServletRequest request, String binding) {
        StringBuilder msg = new StringBuilder(request.getMethod());
        msg.append(Util.LINE_BREAK);
        msg.append(" with Params: ");
        Map parameterMap = request.getParameterMap();
        msg.append(LogGuard.encode(String.valueOf(parameterMap.keySet())));
        msg.append(Util.LINE_BREAK);
        msg.append(" assume binding: ").append(binding);
        msg.append(Util.LINE_BREAK);
        msg.append(" from: ").append(request.getRemoteHost());
        msg.append(Util.LINE_BREAK);
        msg.append(" Referer: ").append(request.getHeader("Referer"));
        msg.append(Util.LINE_BREAK);
        msg.append(" AuthType: ").append(request.getAuthType());
        msg.append(Util.LINE_BREAK);
        msg.append(" Content-Type: ").append(request.getHeader("Content-Type"));
        log.debug((Object)msg);
    }

    static {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        BindingURIs saml2Bindings = new BindingURIs();
        WSFedBindingURIs wsfBindings = new WSFedBindingURIs();
        Saml1xBindingURIs saml1xBindings = new Saml1xBindingURIs();
        WSTrustBindingGroup wstBindings = new WSTrustBindingGroup();
        OauthBindingGroup oauthBindingGroup = new OauthBindingGroup();
        OIDCBindingGroup openIdBindings = new OIDCBindingGroup();
        CibaBindingGroup cibaBindings = new CibaBindingGroup();
        suffixToProtoMap = new HashMap<String, ProtocolBindingGroup>();
        suffixToProtoMap.put(SAML2_SUFFIX, saml2Bindings);
        suffixToProtoMap.put(SAML2_AUTH_SUFFIX, saml2Bindings);
        suffixToProtoMap.put(SAML1X_SUFFIX, saml1xBindings);
        suffixToProtoMap.put(null, saml1xBindings);
        suffixToProtoMap.put(SAML1X_AUTH_SUFFIX, saml1xBindings);
        suffixToProtoMap.put(WSFED_SUFFIX, wsfBindings);
        suffixToProtoMap.put(WSTRUST_SUFFIX, wstBindings);
        suffixToProtoMap.put(".oauth2", oauthBindingGroup);
        suffixToProtoMap.put(".openid", openIdBindings);
        suffixToProtoMap.put(".ciba", cibaBindings);
        bindings.addAll(saml2Bindings.getBindings());
        bindings.addAll(wsfBindings.getBindings());
        bindings.addAll(saml1xBindings.getBindings());
        bindings.addAll(wstBindings.getBindings());
        bindings.addAll(oauthBindingGroup.getBindings());
        bindings.addAll(openIdBindings.getBindings());
        bindings.addAll(cibaBindings.getBindings());
        bindingsMap = new HashMap<String, Binding>();
        for (Binding binding : bindings) {
            bindingsMap.put(binding.getUri(), binding);
        }
        for (String key : bindingsMap.keySet()) {
            Binding binding = bindingsMap.get(key);
            bindingsMap.put(key, new LoggingInterceptor(new BindingLogProxy(binding)));
        }
    }

    private static class UnknownBindingException
    extends BindingException
    implements QuietException {
        public UnknownBindingException(String message) {
            super(message);
        }
    }
}

