/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.PropertyInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.LoggingMode;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class BindingLogProxy
implements Binding {
    static final String LINE_BREAK;
    private static final String LOGGING_PARAM_DELIM = " | ";
    private static final Log log;
    private final Binding proxiedBinding;
    private static final String hostname;

    public BindingLogProxy(Binding proxiedBinding) {
        this.proxiedBinding = proxiedBinding;
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        InMessageContext inMessageContext = this.proxiedBinding.transportRequest(req, resp, msgCtx);
        this.logMsg("Sent Request", msgCtx);
        if (inMessageContext != null) {
            this.logMsg("Transport/Receive Synchronous Response", inMessageContext);
        }
        return inMessageContext;
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext outMsgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        this.proxiedBinding.transportResponse(request, response, outMsgCtx);
        this.logMsg("Sent Response", outMsgCtx);
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws BindingException, IOException, RedirectException, RenderPageException, HttpStatusCodeException {
        InMessageContext inMessageContext = this.proxiedBinding.receive(request, response, partnerRole);
        inMessageContext.setBinding(this.proxiedBinding.getUri());
        this.logMsg("Received Message", inMessageContext);
        return inMessageContext;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException, RenderPageException {
        this.proxiedBinding.handleException(req, resp, e);
    }

    @Override
    public boolean isBackChannel() {
        return this.proxiedBinding.isBackChannel();
    }

    void logMsg(String messageQualifier, BaseMessageContext msgCtx) {
        try {
            this.doLogMsg(messageQualifier, msgCtx);
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected exception during transaction logging: " + e));
        }
    }

    void doLogMsg(String messageQualifier, BaseMessageContext msgCtx) {
        LoggingMode loggingMode = LoggingMode.NONE;
        if (msgCtx.getEntityId() != null && msgCtx.getRoleType() != null) {
            try {
                ConnectionBase conn = MetadataSupport.getBaseConnectionMetadata(msgCtx);
                loggingMode = conn.getLoggingMode();
            }
            catch (ConfigurationException conn) {
                // empty catch block
            }
        }
        if (loggingMode != LoggingMode.NONE) {
            StringBuilder msg = new StringBuilder(LOGGING_PARAM_DELIM);
            msg.append(hostname).append(":").append(PropertyInfo.getRuntimeHttpsPort());
            msg.append(LOGGING_PARAM_DELIM).append(loggingMode.toString().charAt(0));
            msg.append(LOGGING_PARAM_DELIM).append(messageQualifier);
            msg.append((CharSequence)msgCtx.getStandardInfo());
            switch (loggingMode) {
                case ENHANCED: {
                    msg.append((CharSequence)msgCtx.getEnhancedInfo());
                    break;
                }
                case FULL: {
                    msg.append((CharSequence)msgCtx.getEnhancedInfo());
                    msg.append(msgCtx.getFullInfo());
                }
            }
            log.info((Object)LogGuard.encode(msg));
        }
    }

    @Override
    public String getUri() {
        return this.proxiedBinding.getUri();
    }

    @Override
    public boolean isEntityIdRequired() {
        return this.proxiedBinding.isEntityIdRequired();
    }

    static {
        String tempHostname;
        LINE_BREAK = System.getProperty("line.separator");
        log = LogFactory.getLog(BindingLogProxy.class);
        try {
            tempHostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            tempHostname = "unknown";
        }
        hostname = tempHostname;
    }
}

