/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.soap.soap11.SoapEndpointUtility;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.EcpSoapBinding;
import org.sourceid.saml20.bindings.HttpArtifactBinding;
import org.sourceid.saml20.bindings.HttpPostBinding;
import org.sourceid.saml20.bindings.HttpRedirectBinding;
import org.sourceid.saml20.bindings.ReverseHttpSoapBinding;
import org.sourceid.saml20.bindings.SoapBinding;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.xmlbinding.ecp.RelayStateType;
import org.sourceid.saml20.xmlbinding.ecp.ResponseType;
import org.sourceid.websso.bindings.ProtocolBindingGroup;

public class BindingURIs
extends ProtocolBindingGroup {
    public static final String SOAP = "urn:oasis:names:tc:SAML:2.0:bindings:SOAP";
    public static final String PAOS = "urn:oasis:names:tc:SAML:2.0:bindings:PAOS";
    public static final String REDIRECT = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    public static final String POST = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    public static final String ARTIFACT = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    private String ecpSsoPath;
    private static final Set<String> bindingSet = new HashSet<String>();

    public BindingURIs() {
        this.bindings = new Binding[]{new HttpArtifactBinding(), new HttpPostBinding(), new HttpRedirectBinding(), new SoapBinding(), new EcpSoapBinding(), new ReverseHttpSoapBinding()};
        MetadataLocal ml = MetaDataFactory.getLocalMetaData();
        EndpointGroup singleSignOnServices = ml.getSingleSignOnServices();
        Endpoint acsEndpoint = singleSignOnServices.getEndpointByBinding(SOAP);
        acsEndpoint = acsEndpoint != null ? acsEndpoint : singleSignOnServices.getPrimaryEndpoint();
        this.ecpSsoPath = acsEndpoint != null ? acsEndpoint.getLocation() : null;
    }

    @Override
    public String ascertainBindingName(HttpServletRequest req, boolean isPost) throws IOException {
        String bindingName = null;
        if (this.hasParam(req, "SAMLart")) {
            bindingName = ARTIFACT;
        } else if (this.hasParam(req, "SAMLRequest") || this.hasParam(req, "SAMLResponse")) {
            bindingName = isPost ? POST : REDIRECT;
        } else if (isPost) {
            List<XmlObject> headers;
            bindingName = SOAP;
            if (this.ecpSsoPath != null && req.getServletPath().endsWith(this.ecpSsoPath)) {
                bindingName = "urn:oasis:names:tc:SAML:2.0:bindings:SOAP(ECP)";
            }
            if (!Util.isEmpty(headers = SoapEndpointUtility.getHeaderMessagesUnchecked(req))) {
                for (XmlObject header : headers) {
                    if (!(header instanceof RelayStateType) && !(header instanceof ResponseType)) continue;
                    bindingName = PAOS;
                }
            }
        }
        return bindingName;
    }

    public static Set<String> getBindingSet() {
        return bindingSet;
    }

    static {
        bindingSet.add(SOAP);
        bindingSet.add(PAOS);
        bindingSet.add(REDIRECT);
        bindingSet.add(POST);
        bindingSet.add(ARTIFACT);
    }
}

