/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.bindings.AbstractAsyncBinding;
import org.sourceid.saml20.bindings.Artifact;
import org.sourceid.saml20.bindings.ArtifactV4;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.HttpPostTemplate;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.protocol.ArtifactResponseTypeUtil;
import org.sourceid.saml20.protocol.RequestAbstractTypeUtil;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.SignaturePolicy;
import org.sourceid.saml20.xmlbinding.protocol.ArtifactResolveDocument;
import org.sourceid.saml20.xmlbinding.protocol.ArtifactResolveType;
import org.sourceid.saml20.xmlbinding.protocol.ArtifactResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.ArtifactResponseType;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.bindings.ArtifactSupport;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

class HttpArtifactBinding
extends AbstractAsyncBinding {
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private final ArtifactPersistenceService artifactPersistenceSvc = StateMgmtFactory.getArtifactPersistenceService();
    private final ArtifactSupport artifactSupport = new ArtifactSupport();

    HttpArtifactBinding() {
    }

    @Override
    public void transport(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx, boolean isMsgRequest) throws IOException, BindingException {
        ArtifactPersistenceService.Handle handle;
        ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(msgCtx);
        if (msgCtx.getSignaturePolicy() == SignaturePolicy.SIGN) {
            this.signatureSvc.signXml(msgCtx);
        }
        int timeoutSeconds = connection.getArtifactTimeoutSeconds();
        XmlObject xml = msgCtx.getXmlObject();
        ArtifactPersistenceService.Message msg = new ArtifactPersistenceService.Message(xml, msgCtx.getEntityId(), msgCtx.getRoleType());
        msg.setMaskedAttributeNames(msgCtx.getMaskedAttributeNames());
        try {
            handle = this.artifactPersistenceSvc.saveArtifact(msg, timeoutSeconds);
        }
        catch (GeneralServiceException e) {
            throw new BindingException("Unable to save Artifact", e);
        }
        byte[] sourceId = VirtualIdentityUtil.resolve((BaseMessageContext)msgCtx, connection).getVirtualSourceId();
        ArtifactV4 artifact = new ArtifactV4(handle.getEndpointIndex(), sourceId, handle.getMessageHandle());
        String endpoint = msgCtx.getEndpoint();
        String relayState = msgCtx.getRelayState();
        String artifactString = artifact.toString();
        TrackingIdSupport.addReference(artifactString);
        msgCtx.setParam("SAMLart", artifactString);
        if (this.config.getBooleanValue("SendArtifactViaFormPost", false)) {
            LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
            controls.put("SAMLart", artifactString);
            HttpPostTemplate.doAutoPost(relayState, controls, endpoint, request, response);
        } else {
            HashMap<String, String> queryParams = new HashMap<String, String>(4);
            queryParams.put("SAMLart", artifactString);
            queryParams.put("RelayState", relayState);
            response.sendRedirect(Util.appendQueryParams(endpoint, queryParams));
        }
    }

    @Override
    public InMessageContext doReceive(HttpServletRequest request, HttpServletResponse response, InMessageContext inMsgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        XmlObject content;
        InMessageContext artRespMsgCtx;
        String artifactString = request.getParameter("SAMLart");
        inMsgCtx.setParam("SAMLart", artifactString);
        Artifact artifact = Artifact.parse(artifactString);
        ArtifactResolveDocument artifactResolveDoc = ArtifactResolveDocument.Factory.newInstance();
        ArtifactResolveType artifactResolveType = this.generateArtifactResolve(artifactString, artifactResolveDoc);
        String partnerEntityId = this.metadataDirectory.getEntityId(artifact.getSourceId(), Protocol.SAML20);
        inMsgCtx.setEntityId(partnerEntityId);
        int endpointIdx = artifact.getEndpointIndex();
        OutMessageContext artReqMsgCtx = new OutMessageContext(inMsgCtx.getRoleType());
        artReqMsgCtx.setEntityId(partnerEntityId);
        ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(artReqMsgCtx);
        String virtualServerId = VirtualIdentityUtil.resolve(connection, request).getVirtualEntityId(DomainMode.RUNTIME);
        inMsgCtx.setVirtualServerId(virtualServerId);
        RequestAbstractTypeUtil.setDefaults((RequestAbstractType)artifactResolveType, virtualServerId);
        Endpoint artifactResolutionService = connection.getArtifactResolutionService(endpointIdx);
        if (artifactResolutionService == null) {
            throw new ProcessRuntimeException("Unable to find an artifact resolution service with index of " + endpointIdx + " for (" + inMsgCtx.getRoleType() + ") " + partnerEntityId + ". Configured ARSs:" + connection.getArtifactResolutionServices().getEndpointsMap());
        }
        artReqMsgCtx.setXmlObject((XmlObject)artifactResolveDoc);
        artReqMsgCtx.setEndpoint(artifactResolutionService.getFullLocation());
        artReqMsgCtx.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        try (TimerScope ignored = this.getTimerScope(connection);){
            artRespMsgCtx = this.artifactSupport.resolve(request, response, artReqMsgCtx);
        }
        catch (IOException e) {
            Meters.getCounter("connection.ars.errors", "connection.id", connection.getEntityId()).increment();
            throw e;
        }
        ArtifactResponseDocument artifactResponseDocument = (ArtifactResponseDocument)artRespMsgCtx.getXmlObject();
        ArtifactResponseType artifactRespType = artifactResponseDocument.getArtifactResponse();
        try {
            content = ArtifactResponseTypeUtil.getContent(artifactRespType);
            if (content == null) {
                throw new BindingException("Artifact Response contains no additional SAML message: " + artRespMsgCtx);
            }
        }
        catch (XmlException e) {
            throw new BindingException("Unable to get SAML2 message from artifact response: " + artRespMsgCtx, e);
        }
        inMsgCtx.setXmlObject(content);
        this.signatureSvc.verifyXmlSignature(inMsgCtx, false);
        return inMsgCtx;
    }

    protected ArtifactResolveType generateArtifactResolve(String artifactString, ArtifactResolveDocument artifactResolveDoc) {
        ArtifactResolveType artifactResolveType = artifactResolveDoc.addNewArtifactResolve();
        artifactResolveType.setArtifact(artifactString);
        return artifactResolveType;
    }

    @Override
    public String getUri() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    private TimerScope getTimerScope(ConnectionBase connection) {
        if (!(connection instanceof IdpConnection)) {
            return TimerScope.empty();
        }
        return Meters.getTimerScope("connection.ars", "connection.id", connection.getEntityId());
    }
}

