/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.bindings.AbstractAsyncPassByValueBinding;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.DestinationBindingException;
import org.sourceid.saml20.bindings.HttpPostTemplate;
import org.sourceid.saml20.protocol.GeneralXmlUtil;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

class HttpPostBinding
extends AbstractAsyncPassByValueBinding
implements Binding {
    HttpPostBinding() {
    }

    @Override
    public void transport(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx, boolean messageIsRequest, boolean sign) throws IOException, BindingException {
        String actionUrl = msgCtx.getEndpoint();
        String relayState = msgCtx.getRelayState();
        XmlObject xmlObj = msgCtx.getXmlObject();
        if (sign) {
            this.signatureSvc.signXml(msgCtx);
            if (GeneralXmlUtil.getDestination(xmlObj) == null) {
                throw new DestinationBindingException("The outgoing message is signed but the destination is not set");
            }
        }
        LinkedHashMap<String, String> formControls = new LinkedHashMap<String, String>();
        byte[] bytes = XmlBeansUtil.xmlText(xmlObj).getBytes("UTF-8");
        String b64Xml = B64.encode((byte[])bytes);
        String key = messageIsRequest ? "SAMLRequest" : "SAMLResponse";
        formControls.put(key, b64Xml);
        HttpPostTemplate.doAutoPost(relayState, formControls, actionUrl, req, resp);
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, String b64encodedMsg, InMessageContext inMsgCtx) throws BindingException, IOException {
        byte[] bytes = B64.decodeToBytes((String)b64encodedMsg);
        String xmlString = new String(bytes, "UTF-8");
        this.parseXmlSetUpCtx(request, inMsgCtx, xmlString, b64encodedMsg);
        this.signatureSvc.verifyXmlSignature(inMsgCtx, true);
        return inMsgCtx;
    }

    @Override
    public String getUri() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }
}

