/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.QueryStringSignatureUtil;
import org.sourceid.saml20.bindings.AbstractAsyncPassByValueBinding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.util.Encoder;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

class HttpRedirectBinding
extends AbstractAsyncPassByValueBinding {
    private final Encoder encoder = new Encoder();

    HttpRedirectBinding() {
    }

    @Override
    public void transport(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx, boolean messageIsRequest, boolean sign) throws IOException, BindingException {
        String actionUrl = msgCtx.getEndpoint();
        String relaySt = msgCtx.getRelayState();
        XmlObject xmlObj = msgCtx.getXmlObject();
        String queryStr = this.createRedirectQueryString(messageIsRequest, xmlObj, relaySt);
        if (sign) {
            QueryStringSignatureUtil.SignedQuery signedQuery = this.signatureSvc.signQuery(msgCtx, queryStr);
            queryStr = signedQuery.getSignedQueryString();
        }
        char querySeparator = actionUrl.indexOf(63) == -1 ? (char)'?' : '&';
        String url = actionUrl + querySeparator + queryStr;
        resp.sendRedirect(url);
    }

    String createRedirectQueryString(boolean messageIsRequest, XmlObject xmlObj, String relaySt) throws UnsupportedEncodingException {
        String msgParamName = messageIsRequest ? "SAMLRequest" : "SAMLResponse";
        StringBuilder sb = new StringBuilder(msgParamName);
        String msg = XmlBeansUtil.xmlText(xmlObj);
        String encodedMsg = URLEncoder.encode(this.encoder.encodeSAMLMessage(msg), "UTF-8");
        sb.append("=").append(encodedMsg);
        if (!StringUtils.isBlank((String)relaySt)) {
            sb.append("&").append("RelayState").append("=").append(URLEncoder.encode(relaySt, "UTF-8"));
        }
        return sb.toString();
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, String b64encodedMsg, InMessageContext inMsgCtx) throws IOException, BindingException, HttpStatusCodeException {
        String queryStr = request.getQueryString();
        String xmlString = this.encoder.decodeSAMLMessage(b64encodedMsg);
        this.parseXmlSetUpCtx(request, inMsgCtx, xmlString, b64encodedMsg);
        this.signatureSvc.verifyQuerySignature(inMsgCtx, queryStr);
        return inMsgCtx;
    }

    @Override
    public String getUri() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }
}

