/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class RelayStateSupport {
    private static final Logger log = LoggerFactory.getLogger(RelayStateSupport.class);
    private final ConfigStore configStore;

    public RelayStateSupport() {
        this.configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.bindings.RelayStateSupport");
    }

    public RelayStateSupport(ConfigStore configStore) {
        this.configStore = configStore;
    }

    public void associate(OutMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, boolean includeSessionId) {
        String relayState = IDGenerator.rndAlphaNumeric(30);
        ctx.setRelayState(relayState);
        State state = new State();
        state.setOutMsgCtx(ctx);
        if (includeSessionId) {
            state.setPrimarySessionId(StateMgmtFactory.getLocalSessionId(req, resp));
        }
        StateMgmtFactory.saveState(req, resp, relayState, state);
    }

    public void lookupAssociation(InMessageContext ctx, String relayState, HttpServletRequest req, HttpServletResponse resp) throws RenderPageException {
        State state;
        ctx.setRelayState(relayState);
        if (!ctx.isRequest() && (state = StateMgmtFactory.retrieveAndRemoveState(relayState, false, req, resp)) != null) {
            if (this.isSkipRelayStateSessionVerification()) {
                log.debug("Skipping relay state session verification as configured.");
            } else if (state.getPrimarySessionId() != null && !StringUtils.equals((String)state.getPrimarySessionId(), (String)StateMgmtFactory.getLocalSessionId(req, resp))) {
                throw new ProcessRuntimeException("Saved state for relay state '" + relayState + "' belongs to a different browser session");
            }
            OutMessageContext reqMsgCtx = state.getOutMsgCtx();
            if (reqMsgCtx != null) {
                if (StringUtils.equals((String)relayState, (String)reqMsgCtx.getRelayState())) {
                    ctx.setOriginalRequestCtx(reqMsgCtx);
                } else if (log.isDebugEnabled()) {
                    log.debug("discarding saved state b/c relay state '" + reqMsgCtx.getRelayState() + "'  does not match inbound message relay state '" + relayState + "'");
                }
            }
        }
    }

    public void associateUsingSessionId(OutMessageContext ctx, HttpServletRequest req, HttpServletResponse resp) {
        State state = new State();
        state.setOutMsgCtx(ctx);
        String id = this.getSessionIdfakeRelayState(req, resp);
        ctx.setRelayState(id);
        StateMgmtFactory.saveState(req, resp, id, state);
    }

    private String getSessionIdfakeRelayState(HttpServletRequest req, HttpServletResponse resp) {
        Object spLocalSessionId = StateMgmtFactory.getLocalSessionId(req, resp);
        spLocalSessionId = "pf:::" + (String)spLocalSessionId;
        return spLocalSessionId;
    }

    public void lookupAssociationViaSessionId(InMessageContext ctx, HttpServletRequest request, HttpServletResponse resp) throws RenderPageException {
        String id = this.getSessionIdfakeRelayState(request, resp);
        this.lookupAssociation(ctx, id, request, resp);
    }

    private boolean isSkipRelayStateSessionVerification() {
        return this.configStore.getBooleanValue("skipRelayStateSessionVerification", false);
    }
}

