/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlIDUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.soap.InvalidRequestException;
import org.sourceid.common.soap.soap11.SoapEndpointUtility;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.liberty.xmlbinding.paos.v1dot1.RequestDocument;
import org.sourceid.liberty.xmlbinding.paos.v1dot1.ResponseType;
import org.sourceid.protocol.soap11.xml.Body;
import org.sourceid.protocol.soap11.xml.Envelope;
import org.sourceid.protocol.soap11.xml.EnvelopeDocument;
import org.sourceid.protocol.soap11.xml.Header;
import org.sourceid.protocol.soap11.xml.MustUnderstandAttribute;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.RelayStateSupport;
import org.sourceid.saml20.bindings.SoapBinding;
import org.sourceid.saml20.bindings.SoapBindingWrappedException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.protocol.GeneralXmlUtil;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.SignaturePolicy;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.ecp.RelayStateDocument;
import org.sourceid.saml20.xmlbinding.ecp.RelayStateType;
import org.sourceid.saml20.xmlbinding.ecp.RequestDocument;
import org.sourceid.saml20.xmlbinding.ecp.RequestType;
import org.sourceid.saml20.xmlbinding.protocol.IDPEntryType;
import org.sourceid.saml20.xmlbinding.protocol.IDPListType;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class ReverseHttpSoapBinding
implements Binding {
    public static final String ACCEPT_HEADER_NAME = "Accept";
    public static final String ACCEPT_HEADER_VALUE = "application/vnd.paos+xml";
    public static final String PAOS_HEADER_NAME = "PAOS";
    public static final String PAOS_HEADER_VALUE = "urn:liberty:paos:2003-08";
    public static final String ECP_SERVICE_VAL = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp";
    public static final String ACTOR = "http://schemas.xmlsoap.org/soap/actor/next";
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private final MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
    private RelayStateSupport relayStateSupport = new RelayStateSupport();
    public static final MustUnderstandAttribute.MustUnderstand MUST_UNDERSTAND_1 = MustUnderstandAttribute.MustUnderstand.Factory.newInstance();

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException {
        boolean signMessage;
        this.relayStateSupport.associate(msgCtx, req, resp, false);
        RelayStateDocument ecpRelayStDoc = RelayStateDocument.Factory.newInstance();
        RelayStateType ecpRelayStateType = ecpRelayStDoc.addNewRelayState();
        ecpRelayStateType.setActor(ACTOR);
        ecpRelayStateType.xsetMustUnderstand(MUST_UNDERSTAND_1);
        ecpRelayStateType.setStringValue(msgCtx.getRelayState());
        SignaturePolicy sigPolicy = msgCtx.getSignaturePolicy();
        boolean bl = signMessage = sigPolicy == SignaturePolicy.BINDING_DEFAULT || sigPolicy == SignaturePolicy.SIGN;
        if (signMessage) {
            SignatureEngine dsigSvc = GlobalRegistry.getService(SignatureEngine.class);
            dsigSvc.signXml(msgCtx);
        }
        resp.setContentType(ACCEPT_HEADER_VALUE);
        EnvelopeDocument soapEnvelopeDoc = EnvelopeDocument.Factory.newInstance();
        Envelope envelope = soapEnvelopeDoc.addNewEnvelope();
        Body body = envelope.addNewBody();
        body.set(msgCtx.getXmlObject());
        org.sourceid.liberty.xmlbinding.paos.v1dot1.RequestDocument paosRequestDoc = RequestDocument.Factory.newInstance();
        org.sourceid.liberty.xmlbinding.paos.v1dot1.RequestType paosRequestType = paosRequestDoc.addNewRequest();
        IndexedEndpoints acss = this.metadataLocal.getAssertionConsumerServices();
        MetadataImportExportUtil.setAbsoluteUrls(acss, this.metadataLocal.getPathUtil());
        Endpoint defaultAcs = acss.getDefault();
        String location = defaultAcs.getLocation();
        paosRequestType.setResponseConsumerURL(location);
        paosRequestType.setService(ECP_SERVICE_VAL);
        paosRequestType.setActor(ACTOR);
        paosRequestType.xsetMustUnderstand(MUST_UNDERSTAND_1);
        paosRequestType.setMessageID(XmlIDUtil.createID());
        RequestDocument ecpRequestDoc = RequestDocument.Factory.newInstance();
        RequestType ecpRequestType = ecpRequestDoc.addNewRequest();
        NameIDType issuer = ecpRequestType.addNewIssuer();
        String myEntityId = VirtualIdentityUtil.resolve(msgCtx).getVirtualEntityId(DomainMode.RUNTIME);
        issuer.setStringValue(myEntityId);
        ecpRequestType.setActor(ACTOR);
        ecpRequestType.xsetMustUnderstand(MUST_UNDERSTAND_1);
        ecpRequestType.setIsPassive(false);
        if (this.config.getBooleanValue("IncludeIDPList", true)) {
            IDPListType idpListType = ecpRequestType.addNewIDPList();
            String loc = msgCtx.getEndpoint();
            String entityId = msgCtx.getEntityId();
            this.addIdp(idpListType, entityId, loc);
        }
        Header header = envelope.addNewHeader();
        XmlBeansUtil.setChildren((XmlObject)header, new XmlObject[]{paosRequestType, ecpRequestType, ecpRelayStateType});
        XmlBeansUtil.save((XmlObject)soapEnvelopeDoc, (OutputStream)resp.getOutputStream());
        return null;
    }

    private void addIdp(IDPListType idpListType, String entityId, String loc) {
        IDPEntryType idpEntryType = idpListType.addNewIDPEntry();
        idpEntryType.setProviderID(entityId);
        idpEntryType.setLoc(loc);
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException {
        throw new UnsupportedOperationException("PAOS not used to transport outbound response messages");
    }

    @Override
    public InMessageContext receive(HttpServletRequest req, HttpServletResponse resp, Role partnerRole) throws IOException, BindingException, RenderPageException {
        InMessageContext inMsgCtx = new InMessageContext(partnerRole);
        String relayState = null;
        try {
            XmlObject protocolMessage = SoapEndpointUtility.getProtocolMessage(req);
            XmlObject xmlObjectDoc = XmlBeansUtil.wrapTypeInDocument(protocolMessage);
            inMsgCtx.setXmlObject(xmlObjectDoc);
            List<XmlObject> headerMessages = SoapEndpointUtility.getHeaderMessages(req);
            ResponseType responseType = null;
            RelayStateType relayStateType = null;
            for (XmlObject header : headerMessages) {
                if (header instanceof ResponseType) {
                    responseType = (ResponseType)header;
                    continue;
                }
                if (!(header instanceof RelayStateType)) continue;
                relayStateType = (RelayStateType)header;
            }
            if (responseType != null) {
                XmlBeansUtil.validate(responseType);
                if (!responseType.getMustUnderstand()) {
                    throw new BindingException("Core 4.2.4.5: The value of mustUnderstand MUST be 1 (true)");
                }
                String actor = responseType.getActor();
                if (!ACTOR.equals(actor)) {
                    throw new BindingException("Core 4.2.4.5: " + actor + " found as value for actor but it MUST be http://schemas.xmlsoap.org/soap/actor/next");
                }
            }
            if (relayStateType != null) {
                relayState = relayStateType.getStringValue();
            }
        }
        catch (InvalidRequestException e) {
            throw new SoapBindingWrappedException(e, SoapEndpointUtility.CLIENT_FAULT_CODE);
        }
        catch (InvalidXmlException | XmlException xe) {
            throw new BindingException(xe);
        }
        if (StringUtils.isBlank((String)relayState)) {
            String msg = "If the service provider included an <ecp:RelayState> SOAP header block in its request to the ECP then the ECP MUST include an identical header block with the SAML response sent to the service provider.";
            throw new BindingException(msg);
        }
        RelayStateSupport relayStateSupport = new RelayStateSupport();
        relayStateSupport.lookupAssociation(inMsgCtx, relayState, req, resp);
        String issuer = GeneralXmlUtil.getIssuer(inMsgCtx.getXmlObject());
        inMsgCtx.setEntityId(issuer);
        String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, req).getVirtualEntityId(DomainMode.RUNTIME);
        inMsgCtx.setVirtualServerId(virtualServerId);
        SignatureEngine dsigSvc = GlobalRegistry.getService(SignatureEngine.class);
        dsigSvc.verifyXmlSignature(inMsgCtx, true);
        return inMsgCtx;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException {
        new SoapBinding().handleException(req, resp, e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public String getUri() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:PAOS";
    }

    @Override
    public boolean isEntityIdRequired() {
        return true;
    }

    static {
        MUST_UNDERSTAND_1.setStringValue("1");
    }
}

