/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveDirectoryGroupLookupValidatorResult {
    private static Log log = LogFactory.getLog(ActiveDirectoryGroupLookupValidatorResult.class);
    public static final String GROUP_NOT_FOUND = "Group not found";
    public static final String MEMBER_NOT_FOUND = "Member not found";
    public static final String SOCKET_TIMEOUT = "Connection to %s timed out";
    public static final String GROUP_DN_IN_USE = "Group already exists";
    public static final String ENTRY_EXISTS = "Group exists";
    public static final String LDAP_ADMIN_INSUFFICIENT_RIGHTS = "Active Directory Admin User has insufficient rights to execute '%s'";
    private static final Pattern pattern = Pattern.compile(".*?LDAP: error code (\\d+) - (\\p{XDigit}+).*?data (\\p{XDigit}+).*", 32);
    private static final Pattern patternTwo = Pattern.compile("\\d+");

    public static String getByExplanation(String explanation) {
        explanation = explanation == null ? "" : explanation;
        Matcher matcher = pattern.matcher(explanation);
        Matcher matcherTwo = patternTwo.matcher(explanation);
        String errorCode = "";
        String errorSubCode = "";
        String dataCode = "";
        if (matcher.matches() && matcher.groupCount() > 0) {
            errorCode = matcher.group(1);
            errorSubCode = matcher.group(2);
            dataCode = matcher.group(3);
        } else if (matcherTwo.find()) {
            errorCode = matcherTwo.group();
        } else {
            if (explanation.contains("SocketTimeoutException") || explanation.contains("UnknownHostException")) {
                return SOCKET_TIMEOUT;
            }
            log.debug((Object)("Unable to parse LDAP return code from explanation: " + explanation));
        }
        switch (errorCode) {
            case "32": {
                switch (errorSubCode) {
                    case "0000208D": {
                        return GROUP_NOT_FOUND;
                    }
                }
                return MEMBER_NOT_FOUND;
            }
            case "50": {
                switch (errorSubCode) {
                    case "00000005": 
                    case "00002098": {
                        return LDAP_ADMIN_INSUFFICIENT_RIGHTS;
                    }
                }
            }
            case "68": {
                switch (errorSubCode) {
                    case "00002071": {
                        return GROUP_DN_IN_USE;
                    }
                    case "00000524": {
                        return ENTRY_EXISTS;
                    }
                }
            }
        }
        return ActiveDirectoryGroupLookupValidatorResult.trimADErrorMessage(explanation);
    }

    public static String trimADErrorMessage(String message) {
        String withoutSquareBrackets = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)message, (String)"["), (String)"]");
        return withoutSquareBrackets.trim();
    }
}

