/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.LDAPPasswordCredentialValidatorResult;

public class ActiveDirectoryPasswordCredentialValidatorResult
extends LDAPPasswordCredentialValidatorResult {
    private static final long serialVersionUID = 20121119L;
    private static Log log = LogFactory.getLog(ActiveDirectoryPasswordCredentialValidatorResult.class);
    private static final Pattern pattern = Pattern.compile(".*?LDAP: error code (\\d+) - (\\p{XDigit}+).*?data (\\p{XDigit}+).*", 32);

    private ActiveDirectoryPasswordCredentialValidatorResult(String explanation, AuthenticationResultEnum resultEnum) {
        super(explanation, resultEnum);
    }

    static ActiveDirectoryPasswordCredentialValidatorResult getByExplanation(String explanation) {
        explanation = explanation == null ? "" : explanation;
        Matcher matcher = pattern.matcher(explanation);
        String errorCode = "";
        String errorSubCode = "";
        String dataCode = "";
        if (matcher.matches() && matcher.groupCount() > 0) {
            errorCode = matcher.group(1);
            errorSubCode = matcher.group(2);
            dataCode = matcher.group(3);
        } else {
            log.debug((Object)("Unable to parse LDAP return code from explanation: " + explanation));
        }
        AuthenticationResultEnum resultEnum = null;
        switch (errorCode) {
            case "49": {
                switch (dataCode) {
                    case "525": {
                        resultEnum = AuthenticationResultEnum.USER_NOT_FOUND;
                        break;
                    }
                    case "52e": {
                        resultEnum = AuthenticationResultEnum.INVALID_CREDENTIALS;
                        break;
                    }
                    case "530": {
                        resultEnum = AuthenticationResultEnum.NOT_PERMITTED_TO_LOGON_AT_THIS_TIME;
                        break;
                    }
                    case "531": {
                        resultEnum = AuthenticationResultEnum.NOT_PERMITTED_TO_LOGON_AT_THIS_WORKSTATION;
                        break;
                    }
                    case "532": {
                        resultEnum = AuthenticationResultEnum.PASSWORD_EXPIRED;
                        break;
                    }
                    case "533": {
                        resultEnum = AuthenticationResultEnum.ACCOUNT_DISABLED;
                        break;
                    }
                    case "701": {
                        resultEnum = AuthenticationResultEnum.ACCOUNT_EXPIRED;
                        break;
                    }
                    case "773": {
                        resultEnum = AuthenticationResultEnum.USER_MUST_RESET_PASSWORD;
                        break;
                    }
                    case "775": {
                        resultEnum = AuthenticationResultEnum.USER_ACCOUNT_LOCKED;
                    }
                }
                break;
            }
            case "53": {
                switch (errorSubCode) {
                    case "0000052D": {
                        resultEnum = AuthenticationResultEnum.PASSWORD_POLICY_VIOLATED;
                    }
                }
                break;
            }
            case "19": {
                resultEnum = AuthenticationResultEnum.PASSWORD_POLICY_VIOLATED;
            }
        }
        if (resultEnum == null) {
            resultEnum = AuthenticationResultEnum.getDefaultValue();
            log.debug((Object)("Unknown response from Active Directory server: " + explanation + ".  Using default value: '" + resultEnum.getMessageKey() + "'."));
        }
        return new ActiveDirectoryPasswordCredentialValidatorResult(explanation, resultEnum);
    }
}

