/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveDirectoryUserLookupValidatorResult {
    private static Log log = LogFactory.getLog(ActiveDirectoryUserLookupValidatorResult.class);
    public static final String USER_NOT_FOUND = "User not found";
    public static final String SOCKET_TIMEOUT = "Connection to %s timed out";
    public static final String USER_DN_IN_USE = "User already exists";
    public static final String ENTRY_EXISTS = "User exists";
    public static final String LDAP_ADMIN_INSUFFICIENT_RIGHTS = "Active Directory Admin User has insufficient rights to execute '%s'";
    private static final Pattern pattern = Pattern.compile(".*?LDAP: error code (\\d+) - (\\p{XDigit}+).*?data (\\p{XDigit}+).*", 32);

    public static String getByExplanation(String explanation) {
        explanation = explanation == null ? "" : explanation;
        Matcher matcher = pattern.matcher(explanation);
        String errorCode = "";
        String errorSubCode = "";
        String dataCode = "";
        if (matcher.matches() && matcher.groupCount() > 0) {
            errorCode = matcher.group(1);
            errorSubCode = matcher.group(2);
            dataCode = matcher.group(3);
        } else {
            if (explanation.contains("SocketTimeoutException") || explanation.contains("UnknownHostException")) {
                return SOCKET_TIMEOUT;
            }
            log.debug((Object)("Unable to parse LDAP return code from explanation: " + explanation));
        }
        switch (errorCode) {
            case "32": {
                switch (errorSubCode) {
                    case "0000208D": {
                        return USER_NOT_FOUND;
                    }
                }
                break;
            }
            case "50": {
                switch (errorSubCode) {
                    case "00000005": 
                    case "00002098": {
                        return LDAP_ADMIN_INSUFFICIENT_RIGHTS;
                    }
                }
            }
            case "68": {
                switch (errorSubCode) {
                    case "00002071": {
                        return USER_DN_IN_USE;
                    }
                    case "00000524": {
                        return ENTRY_EXISTS;
                    }
                }
            }
        }
        return ActiveDirectoryUserLookupValidatorResult.trimADErrorMessage(explanation);
    }

    public static String trimADErrorMessage(String message) {
        String withoutSquareBrackets = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)message, (String)"["), (String)"]");
        return withoutSquareBrackets.trim();
    }
}

