/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import org.sourceid.saml20.domain.ConfigAbstract;

public class Affiliation
extends ConfigAbstract {
    private static final long serialVersionUID = 20050515L;
    private String affiliationId;
    private String affiliationOwnerId;
    private List<String> members = new ArrayList<String>();
    private boolean isActive;
    private Calendar lastModified = null;
    public static Comparator<Affiliation> ALPHABETICAL = new Comparator<Affiliation>(){

        @Override
        public int compare(Affiliation affiliation1, Affiliation affiliation2) {
            return affiliation1.getAffiliationId().compareTo(affiliation2.getAffiliationId());
        }
    };
    public static Comparator<Affiliation> COMPARE_BY_LAST_MODIFIED = new Comparator<Affiliation>(){

        @Override
        public int compare(Affiliation affiliation1, Affiliation affiliation2) {
            int retV = affiliation1.getLastModified() == null ? -1 : (affiliation2.getLastModified() == null ? 1 : affiliation1.getLastModified().compareTo(affiliation2.getLastModified()) * -1);
            return retV;
        }
    };

    public void addMember(String member) {
        if (member != null && !this.members.contains(member)) {
            this.members.add(member);
        }
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public String getAffiliationId() {
        return this.affiliationId;
    }

    public void setAffiliationId(String affiliationId) {
        this.affiliationId = affiliationId;
    }

    public String getAffiliationOwnerId() {
        return this.affiliationOwnerId;
    }

    public void setAffiliationOwnerId(String affiliationOwnerId) {
        this.affiliationOwnerId = affiliationOwnerId;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }
}

