/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.crypto.HashedPassword;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;

public class AppAuthMap {
    private static final String IS_ACTIVE = "isActive";
    private static final String ID = "id";
    private static final String SHARED_SECRET = "sharedSecret";
    private static final String CONFIRM_SHARED_SECRET = "confirmSharedSecret";
    private final Map<String, String> appAuthMap = new HashMap<String, String>();

    public AppAuthMap(Map<String, String> map) {
        this.appAuthMap.putAll(map);
    }

    public Map<String, String> getAppAuthMap() {
        return Collections.unmodifiableMap(this.appAuthMap);
    }

    public boolean authenticate(String id, String sharedSecret) {
        boolean validated;
        block4: {
            validated = false;
            if (id != null && sharedSecret != null && this.getId() != null && this.getId().equalsIgnoreCase(id)) {
                try {
                    HashedPassword hashedPassword = HashedPassword.fromEncodedText(this.getSharedSecret());
                    if (hashedPassword != null && hashedPassword.checkSecret(sharedSecret)) {
                        validated = true;
                    }
                }
                catch (IllegalArgumentException e) {
                    String inSecretHashVal = HashUtil.hashToHexString((String)sharedSecret, (HashAlgorithm)HashAlgorithm.SHA1);
                    String expectedSecretHashVal = this.appAuthMap.get(SHARED_SECRET);
                    if (!StringUtils.equalsIgnoreCase((String)this.getId(), (String)id) || !StringUtils.equalsIgnoreCase((String)expectedSecretHashVal, (String)inSecretHashVal)) break block4;
                    validated = true;
                }
            }
        }
        return validated;
    }

    public boolean isActive() {
        return Boolean.parseBoolean(this.appAuthMap.get(IS_ACTIVE));
    }

    public void activate() {
        this.appAuthMap.put(IS_ACTIVE, Boolean.TRUE.toString());
    }

    public void deactivate() {
        this.appAuthMap.put(IS_ACTIVE, Boolean.FALSE.toString());
        this.setId("");
        this.setSharedSecret("");
        this.setConfirmSharedSecret("");
    }

    public String getId() {
        return this.appAuthMap.get(ID);
    }

    public void setId(String id) {
        this.appAuthMap.put(ID, id);
    }

    public String getSharedSecret() {
        return this.appAuthMap.get(SHARED_SECRET);
    }

    public void setSharedSecret(String sharedSecret) {
        if (sharedSecret != null && !sharedSecret.equals(this.appAuthMap.get(SHARED_SECRET))) {
            this.appAuthMap.put(SHARED_SECRET, sharedSecret);
        }
    }

    public String getConfirmSharedSecret() {
        return this.appAuthMap.get(CONFIRM_SHARED_SECRET);
    }

    public void setConfirmSharedSecret(String confirmSharedSecret) {
        if (confirmSharedSecret != null && !confirmSharedSecret.equals(this.appAuthMap.get(CONFIRM_SHARED_SECRET))) {
            this.appAuthMap.put(CONFIRM_SHARED_SECRET, confirmSharedSecret);
        }
    }
}

