/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.websso.Protocol;

public class AssertionAttributeContract
extends AttributeContract
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final transient ConfigStore config = ConfigStoreFarm.getConfig(AssertionAttributeContract.class);

    public AssertionAttributeContract() {
        super(AssertionAttributeContract.getAttrs(false, false, null));
    }

    public AssertionAttributeContract(boolean pseudonym, boolean isTransient) {
        super(AssertionAttributeContract.getAttrs(pseudonym, isTransient, null));
    }

    public AssertionAttributeContract(boolean pseudonym, boolean isTransient, Protocol protocol) {
        super(AssertionAttributeContract.getAttrs(pseudonym, isTransient, protocol));
    }

    private static Set<String> getAttrs(boolean pseudonym, boolean isTransient, Protocol protocol) {
        HashSet<String> immutableAttrs = new HashSet<String>();
        AssertionAttributeContract.checkDoAdd(AssertionMapKeys.getAuthnCtxKey(), immutableAttrs, false);
        AssertionAttributeContract.checkDoAdd(AssertionMapKeys.getAuthnInstantKey(), immutableAttrs, false);
        if (!pseudonym && !isTransient) {
            String nameId = Protocol.OIDC == protocol ? "sub" : AssertionMapKeys.getNameIdValueKey();
            AssertionAttributeContract.checkDoAdd(nameId, immutableAttrs, true);
            AssertionAttributeContract.checkDoAdd(AssertionMapKeys.getNameIdQualifierKey(), immutableAttrs, false);
            AssertionAttributeContract.checkDoAdd(AssertionMapKeys.getNameIdSpQualifierKey(), immutableAttrs, false);
            AssertionAttributeContract.checkDoAdd(AssertionMapKeys.getNameIdFormatKey(), immutableAttrs, false);
        }
        return immutableAttrs;
    }

    private static void checkDoAdd(String name, Set<String> attrs, boolean defaultAction) {
        if (config.getBooleanValue(name, defaultAction)) {
            attrs.add(name);
        }
    }
}

