/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SourceTypeString;

public class AttrMappingValue
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private SourceType type;
    private String value;
    private String delimiter = null;
    private Object parsedExpression;
    private String attributeSourceId;

    public AttrMappingValue(SourceType type, String value) {
        this.type = type;
        this.value = SourceType.NO_MAPPING.equals((Object)type) ? SourceType.NO_MAPPING.toString() : value;
    }

    public AttrMappingValue(SourceType type, String value, String delimiter, String attributeSourceId) {
        this.type = type;
        this.value = SourceType.NO_MAPPING.equals((Object)type) ? SourceType.NO_MAPPING.toString() : value;
        this.delimiter = delimiter;
        this.attributeSourceId = attributeSourceId;
    }

    public AttrMappingValue(AttrMappingValue src) {
        this(src.type, src.value, src.delimiter, src.attributeSourceId);
    }

    public String getValue() {
        return this.value;
    }

    public String getAttributeSourceId() {
        return this.attributeSourceId;
    }

    public void setAttributeSourceId(String attributeSourceId) {
        this.attributeSourceId = attributeSourceId;
    }

    public AttributeValue delimitValues(AttributeValue attrValue) {
        if (this.delimiter == null || this.delimiter.length() == 0 || attrValue == null) {
            return attrValue;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String val : attrValue.getValues()) {
            values.addAll(this.delimit(val));
        }
        if (Util.isEmpty(values)) {
            return attrValue;
        }
        AttributeValue newAttrValue = new AttributeValue(values);
        newAttrValue.setMasked(attrValue.isMasked());
        return newAttrValue;
    }

    private List<String> delimit(String val) {
        ArrayList<String> values = new ArrayList<String>();
        if (val != null) {
            StringTokenizer st = new StringTokenizer(val, this.delimiter);
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                nextToken = nextToken != null ? nextToken.trim() : null;
                if (StringUtils.isBlank((String)nextToken)) continue;
                values.add(nextToken);
            }
        }
        return values;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SourceType getType() {
        return this.type;
    }

    public void setType(SourceType type) {
        this.type = type;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getTypeString() {
        return SourceTypeString.getTypeString(this.type);
    }

    public void setType(String typeStr) {
        this.type = SourceTypeString.strToType(typeStr);
    }

    public Object getParsedExpression() {
        return this.parsedExpression;
    }

    public void setParsedExpression(Object parsedExpression) {
        this.parsedExpression = parsedExpression;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttrMappingValue that = (AttrMappingValue)o;
        return this.type == that.type && Objects.equals(this.value, that.value) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.attributeSourceId, that.attributeSourceId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value, this.delimiter, this.attributeSourceId});
    }
}

