/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.ConfigurationUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeContract
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private Set<String> immutableAttributeNames = new LinkedHashSet<String>();
    private Map<String, String> mutableAttributesInfo = new HashMap<String, String>();

    public AttributeContract() {
    }

    public AttributeContract(AttributeContract copy) {
        this.immutableAttributeNames = new LinkedHashSet<String>(copy.immutableAttributeNames);
        this.mutableAttributesInfo = new HashMap<String, String>(copy.mutableAttributesInfo);
    }

    public AttributeContract(Set<String> immutableAttributeNames) {
        this.immutableAttributeNames = immutableAttributeNames;
    }

    public void addMutableAttributeName(String attrName) {
        this.addMutableAttributeInfo(attrName, null);
    }

    public void removeMutableAttributeName(String attrName) {
        this.mutableAttributesInfo.remove(attrName);
    }

    public Set<String> getMutableAttributeNames() {
        return this.mutableAttributesInfo.keySet();
    }

    public void setMutableAttributeNames(Set<String> attributeNames) {
        this.mutableAttributesInfo = new HashMap<String, String>();
        for (String attributeName : attributeNames) {
            this.mutableAttributesInfo.put(attributeName, null);
        }
    }

    public List<String> getSortedMutableAttributeNames() {
        return this.sortSet(this.mutableAttributesInfo.keySet());
    }

    public Set<String> getImmutableAttributeNames() {
        return this.immutableAttributeNames;
    }

    public void setImmutableAttributeNames(Set<String> immutableAttributeNames) {
        this.immutableAttributeNames = immutableAttributeNames;
    }

    public List<String> getSortedImmutableAttributeNames() {
        return this.sortSet(this.immutableAttributeNames);
    }

    public Set<String> getAllAttributeNames() {
        LinkedHashSet<String> all = new LinkedHashSet<String>(this.immutableAttributeNames);
        all.addAll(this.mutableAttributesInfo.keySet());
        return all;
    }

    private List<String> sortSet(Set<String> stringset) {
        return ConfigurationUtil.sortSet(stringset);
    }

    public List<String> getAllAttrNamesSorted() {
        return this.sortSet(this.getAllAttributeNames());
    }

    public boolean isImmutable(String item) {
        return this.immutableAttributeNames.contains(item);
    }

    public boolean attributeExists(String item) {
        return this.immutableAttributeNames.contains(item) || this.mutableAttributesInfo.containsKey(item);
    }

    public boolean isEmpty() {
        return this.immutableAttributeNames.isEmpty() && this.mutableAttributesInfo.isEmpty();
    }

    public void addMutableAttributeInfo(String attrName, String attributeNameFormat) {
        if (!this.immutableAttributeNames.contains(attrName)) {
            this.mutableAttributesInfo.put(attrName, attributeNameFormat);
        }
    }

    public void updateMutableAttributeInfo(String attrName, String attributeNameFormat) {
        if (this.mutableAttributesInfo.containsKey(attrName)) {
            this.mutableAttributesInfo.put(attrName, attributeNameFormat);
        }
    }

    public String getMutableAttributeNameFormat(String attrName) {
        return this.mutableAttributesInfo.get(attrName);
    }

    public Map<String, String> getMutableAttributesInfo() {
        return this.mutableAttributesInfo;
    }

    public void setMutableAttributesInfo(Map<String, String> mutableAttributeInfo) {
        this.mutableAttributesInfo = new HashMap<String, String>();
        for (Map.Entry<String, String> attributeEntryInfo : mutableAttributeInfo.entrySet()) {
            this.mutableAttributesInfo.put(attributeEntryInfo.getKey(), attributeEntryInfo.getValue());
        }
    }
}

