/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.ognl.ExpressionCalculator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SourceTypeString;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriteria;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.util.log.AttributeMap;

public class AttributeMapping
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final Log log = LogFactory.getLog(AttributeMapping.class);
    public static final String DS_KEY_PREFIX = "ds.";
    public static final String MAPPED_ATTRIBUTES_PREFIX = "mapped.";
    private static final String ADAPTER_SOURCE_TYPE_KEY = "ad";
    public static final String ADAPTER_KEY_PREFIX = "ad.";
    private static final String IDP_CONN_SOURCE_TYPE_KEY = "idp";
    public static final String IDP_CONN_KEY_PREFIX = "idp.";
    public static final String LOCAL_IDENTITY_KEY = "localidentity";
    public static final String LOCAL_IDENTITY_PREFIX = "localidentity.";
    public static final String FRAGMENT_KEY = "fragment";
    public static final String FRAGMENT_PREFIX = "fragment.";
    public static final String CONTEXT_SOURCE_TYPE_KEY = "context";
    public static final String CONTEXT_KEY_PREFIX = "context.";
    public static final String DEPRECATED_EXTENDED_CLIENT_METADATA_KEY = "extclientmetadata";
    public static final String EXTENDED_CLIENT_METADATA_TYPE_KEY = "extproperties";
    public static final String EXTENDED_CLIENT_METADATA_KEY_PREFIX = "extproperties.";
    public static final String DEPRECATED_EXTENDED_CLIENT_METADTA_KEY_PREFIX = "extclientmetadata.";
    public static final String TRACKED_HTTP_PARAMS_TYPE_KEY = "trackedparams";
    public static final String TRACKED_HTTP_PARAMS_KEY_PREFIX = "trackedparams.";
    public static final String PERSISTENT_GRANT_PARAM_TYPE_KEY = "persistentgrant";
    public static final String PERSISTENT_GRANT_PARAM_KEY_PREFIX = "persistentgrant.";
    public static final String SUBJECT_TOKEN_SOURCE_KEY_TYPE = "subjecttoken";
    public static final String SUBJECT_TOKEN_PARAM_KEY_PREFIX = "subjecttoken.";
    public static final String ACTOR_TOKEN_SOURCE_KEY_TYPE = "actortoken";
    public static final String ACTOR_TOKEN_PARAM_KEY_PREFIX = "actortoken.";
    public static final String FRAGMENT_SOURCE_KEY_TYPE = "fragment";
    public static final String FRAGMENT_PARAM_KEY_PREFIX = "fragment.";
    public static final String INPUT_CONTRACT_KEY_TYPE = "inputs";
    public static final String INPUT_CONTRACT_KEY_PREFIX = "inputs.";
    private static final String PROBLEM_WITH_OGNL_MAPPING = "Problem with OGNL attribute mapping on ";
    private static final String NOT_AUTHORIZED_TO_MAP_OGNL = "OGNL expressions are turned off for Attribute Mapping.";
    private static final String ABORT_ON_ATTR_LOOKUP_FAILURE = "AbortOnAttrLookupFailure";
    private static ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.domain.AttributeMapping");
    protected List<AttributeSource> attributeSources = new ArrayList<AttributeSource>();
    protected Map<String, List<AttrMappingValue>> attributeMap = new HashMap<String, List<AttrMappingValue>>();
    protected TokenAuthorizationIssuanceCriteria tokenAuthorizationIssuanceCriteria = new TokenAuthorizationIssuanceCriteria();

    public AttributeMapping() {
    }

    public AttributeMapping(AttributeMapping other) {
        for (Map.Entry<String, List<AttrMappingValue>> entry : other.attributeMap.entrySet()) {
            ArrayList<AttrMappingValue> valueList = new ArrayList<AttrMappingValue>();
            for (AttrMappingValue srcVal : entry.getValue()) {
                valueList.add(new AttrMappingValue(srcVal));
            }
            this.attributeMap.put(entry.getKey(), valueList);
        }
        for (AttributeSource source : other.getAttributeSources()) {
            this.attributeSources.add(source);
        }
        this.tokenAuthorizationIssuanceCriteria = new TokenAuthorizationIssuanceCriteria(other.tokenAuthorizationIssuanceCriteria);
    }

    public String getDescription() {
        return this.attributeSources == null || this.attributeSources.isEmpty() ? "" : this.getAttributeSource().getDescription();
    }

    public AttributeSource getAttributeSource() {
        return this.attributeSources.isEmpty() ? null : this.attributeSources.get(0);
    }

    public List<AttributeSource> getAttributeSources() {
        return this.attributeSources;
    }

    public List<TokenAuthorizationIssuanceCriterion> getTokenAuthorizationIssuanceCriteria() {
        return this.tokenAuthorizationIssuanceCriteria.getTokenAuthorizationIssuanceCriteria();
    }

    public void setTokenAuthorizationIssuanceCriteria(List<TokenAuthorizationIssuanceCriterion> tokenAuthorizationIssuanceCriteria) {
        this.tokenAuthorizationIssuanceCriteria.setTokenAuthorizationIssuanceCriteria(tokenAuthorizationIssuanceCriteria);
    }

    public void addTokenAuthorizationIssuanceCriteria(TokenAuthorizationIssuanceCriterion tokenAuthorizationIssuanceCriterion) {
        this.tokenAuthorizationIssuanceCriteria.addTokenAuthorizationIssuanceCriterion(tokenAuthorizationIssuanceCriterion);
    }

    public void setAttributeSource(AttributeSource attributeSource) {
        if (attributeSource != null) {
            this.attributeSources = new ArrayList<AttributeSource>();
            this.attributeSources.add(attributeSource);
        } else {
            this.attributeSources = Collections.emptyList();
        }
    }

    public void addAttributeSource(AttributeSource attributeSource) {
        this.attributeSources.add(attributeSource);
    }

    @Deprecated
    public AttrMappingValue getAttributeMapping(String name) {
        AttrMappingValue attributeMappingVal = null;
        if (this.attributeMap.get(name) != null) {
            attributeMappingVal = this.attributeMap.get(name).get(0);
        }
        return attributeMappingVal;
    }

    public List<AttrMappingValue> getAttributeMappingValues(String name) {
        return this.attributeMap.get(name);
    }

    public void addAttributeMapping(String name, SourceType type, String value) {
        ArrayList<AttrMappingValue> valueList = new ArrayList<AttrMappingValue>();
        valueList.add(new AttrMappingValue(type, value));
        this.attributeMap.put(name, valueList);
    }

    public void addAttributeMapping(String name, String typeStr, String value) {
        ArrayList<AttrMappingValue> valueList = new ArrayList<AttrMappingValue>();
        valueList.add(new AttrMappingValue(SourceTypeString.strToType(typeStr), value));
        this.attributeMap.put(name, valueList);
    }

    public void putAttributeMapping(String name, List<AttrMappingValue> attrMappingValueList) {
        this.attributeMap.put(name, attrMappingValueList);
    }

    public void removeAttributeMapping(String name) {
        this.attributeMap.remove(name);
    }

    @Deprecated
    public Map<String, AttrMappingValue> getAttributeMap() {
        HashMap<String, AttrMappingValue> map = new HashMap<String, AttrMappingValue>();
        for (Map.Entry<String, List<AttrMappingValue>> entry : this.attributeMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().get(0));
        }
        return map;
    }

    public Map<String, List<AttrMappingValue>> getAttributeMapping() {
        return this.attributeMap;
    }

    @Deprecated
    public void setAttributeMap(Map<String, AttrMappingValue> attributeMap) {
        HashMap<String, List<AttrMappingValue>> tmpMap = new HashMap<String, List<AttrMappingValue>>();
        if (attributeMap != null) {
            for (Map.Entry<String, AttrMappingValue> stringAttrMappingValueEntry : attributeMap.entrySet()) {
                ArrayList<AttrMappingValue> valueList = new ArrayList<AttrMappingValue>();
                valueList.add(stringAttrMappingValueEntry.getValue());
                tmpMap.put(stringAttrMappingValueEntry.getKey(), valueList);
            }
        }
        this.attributeMap = tmpMap;
    }

    public void setAttributeMap2(Map<String, List<AttrMappingValue>> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public void updateMappingTargetName(String oldName, String newName) {
        if (this.attributeMap.containsKey(oldName)) {
            this.attributeMap.put(newName, this.attributeMap.remove(oldName));
        }
        this.tokenAuthorizationIssuanceCriteria.updateMappingTargetName(oldName, newName);
    }

    public void updateSourceValueName(SourceType sourceType, String oldName, String newName) {
        for (List<AttrMappingValue> mappingValues : this.attributeMap.values()) {
            for (AttrMappingValue mappingValue : mappingValues) {
                if (!sourceType.equals((Object)mappingValue.getType()) || !oldName.equals(mappingValue.getValue())) continue;
                mappingValue.setValue(newName);
            }
        }
        this.tokenAuthorizationIssuanceCriteria.updateSourceValueName(sourceType, oldName, newName);
    }

    private AttributeMap executeMapping(HashMap<String, AttributeMap> srcAttributesMap, Set<String> targetNames, boolean skipAuthorization, boolean forceAbortOnAttrLookupFailure) throws AttrLookupException, AuthorizationException {
        AttributeMap resultantMap = new AttributeMap();
        AttributeMap allAttributesFromDS = new AttributeMap();
        AttributeMap allAttributesFromDSCaseInsensitiveMap = new AttributeMap();
        this.addTargetResourceContextAttribute(srcAttributesMap);
        AttributeMap attrsAvailableForLookup = AttributeMapping.createSubstitutionAttributes(srcAttributesMap);
        if (this.attributeSources.isEmpty()) {
            resultantMap = this.translateMapping(srcAttributesMap, new AttributeMap(), new AttributeMap(), targetNames, attrsAvailableForLookup);
        } else {
            for (AttributeSource attrSource : this.attributeSources) {
                if (attrSource == null || DataSource.DSType.None.getName().equalsIgnoreCase(attrSource.getType())) continue;
                String attributeSourceId = attrSource.getId();
                SourceType dataSourceType = SourceTypeString.strToType(attrSource.getType());
                List<String> colNameList = this.getDatasourceAttributeList(dataSourceType, attributeSourceId);
                try {
                    AttributeMap attributesFromDS = attrSource.executeAttributeLookup(attrsAvailableForLookup, colNameList);
                    if (attributesFromDS.isEmpty()) {
                        log.debug((Object)("Data source look up for source id: " + attrSource.getId() + " returned an empty result set."));
                        continue;
                    }
                    for (Map.Entry entry : attributesFromDS.entrySet()) {
                        AttributeValue value = (AttributeValue)entry.getValue();
                        String attributeFromDSKey = this.constructDataSourceAttributeName((String)entry.getKey(), attributeSourceId);
                        if (DataSource.DSType.LDAP.getName().equalsIgnoreCase(attrSource.getType())) {
                            String attributeFromDSKeyLowerCase = this.constructDataSourceAttributeName(((String)entry.getKey()).toLowerCase(), attributeSourceId);
                            allAttributesFromDSCaseInsensitiveMap.put(attributeFromDSKeyLowerCase, value);
                        } else {
                            allAttributesFromDSCaseInsensitiveMap.put(attributeFromDSKey, value);
                        }
                        allAttributesFromDS.put(attributeFromDSKey, value);
                        attrsAvailableForLookup.put(DS_KEY_PREFIX + attributeFromDSKey, value);
                    }
                }
                catch (AttrLookupException e) {
                    if (!this.isAbortOnAttrLookupFailure() && !forceAbortOnAttrLookupFailure) {
                        this.logAttributeLookupError(attrSource.getId(), e);
                        continue;
                    }
                    throw e;
                }
                catch (Exception e2) {
                    if (!this.isAbortOnAttrLookupFailure() && !forceAbortOnAttrLookupFailure) {
                        this.logAttributeLookupError(attrSource.getId(), e2);
                        continue;
                    }
                    throw new AttrLookupException("Problem with attribute lookup", e2);
                }
            }
            if (!allAttributesFromDSCaseInsensitiveMap.isEmpty() || !this.isAbortOnAttrLookupFailure() && !forceAbortOnAttrLookupFailure) {
                resultantMap = this.translateMapping(srcAttributesMap, allAttributesFromDSCaseInsensitiveMap, allAttributesFromDS, targetNames, attrsAvailableForLookup);
            }
        }
        if (!skipAuthorization) {
            this.tokenAuthorizationIssuanceCriteria.checkCriteria(srcAttributesMap, resultantMap, allAttributesFromDS);
        }
        return resultantMap;
    }

    private void logAttributeLookupError(String attributeId, Exception exception) {
        String message = String.format("Problem with attribute lookup. Attribute source id: %s, error: %s", attributeId, ExceptionUtil.toStringWithCauses(exception));
        if (log.isDebugEnabled()) {
            log.warn((Object)message, (Throwable)exception);
        } else {
            log.warn((Object)message);
        }
    }

    public AttributeMap executeMapping(AttributeMap srcAttributes, Set<String> targetNames) throws AttrLookupException, AuthorizationException {
        return this.executeMapping(srcAttributes, targetNames, false, false);
    }

    public AttributeMap executeMapping(AttributeMap srcAttributes, Set<String> targetNames, AttributeMap contextMap) throws AttrLookupException, AuthorizationException {
        return this.executeMapping(srcAttributes, targetNames, contextMap, false, false);
    }

    public AttributeMap executeMapping(AttributeMap srcAttributes, Set<String> targetNames, AttributeMap contextMap, boolean skipAuthorization) throws AttrLookupException, AuthorizationException {
        return this.executeMapping(srcAttributes, targetNames, contextMap, skipAuthorization, false);
    }

    public AttributeMap executeMapping(AttributeMap srcAttributes, Set<String> targetNames, boolean skipAuthorization, boolean forceAbortOnAttrLookupFailure) throws AttrLookupException, AuthorizationException {
        HashMap<String, AttributeMap> attrMap = new HashMap<String, AttributeMap>();
        if (srcAttributes != null) {
            attrMap.put(null, srcAttributes);
        }
        return this.executeMapping(attrMap, targetNames, skipAuthorization, forceAbortOnAttrLookupFailure);
    }

    protected AttributeMap executeMapping(AttributeMap srcAttributes, Set<String> targetNames, AttributeMap contextMap, boolean skipAuthorization, boolean forceAbortOnAttrLookupFailure) throws AttrLookupException, AuthorizationException {
        HashMap<String, AttributeMap> attrMap = new HashMap<String, AttributeMap>();
        if (srcAttributes != null) {
            attrMap.put(null, srcAttributes);
        }
        if (contextMap != null) {
            attrMap.put(CONTEXT_SOURCE_TYPE_KEY, contextMap);
        }
        return this.executeMapping(attrMap, targetNames, skipAuthorization, forceAbortOnAttrLookupFailure);
    }

    public AttributeMap executeMapping(HashMap<String, AttributeMap> srcAttributesMap, Set<String> targetNames) throws AttrLookupException, AuthorizationException {
        return this.executeMapping(srcAttributesMap, targetNames, false, false);
    }

    protected void addTargetResourceContextAttribute(HashMap<String, AttributeMap> srcAttributeMaps) {
        AttributeValue val;
        AttributeMap defaultSrcAttrs = srcAttributeMaps.get(null);
        if (defaultSrcAttrs != null && (val = (AttributeValue)defaultSrcAttrs.get((Object)"TargetResource")) != null) {
            AttributeMap contextAttrs = this.getCreateContextSourceAttributes(srcAttributeMaps);
            contextAttrs.put(SourceContextType.TARGET_RESOURCE.getId(), val);
        }
    }

    private AttributeMap getCreateContextSourceAttributes(HashMap<String, AttributeMap> srcAttributeMaps) {
        AttributeMap contextSrcAttrs = srcAttributeMaps.get(CONTEXT_SOURCE_TYPE_KEY);
        if (contextSrcAttrs == null) {
            contextSrcAttrs = new AttributeMap();
            srcAttributeMaps.put(CONTEXT_SOURCE_TYPE_KEY, contextSrcAttrs);
        }
        return contextSrcAttrs;
    }

    boolean isAbortOnAttrLookupFailure() {
        return configStore.getBooleanValue(ABORT_ON_ATTR_LOOKUP_FAILURE, true);
    }

    public boolean hasExpressions() {
        if (this.attributeMap.size() > 0) {
            for (Map.Entry<String, List<AttrMappingValue>> entry : this.attributeMap.entrySet()) {
                for (AttrMappingValue attribVal : this.attributeMap.get(entry.getKey())) {
                    if (!SourceType.EXPRESSION.toString().equalsIgnoreCase(attribVal.getType().toString())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getAttrValueForDisplay(AttrMappingValue value) {
        return value.getValue();
    }

    protected AttributeMap translateMapping(HashMap<String, AttributeMap> srcAttributeMaps, AttributeMap attributesFromDSCaseInsensitive, AttributeMap attributesFromDS, Set<String> targetNames, AttributeMap substitutionTable) {
        AttributeMap resultantMap = new AttributeMap();
        Set maskedAttributeNames = null;
        for (Map.Entry<String, List<AttrMappingValue>> entry : this.attributeMap.entrySet()) {
            AttributeValue attributeValue = null;
            for (AttrMappingValue attribVal : entry.getValue()) {
                SourceType type = attribVal.getType();
                switch (type) {
                    case ADAPTER: 
                    case IDP_CONNECTION: 
                    case PASSWORD_CREDENTIAL_VALIDATOR: 
                    case TOKEN: 
                    case OPEN_ID_CONNECT_ACCESS_TOKEN: 
                    case REQUEST: 
                    case ASSERTION: 
                    case CLAIMS: 
                    case ACCOUNT_LINK: 
                    case OAUTH_PERSISTENT_GRANT: 
                    case SCIM_USER: 
                    case SCIM_GROUP: 
                    case IDENTITY_STORE_USER: 
                    case IDENTITY_STORE_GROUP: 
                    case AUTHENTICATION_POLICY_CONTRACT: 
                    case LOCAL_IDENTITY_PROFILE: 
                    case FRAGMENT: 
                    case INPUTS: 
                    case CONTEXT: 
                    case EXTENDED_CLIENT_METADATA: 
                    case EXTENDED_PROPERTIES: 
                    case TRACKED_HTTP_PARAMS: 
                    case TOKEN_EXCHANGE_PROCESSOR_POLICY: 
                    case SUBJECT_TOKEN: 
                    case ACTOR_TOKEN: {
                        String attributeSourceId = attribVal.getAttributeSourceId();
                        AttributeMap srcAttributes = srcAttributeMaps.get(AttributeMapping.createAttrSourceKey(type, attributeSourceId));
                        if (srcAttributes == null) break;
                        Object value = srcAttributes.get((Object)attribVal.getValue());
                        AttributeValue tmpAttributeValue = AttrValueSupport.make((Object)value);
                        attributeValue = this.mergeAttributeValues(attributeValue, tmpAttributeValue);
                        break;
                    }
                    case JDBC_DATA_STORE: 
                    case LDAP_DATA_STORE: 
                    case OTHER_DATA_STORE: {
                        String attribValueStr = SourceType.LDAP_DATA_STORE == type ? attribVal.getValue().toLowerCase() : attribVal.getValue();
                        String attrName = this.constructDataSourceAttributeName(attribValueStr, attribVal.getAttributeSourceId());
                        AttributeValue tmpAttributeValue2 = (AttributeValue)attributesFromDSCaseInsensitive.get((Object)attrName);
                        if (tmpAttributeValue2 == null) {
                            List empty = Collections.emptyList();
                            tmpAttributeValue2 = new AttributeValue(empty);
                        }
                        tmpAttributeValue2 = attribVal.delimitValues(tmpAttributeValue2);
                        attributeValue = this.mergeAttributeValues(attributeValue, tmpAttributeValue2);
                        break;
                    }
                    case TEXT: 
                    case ATTRIBUTE_QUERY: {
                        if (maskedAttributeNames == null) {
                            maskedAttributeNames = substitutionTable.getMaskedAttributeNames();
                        }
                        try {
                            String val = attribVal.getValue();
                            boolean mask = false;
                            if (!maskedAttributeNames.isEmpty()) {
                                Set refs = Substituter.parseReferences((String)val);
                                for (String ref : refs) {
                                    if (!maskedAttributeNames.contains(ref)) continue;
                                    mask = true;
                                    break;
                                }
                                if (!mask) {
                                    mask = maskedAttributeNames.contains(entry.getKey());
                                }
                            }
                            String subsitutedValue = Substituter.substituteValues(val, (Map)substitutionTable);
                            attributeValue = this.mergeAttributeValues(attributeValue, subsitutedValue);
                            if (!mask) break;
                            AttrValueSupport.setMasked((AttributeValue)attributeValue);
                        }
                        catch (Substituter.UnknownKeyException e) {
                            log.warn((Object)("Problem with Text attribute mapping on " + entry.getKey() + ". " + e));
                        }
                        break;
                    }
                    case EXPRESSION: {
                        ExpressionManager expressionManager = ExpressionManager.getInstance();
                        if (expressionManager.isEvaluateExpressionsOff()) {
                            log.warn((Object)NOT_AUTHORIZED_TO_MAP_OGNL);
                            break;
                        }
                        try {
                            AttributeMap srcAttrMap;
                            AttributeValue tmpAttributeValue3;
                            if (attribVal.getParsedExpression() == null) {
                                Object parsedExpression = Ognl.parseExpression((String)attribVal.getValue());
                                attribVal.setParsedExpression(parsedExpression);
                            }
                            HashMap simpleAttributeMap = new HashMap();
                            for (Map.Entry attributeValueEntry : substitutionTable.entrySet()) {
                                simpleAttributeMap.put((String)attributeValueEntry.getKey(), attributeValueEntry.getValue());
                            }
                            Object value = ExpressionCalculator.calculate(attribVal.getParsedExpression(), simpleAttributeMap, simpleAttributeMap);
                            if (value instanceof Collection) {
                                tmpAttributeValue3 = AttrValueSupport.make((Collection)((Collection)value));
                            } else {
                                if (value instanceof AttributeValue) {
                                    value = new AttributeValue((AttributeValue)value);
                                }
                                tmpAttributeValue3 = AttrValueSupport.make((Object)value);
                            }
                            boolean maskOgnlValues = false;
                            Iterator<AttributeMap> iterator = srcAttributeMaps.values().iterator();
                            while (iterator.hasNext() && !(maskOgnlValues = (srcAttrMap = iterator.next()).getMaskOgnlValues())) {
                            }
                            if (tmpAttributeValue3 != null && maskOgnlValues) {
                                tmpAttributeValue3.setMasked(true);
                            }
                            attributeValue = this.mergeAttributeValues(attributeValue, tmpAttributeValue3);
                        }
                        catch (OgnlException e) {
                            log.error((Object)(PROBLEM_WITH_OGNL_MAPPING + entry.getKey() + ". "), (Throwable)e);
                        }
                        break;
                    }
                }
            }
            resultantMap.put(entry.getKey(), attributeValue);
        }
        if (targetNames != null) {
            Iterator i = resultantMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (targetNames.contains(key)) continue;
                i.remove();
            }
        }
        this.logAttributes(resultantMap, srcAttributeMaps, attributesFromDS);
        return resultantMap;
    }

    public static String createAttrSourceKey(SourceType type, String attributeSourceId) {
        if (type == SourceType.TRACKED_HTTP_PARAMS) {
            return TRACKED_HTTP_PARAMS_TYPE_KEY;
        }
        if (type == SourceType.CONTEXT) {
            if (attributeSourceId != null) {
                return null;
            }
            return CONTEXT_SOURCE_TYPE_KEY;
        }
        if (type == SourceType.EXTENDED_PROPERTIES || type == SourceType.EXTENDED_CLIENT_METADATA) {
            if (attributeSourceId != null) {
                return null;
            }
            return CONTEXT_SOURCE_TYPE_KEY;
        }
        if (type == SourceType.SUBJECT_TOKEN) {
            return SUBJECT_TOKEN_SOURCE_KEY_TYPE;
        }
        if (type == SourceType.ACTOR_TOKEN) {
            return ACTOR_TOKEN_SOURCE_KEY_TYPE;
        }
        if (attributeSourceId != null) {
            if (type == SourceType.ADAPTER) {
                return ADAPTER_KEY_PREFIX + attributeSourceId;
            }
            if (type == SourceType.IDP_CONNECTION) {
                return IDP_CONN_KEY_PREFIX + attributeSourceId;
            }
            if (type == SourceType.LOCAL_IDENTITY_PROFILE) {
                return LOCAL_IDENTITY_PREFIX + attributeSourceId;
            }
            if (type == SourceType.INPUTS) {
                return "fragment." + attributeSourceId;
            }
            if (type == SourceType.FRAGMENT) {
                return "fragment." + attributeSourceId;
            }
        }
        return null;
    }

    protected void logAttributes(AttributeMap resultantMap, HashMap<String, AttributeMap> srcAttributesMap, AttributeMap attributesFromDS) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            if (srcAttributesMap.size() == 1) {
                sb.append("Source attributes:").append(srcAttributesMap.values().iterator().next());
            } else {
                sb.append("Source attributes:").append(srcAttributesMap);
            }
            if (!attributesFromDS.isEmpty()) {
                sb.append(" Attributes from Datasource:").append(attributesFromDS);
            }
            sb.append(" Resulting attributes:").append(resultantMap);
            log.debug((Object)sb);
        }
    }

    private AttributeValue mergeAttributeValues(AttributeValue attributeValue1, AttributeValue attributeValue2) {
        AttributeValue result;
        if (attributeValue1 == null) {
            result = attributeValue2;
        } else if (attributeValue2 == null) {
            result = attributeValue1;
        } else {
            ArrayList list = new ArrayList();
            list.addAll(attributeValue1.getValuesAsCollection());
            list.addAll(attributeValue2.getValuesAsCollection());
            result = new AttributeValue(list);
            if (attributeValue1.isMasked() || attributeValue2.isMasked()) {
                result.setMasked(true);
            }
        }
        return result;
    }

    private AttributeValue mergeAttributeValues(AttributeValue attributeValue1, String value) {
        AttributeValue result;
        if (attributeValue1 == null) {
            result = new AttributeValue(value);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            for (String val : attributeValue1.getValues()) {
                list.add(val);
            }
            list.add(value);
            result = new AttributeValue(list);
            if (attributeValue1.isMasked()) {
                result.setMasked(true);
            }
        }
        return result;
    }

    protected List<String> getDatasourceAttributeList(SourceType dataSourceType, String attributeSourceId) {
        ArrayList<String> attribList = new ArrayList<String>();
        for (Map.Entry<String, List<AttrMappingValue>> entry : this.attributeMap.entrySet()) {
            List<AttrMappingValue> attribValList = entry.getValue();
            for (AttrMappingValue attribVal : attribValList) {
                if (attribVal.getType() == dataSourceType) {
                    if (attributeSourceId != null && attribVal.getAttributeSourceId() != null && !attributeSourceId.equals(attribVal.getAttributeSourceId())) continue;
                    attribList.add(attribVal.getValue());
                    continue;
                }
                if (attribVal.getType() == SourceType.TEXT) {
                    String rawText = attribVal.getValue();
                    for (String ref : Substituter.parseReferences((String)rawText)) {
                        if (!ref.startsWith(this.getDsAttrSourcePrefix(attributeSourceId))) continue;
                        ref = ref.substring(this.getDsAttrSourcePrefix(attributeSourceId).length());
                        attribList.add(ref);
                    }
                    continue;
                }
                if (attribVal.getType() != SourceType.EXPRESSION) continue;
                ExpressionManager expressionManager = ExpressionManager.getInstance();
                if (expressionManager.isEvaluateExpressionsOff()) {
                    log.warn((Object)NOT_AUTHORIZED_TO_MAP_OGNL);
                    continue;
                }
                try {
                    if (attribVal.getParsedExpression() == null) {
                        Object parsedExpression = Ognl.parseExpression((String)attribVal.getValue());
                        attribVal.setParsedExpression(parsedExpression);
                    }
                    OgnlHelper oh = new OgnlHelper(attribList, this.getDsAttrSourcePrefix(attributeSourceId));
                    oh.searchForDataColumns(attribVal.getParsedExpression());
                }
                catch (OgnlException e) {
                    log.debug((Object)e);
                }
            }
        }
        for (String reference : this.getReferencesInAllAttributeSourceFilters()) {
            String attributeSourcePrefix = this.getDsAttrSourcePrefix(attributeSourceId);
            if (reference == null || !reference.startsWith(attributeSourcePrefix)) continue;
            attribList.add(reference.substring(attributeSourcePrefix.length()));
        }
        List<TokenAuthorizationIssuanceCriterion> issuanceCriteria = this.getTokenAuthorizationIssuanceCriteria();
        if (issuanceCriteria != null) {
            for (TokenAuthorizationIssuanceCriterion criterion : issuanceCriteria) {
                if (StringUtils.isEmpty((String)criterion.getExpr())) {
                    if (criterion.getAttrSourceType() == null || !criterion.getAttrSourceType().equals((Object)dataSourceType) || !StringUtils.isEmpty((String)criterion.getAttrSourceId()) && !criterion.getAttrSourceId().equals(attributeSourceId)) continue;
                    attribList.add(criterion.getAttrName());
                    continue;
                }
                try {
                    OgnlHelper oh = new OgnlHelper(attribList, this.getDsAttrSourcePrefix(attributeSourceId));
                    Object parsedExpression = Ognl.parseExpression((String)criterion.getExpr());
                    oh.searchForDataColumns(parsedExpression);
                }
                catch (OgnlException e) {
                    log.debug((Object)e);
                }
            }
        }
        return attribList;
    }

    private List<String> getReferencesInAllAttributeSourceFilters() {
        ArrayList<String> references = new ArrayList<String>();
        for (AttributeSource attrSource : this.attributeSources) {
            references.addAll(attrSource.getFilterAttributeReferences());
        }
        return references;
    }

    public static AttributeMap createSubstitutionAttributes(HashMap<String, AttributeMap> srcAttributeMaps) {
        AttributeMap combinedMap = new AttributeMap();
        AttributeMap defaultMap = srcAttributeMaps.get(null);
        for (Map.Entry<String, AttributeMap> entry : srcAttributeMaps.entrySet()) {
            String attrSourceId = entry.getKey();
            AttributeMap attrMap = entry.getValue();
            if (attrSourceId == null) continue;
            boolean noPrefix = attrSourceId.equals(CONTEXT_SOURCE_TYPE_KEY) || attrSourceId.equals(SUBJECT_TOKEN_SOURCE_KEY_TYPE) || attrSourceId.equals(ACTOR_TOKEN_SOURCE_KEY_TYPE) || attrSourceId.equals(EXTENDED_CLIENT_METADATA_TYPE_KEY);
            Object friendlyAttrSourceId = attrSourceId;
            if (attrSourceId.startsWith(IDP_CONN_KEY_PREFIX)) {
                String realAttrSourceId = attrSourceId.substring(IDP_CONN_KEY_PREFIX.length());
                IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(realAttrSourceId, false);
                if (idpConn != null) {
                    friendlyAttrSourceId = IDP_CONN_KEY_PREFIX + idpConn.getEntityId();
                }
            }
            for (Map.Entry attrEntry : attrMap.entrySet()) {
                if (noPrefix) {
                    combinedMap.put((String)attrEntry.getKey(), (AttributeValue)attrEntry.getValue());
                    continue;
                }
                combinedMap.put((String)friendlyAttrSourceId + "." + (String)attrEntry.getKey(), (AttributeValue)attrEntry.getValue());
            }
        }
        if (defaultMap != null) {
            for (Map.Entry<String, Object> attrEntry : defaultMap.entrySet()) {
                combinedMap.put(attrEntry.getKey(), (AttributeValue)attrEntry.getValue());
            }
        }
        return combinedMap;
    }

    protected String getDsAttrSourcePrefix(String attributeSourceId) {
        Object prefix = DS_KEY_PREFIX;
        if (attributeSourceId != null) {
            prefix = (String)prefix + attributeSourceId + ".";
        }
        return prefix;
    }

    protected String constructDataSourceAttributeName(String attributeName, String attributeSourceId) {
        return attributeSourceId == null ? attributeName : attributeSourceId + "." + attributeName;
    }
}

