/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;

public enum AuthenticationResultEnum {
    USER_NOT_FOUND("User Not Found", "user.not.found", false),
    INVALID_CREDENTIALS("Invalid Credentials", "invalid.credentials", false),
    INVALID_CREDENTIALS_RECOVERABLE("Invalid Credentials", "invalid.credentials", true),
    NOT_PERMITTED_TO_LOGON_AT_THIS_TIME("Not Permitted To Logon At This Time", "not.permitted.to.logon.at.this.time", false),
    NOT_PERMITTED_TO_LOGON_AT_THIS_WORKSTATION("Not Permitted To Logon At This Workstation", "not.permitted.to.logon.at.this.workstation", false),
    PASSWORD_EXPIRED("Password Expired", "password.expired", true),
    ACCOUNT_DISABLED("Account Disabled", "account.disabled", false),
    ACCOUNT_EXPIRED("Account Expired", "account.expired", false),
    USER_MUST_RESET_PASSWORD("User Must Reset Password", "user.must.reset.password", true),
    USER_ACCOUNT_LOCKED("Account Locked", "user.account.locked", false),
    PASSWORD_POLICY_VIOLATED("Password Policy Violated", "password.policy.violated", true),
    USER_ALREADY_EXISTS("User Already Exists", "user.already.exists", true),
    ATTRIBUTE_VALUE_INVALID("Attribute Value Invalid", "attribute.value.invalid", true),
    ATTRIBUTE_CONFLICT("Attribute Conflict", "attribute.conflict", true),
    RETRY_LATER("Please Try Again Later", "default", false),
    NON_NUMERIC_TELEPHONE_NUMBER("Invalid Telephone Number", "non.numeric.telephone.number", true);

    private static final String MSG_KEY_PREFIX = "authn.srvr.msg.";
    private String id = "";
    private String displayName = "";
    private String messageKey = "";
    private boolean isRecoverable = false;

    private AuthenticationResultEnum(String displayName, String id, boolean recoverable) {
        this.id = id;
        this.displayName = displayName;
        this.messageKey = MSG_KEY_PREFIX + id;
        this.isRecoverable = recoverable;
    }

    public PasswordCredentialValidatorAuthnException newException() {
        return new PasswordCredentialValidatorAuthnException(this.isRecoverable, this.messageKey);
    }

    public String getId() {
        return this.id;
    }

    public static AuthenticationResultEnum getById(String id) {
        for (AuthenticationResultEnum value : AuthenticationResultEnum.values()) {
            if (!value.getId().equals(id)) continue;
            return value;
        }
        return null;
    }

    public static AuthenticationResultEnum getDefaultValue() {
        return INVALID_CREDENTIALS;
    }

    public static String[] getDisplayNames() {
        String[] s = new String[AuthenticationResultEnum.values().length];
        for (int i = 0; i < AuthenticationResultEnum.values().length; ++i) {
            s[i] = AuthenticationResultEnum.values()[i].getDisplayName();
        }
        return s;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public boolean isRecoverable() {
        return this.isRecoverable;
    }

    public boolean isError() {
        return true;
    }

    public boolean isSuccess() {
        return false;
    }
}

